/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import org.w3c.dom.Element;

public class HighScore
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(HighScore.class.getName());
    public static final int NUMBER_OF_HIGH_SCORES = 10;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    private int independenceTurn = -1;
    private String playerName;
    private String nationId;
    private String nationTypeId;
    private int score;
    private ScoreLevel level;
    private String nationName;
    private String difficulty;
    private int units;
    private int colonies;
    private String newLandName;
    private Date date;
    private int retirementTurn;
    private static final String HIGH_SCORES_TAG = "highScores";
    private static final String COLONIES_TAG = "colonies";
    private static final String DATE_TAG = "date";
    private static final String DIFFICULTY_TAG = "difficulty";
    private static final String INDEPENDENCE_TURN_TAG = "independenceTurn";
    private static final String LEVEL_TAG = "level";
    private static final String NATION_ID_TAG = "nationId";
    private static final String NATION_NAME_TAG = "nationName";
    private static final String NATION_TYPE_ID_TAG = "nationTypeId";
    private static final String NEW_LAND_NAME_TAG = "newLandName";
    private static final String PLAYER_NAME_TAG = "playerName";
    private static final String RETIREMENT_TURN_TAG = "retirementTurn";
    private static final String SCORE_TAG = "score";
    private static final String UNITS_TAG = "units";
    private static final String OLD_NATION_ID_TAG = "nationID";
    private static final String OLD_NATION_TYPE_ID_TAG = "nationTypeID";

    public HighScore(Player player, Date theDate) {
        Game game = player.getGame();
        this.date = theDate;
        this.retirementTurn = game.getTurn().getNumber();
        this.score = player.getScore();
        for (ScoreLevel someLevel : ScoreLevel.values()) {
            if (this.score < someLevel.getMinimumScore()) continue;
            this.level = someLevel;
            break;
        }
        this.playerName = player.getName();
        this.nationId = player.getNationId();
        this.nationTypeId = player.getNationType().getId();
        this.colonies = player.getColonies().size();
        this.units = player.getUnits().size();
        if (player.getPlayerType() == Player.PlayerType.INDEPENDENT) {
            this.independenceTurn = game.getTurn().getNumber();
            this.nationName = player.getIndependentNationName();
        } else {
            this.independenceTurn = -1;
        }
        this.difficulty = game.getSpecification().getDifficultyLevel();
        this.newLandName = player.getNewLandName();
    }

    public HighScore(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public HighScore(Element element) {
        this.readFromXMLElement(element);
    }

    public final int getIndependenceTurn() {
        return this.independenceTurn;
    }

    public final int getRetirementTurn() {
        return this.retirementTurn;
    }

    public final String getPlayerName() {
        return this.playerName;
    }

    public final String getNationId() {
        return this.nationId;
    }

    public final String getNationTypeId() {
        return this.nationTypeId;
    }

    public final int getScore() {
        return this.score;
    }

    public final ScoreLevel getLevel() {
        return this.level;
    }

    public final String getOldNationNameKey() {
        return Messages.nameKey(this.nationId);
    }

    public final String getNationName() {
        return this.nationName;
    }

    public final String getNewLandName() {
        return this.newLandName;
    }

    public final String getDifficulty() {
        return this.difficulty;
    }

    public final int getUnits() {
        return this.units;
    }

    public final int getColonies() {
        return this.colonies;
    }

    public final Date getDate() {
        return this.date;
    }

    private static void tidyScores(List<HighScore> scores) {
        if (scores.size() > 10) {
            scores = scores.subList(0, 9);
        }
        Collections.sort(scores);
    }

    public static boolean checkHighScore(int score, List<HighScore> scores) {
        return !FreeColDebugger.isInDebugMode() && score >= 0 && (scores.size() < 10 || score > scores.get(scores.size() - 1).getScore());
    }

    public static boolean newHighScore(Player player) {
        List<HighScore> scores = HighScore.loadHighScores();
        if (!HighScore.checkHighScore(player.getScore(), scores)) {
            return false;
        }
        HighScore hs = new HighScore(player, new Date());
        scores.add(hs);
        HighScore.tidyScores(scores);
        return HighScore.saveHighScores(scores);
    }

    public static List<HighScore> loadHighScores() {
        ArrayList<HighScore> scores = new ArrayList<HighScore>();
        File hsf = FreeColDirectories.getHighScoreFile();
        if (!hsf.exists()) {
            try {
                hsf.createNewFile();
                HighScore.saveHighScores(scores);
                logger.info("Created empty high score file: " + hsf.getPath());
            }
            catch (IOException ioe) {
                scores = null;
                logger.log(Level.WARNING, "Unable to create high score file: " + hsf.getPath(), ioe);
            }
            return scores;
        }
        try (FileInputStream fis = new FileInputStream(hsf);
             FreeColXMLReader xr = new FreeColXMLReader(fis);){
            xr.nextTag();
            while (xr.nextTag() != 2) {
                String tag = xr.getLocalName();
                if (!HighScore.getXMLElementTagName().equals(tag)) continue;
                scores.add(new HighScore(xr));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error loading high scores.", e);
        }
        HighScore.tidyScores(scores);
        return scores;
    }

    public static boolean saveHighScores(List<HighScore> scores) {
        boolean ret = false;
        if (scores == null) {
            return false;
        }
        HighScore.tidyScores(scores);
        File hsf = FreeColDirectories.getHighScoreFile();
        try (FileOutputStream fos = new FileOutputStream(hsf);
             FreeColXMLWriter xw = new FreeColXMLWriter(fos, FreeColXMLWriter.WriteScope.toSave(), true);){
            ret = true;
            xw.writeStartDocument("UTF-8", "1.0");
            xw.writeStartElement(HIGH_SCORES_TAG);
            int count = 0;
            for (HighScore score : scores) {
                score.toXML(xw);
                ++count;
            }
            xw.writeEndElement();
            xw.writeEndDocument();
            xw.flush();
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.WARNING, "Failed to open high scores file.", fnfe);
            ret = false;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error creating FreeColXMLWriter.", ioe);
            ret = false;
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "Failed to write high scores file.", xse);
            ret = false;
        }
        return ret;
    }

    @Override
    public int compareTo(FreeColObject other) {
        int cmp = 0;
        if (other instanceof HighScore) {
            HighScore hs = (HighScore)other;
            cmp = hs.getScore() - this.getScore();
        }
        if (cmp == 0) {
            cmp = super.compareTo(other);
        }
        return cmp;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeAttribute(DATE_TAG, this.date.getTime());
        xw.writeAttribute(RETIREMENT_TURN_TAG, this.retirementTurn);
        xw.writeAttribute(INDEPENDENCE_TURN_TAG, this.independenceTurn);
        xw.writeAttribute(PLAYER_NAME_TAG, this.playerName);
        xw.writeAttribute(NATION_ID_TAG, this.nationId);
        xw.writeAttribute(NATION_TYPE_ID_TAG, this.nationTypeId);
        xw.writeAttribute(SCORE_TAG, this.score);
        xw.writeAttribute(LEVEL_TAG, this.level.toString());
        if (this.nationName != null) {
            xw.writeAttribute(NATION_NAME_TAG, this.nationName);
        }
        if (this.newLandName != null) {
            xw.writeAttribute(NEW_LAND_NAME_TAG, this.newLandName);
        }
        xw.writeAttribute(DIFFICULTY_TAG, this.difficulty);
        xw.writeAttribute(UNITS_TAG, this.units);
        xw.writeAttribute(COLONIES_TAG, this.colonies);
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        long l = xr.getAttribute(DATE_TAG, -1L);
        Date date = this.date = l >= 0L ? new Date(l) : new Date();
        if (l < 0L) {
            String str = xr.getAttribute(DATE_TAG, "2014-07-01 00:00:00+0000");
            try {
                this.date = dateFormat.parse(str);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Bad date: " + str, e);
                this.date = new Date();
            }
        }
        this.retirementTurn = xr.getAttribute(RETIREMENT_TURN_TAG, 0);
        this.independenceTurn = xr.getAttribute(INDEPENDENCE_TURN_TAG, 0);
        this.playerName = xr.getAttribute(PLAYER_NAME_TAG, "anonymous");
        this.nationId = xr.getAttribute(NATION_ID_TAG, xr.getAttribute(OLD_NATION_ID_TAG, "model.nation.dutch"));
        this.nationTypeId = xr.getAttribute(NATION_TYPE_ID_TAG, xr.getAttribute(OLD_NATION_TYPE_ID_TAG, "model.nationType.trade"));
        this.score = xr.getAttribute(SCORE_TAG, 0);
        this.level = xr.getAttribute(LEVEL_TAG, ScoreLevel.class, ScoreLevel.PARASITIC_WORM);
        this.nationName = xr.getAttribute(NATION_NAME_TAG, "Freedonia");
        this.newLandName = xr.getAttribute(NEW_LAND_NAME_TAG, "New World");
        this.difficulty = xr.getAttribute(DIFFICULTY_TAG, FreeCol.getDifficulty());
        this.units = xr.getAttribute(UNITS_TAG, 0);
        this.colonies = xr.getAttribute(COLONIES_TAG, 0);
    }

    @Override
    public String getXMLTagName() {
        return HighScore.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "highScore";
    }

    public static enum ScoreLevel {
        CONTINENT(40000),
        COUNTRY(35000),
        STATE(30000),
        CITY(25000),
        MOUNTAIN_RANGE(20000),
        RIVER(15000),
        INSTITUTE(12000),
        UNIVERSITY(10000),
        STREET(8000),
        SCHOOL(7000),
        BIRD_OF_PREY(6000),
        TREE(5000),
        FLOWER(4000),
        RODENT(3200),
        FOUL_SMELLING_PLANT(2400),
        POISONOUS_PLANT(1600),
        SLIME_MOLD_BEETLE(800),
        BLOOD_SUCKING_INSECT(400),
        INFECTIOUS_DISEASE(200),
        PARASITIC_WORM(0);

        private int minimumScore;

        private ScoreLevel(int minimumScore) {
            this.minimumScore = minimumScore;
        }

        public int getMinimumScore() {
            return this.minimumScore;
        }
    }
}

