/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;

public class GoodsTradeItem
extends TradeItem {
    private Goods goods;

    public GoodsTradeItem(Game game, Player source, Player destination, Goods goods) {
        super(game, "tradeItem.goods", source, destination);
        this.goods = goods;
    }

    public GoodsTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.goods != null && this.goods.getType() != null && this.goods.getAmount() > 0 && this.goods.getLocation() instanceof Ownable && this.getSource().owns((Ownable)((Object)this.goods.getLocation()));
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public StringTemplate getLabel() {
        return this.goods.getLabel(true);
    }

    @Override
    public Goods getGoods() {
        return this.goods;
    }

    @Override
    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        this.goods.toXML(xw);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.goods = null;
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (Goods.getXMLElementTagName().equals(tag)) {
            this.goods = new Goods(game, xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" ").append(this.goods.getAmount()).append(" ").append(Messages.getName(this.goods)).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return GoodsTradeItem.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "goodsTradeItem";
    }
}

