/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;

public class GoldTradeItem
extends TradeItem {
    private int gold;
    private static final String GOLD_TAG = "gold";

    public GoldTradeItem(Game game, Player source, Player destination, int gold) {
        super(game, "tradeItem.gold", source, destination);
        this.gold = gold;
    }

    public GoldTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.gold >= 0 && this.getSource().checkGold(this.gold);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public StringTemplate getLabel() {
        return StringTemplate.template("tradeItem.gold.long").addAmount("%amount%", this.gold);
    }

    @Override
    public int getGold() {
        return this.gold;
    }

    @Override
    public void setGold(int gold) {
        this.gold = gold;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(GOLD_TAG, this.gold);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.gold = xr.getAttribute(GOLD_TAG, Integer.MIN_VALUE);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" ").append(this.gold).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return GoldTradeItem.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "goldTradeItem";
    }
}

