/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;

public class FoundingFather
extends FreeColGameObjectType {
    private FoundingFatherType type;
    private int[] weight = new int[Turn.NUMBER_OF_AGES];
    private List<Scope> scopes = null;
    private List<Event> events = null;
    private Map<UnitType, UnitType> upgrades = null;
    private List<AbstractUnit> units = null;
    private static final String FROM_ID_TAG = "from-id";
    private static final String TO_ID_TAG = "to-id";
    private static final String TYPE_TAG = "type";
    private static final String UNIT_TAG = "unit";
    private static final String UPGRADE_TAG = "upgrade";
    private static final String WEIGHT_TAG = "weight";

    public FoundingFather(String id, Specification specification) {
        super(id, specification);
    }

    public FoundingFatherType getType() {
        return this.type;
    }

    public void setType(FoundingFatherType type) {
        this.type = type;
    }

    public String getTypeKey() {
        return FoundingFather.getTypeKey(this.type);
    }

    public static String getTypeKey(FoundingFatherType type) {
        return "model.foundingFather." + type.toString().toLowerCase(Locale.US);
    }

    public int getWeight(int age) {
        return age >= 1 && age <= this.weight.length ? this.weight[age - 1] : 0;
    }

    public final List<Event> getEvents() {
        return this.events == null ? Collections.emptyList() : this.events;
    }

    public final void setEvents(List<Event> newEvents) {
        this.events = newEvents;
    }

    private void addEvent(Event event) {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        this.events.add(event);
    }

    public final List<Scope> getScopes() {
        return this.scopes == null ? Collections.emptyList() : this.scopes;
    }

    public final void setScopes(List<Scope> newScopes) {
        this.scopes = newScopes;
    }

    private void addScope(Scope scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<Scope>();
        }
        this.scopes.add(scope);
    }

    public final Map<UnitType, UnitType> getUpgrades() {
        return this.upgrades == null ? Collections.emptyMap() : this.upgrades;
    }

    public final void setUpgrades(Map<UnitType, UnitType> newUpgrades) {
        this.upgrades = newUpgrades;
    }

    private void addUpgrade(UnitType fromType, UnitType toType) {
        if (this.upgrades == null) {
            this.upgrades = new HashMap<UnitType, UnitType>();
        }
        this.upgrades.put(fromType, toType);
    }

    public final List<AbstractUnit> getUnits() {
        return this.units == null ? Collections.emptyList() : this.units;
    }

    public final void setUnits(List<AbstractUnit> newUnits) {
        this.units = newUnits;
    }

    private void addUnit(AbstractUnit unit) {
        if (this.units == null) {
            this.units = new ArrayList<AbstractUnit>();
        }
        this.units.add(unit);
    }

    public boolean isAvailableTo(Player player) {
        if (!player.isEuropean()) {
            return false;
        }
        if (this.scopes == null) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TYPE_TAG, this.type);
        for (int i = 0; i < this.weight.length; ++i) {
            xw.writeAttribute(WEIGHT_TAG + (i + 1), this.weight[i]);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Event event : this.getEvents()) {
            event.toXML(xw);
        }
        for (Scope scope : this.getScopes()) {
            scope.toXML(xw);
        }
        for (AbstractUnit abstractUnit : this.getUnits()) {
            xw.writeStartElement(UNIT_TAG);
            xw.writeAttribute("id", abstractUnit);
            xw.writeEndElement();
        }
        if (this.upgrades != null) {
            for (Map.Entry entry : this.upgrades.entrySet()) {
                xw.writeStartElement(UPGRADE_TAG);
                xw.writeAttribute(FROM_ID_TAG, ((UnitType)entry.getKey()).getId());
                xw.writeAttribute(TO_ID_TAG, ((UnitType)entry.getValue()).getId());
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.type = xr.getAttribute(TYPE_TAG, FoundingFatherType.class, null);
        for (int i = 0; i < this.weight.length; ++i) {
            this.weight[i] = xr.getAttribute(WEIGHT_TAG + (i + 1), 0);
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.events = null;
            this.scopes = null;
            this.units = null;
            this.upgrades = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (UPGRADE_TAG.equals(tag)) {
            UnitType fromType = xr.getType(spec, FROM_ID_TAG, UnitType.class, null);
            UnitType toType = xr.getType(spec, TO_ID_TAG, UnitType.class, null);
            this.addUpgrade(fromType, toType);
            xr.closeTag(UPGRADE_TAG);
        } else if (UNIT_TAG.equals(tag)) {
            this.addUnit(new AbstractUnit(xr));
        } else if (Event.getXMLElementTagName().equals(tag)) {
            this.addEvent(new Event(xr, spec));
        } else if (Scope.getXMLElementTagName().equals(tag)) {
            this.addScope(new Scope(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return FoundingFather.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "founding-father";
    }

    public static enum FoundingFatherType {
        TRADE,
        EXPLORATION,
        MILITARY,
        POLITICAL,
        RELIGIOUS;

    }
}

