/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.Utils;

public abstract class Feature
extends FreeColObject
implements Named {
    private FreeColObject source;
    private Turn firstTurn;
    private Turn lastTurn;
    private int duration = 0;
    private boolean temporary;
    private List<Scope> scopes = null;
    private static final String DURATION_TAG = "duration";
    private static final String FIRST_TURN_TAG = "firstTurn";
    private static final String LAST_TURN_TAG = "lastTurn";
    private static final String SOURCE_TAG = "source";
    private static final String TEMPORARY_TAG = "temporary";

    protected void copyFrom(Feature other) {
        this.setId(other.getId());
        this.source = other.source;
        this.firstTurn = other.firstTurn;
        this.lastTurn = other.lastTurn;
        this.duration = other.duration;
        this.temporary = other.temporary;
        this.setScopes(other.getScopes());
    }

    public final boolean hasTimeLimit() {
        return this.firstTurn != null || this.lastTurn != null;
    }

    public final Turn getFirstTurn() {
        return this.firstTurn;
    }

    public final void setFirstTurn(Turn newFirstTurn) {
        this.firstTurn = newFirstTurn;
    }

    public final Turn getLastTurn() {
        return this.lastTurn;
    }

    public final void setLastTurn(Turn newLastTurn) {
        this.lastTurn = newLastTurn;
    }

    public final boolean hasScope() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public final List<Scope> getScopes() {
        return this.scopes == null ? Collections.emptyList() : this.scopes;
    }

    public final void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public void addScope(Scope scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<Scope>();
        }
        this.scopes.add(scope);
    }

    public final FreeColObject getSource() {
        return this.source;
    }

    public final void setSource(FreeColObject newSource) {
        this.source = newSource;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final void setDuration(int newDuration) {
        this.duration = newDuration;
    }

    public final boolean isTemporary() {
        return this.temporary;
    }

    public final void setTemporary(boolean newTemporary) {
        this.temporary = newTemporary;
    }

    public boolean appliesTo(FreeColGameObjectType objectType) {
        if (!this.hasScope()) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(objectType)) continue;
            return true;
        }
        return false;
    }

    protected boolean appliesTo(Turn turn) {
        return turn == null || (this.firstTurn == null || turn.getNumber() >= this.firstTurn.getNumber()) && (this.lastTurn == null || turn.getNumber() <= this.lastTurn.getNumber());
    }

    protected boolean appliesTo(FreeColGameObjectType objectType, Turn turn) {
        return this.appliesTo(turn) && this.appliesTo(objectType);
    }

    public boolean isOutOfDate(Turn turn) {
        return turn != null && this.lastTurn != null && turn.getNumber() > this.lastTurn.getNumber();
    }

    public boolean isIndependent() {
        return !(this.source instanceof BuildingType) && !(this.source instanceof FoundingFather) && !(this.source instanceof NationType);
    }

    @Override
    public String getNameKey() {
        return Messages.nameKey(this.getId());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Feature) {
            Feature feature = (Feature)o;
            if (!super.equals(o) || this.source != feature.source || this.duration != feature.duration || this.temporary != feature.temporary) {
                return false;
            }
            if (this.firstTurn == null) {
                if (feature.firstTurn != null) {
                    return false;
                }
            } else {
                if (feature.firstTurn == null) {
                    return false;
                }
                if (this.firstTurn.getNumber() != feature.firstTurn.getNumber()) {
                    return false;
                }
            }
            if (this.lastTurn == null) {
                if (feature.lastTurn != null) {
                    return false;
                }
            } else {
                if (feature.lastTurn == null) {
                    return false;
                }
                if (this.lastTurn.getNumber() != feature.lastTurn.getNumber()) {
                    return false;
                }
            }
            if (this.scopes == null) {
                if (feature.scopes != null) {
                    return false;
                }
            } else {
                if (feature.scopes == null) {
                    return false;
                }
                for (Scope scope : this.scopes) {
                    if (feature.scopes.contains(scope)) continue;
                    return false;
                }
                for (Scope scope : feature.scopes) {
                    if (this.scopes.contains(scope)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash += 31 * hash + Utils.hashCode(this.source);
        hash += 31 * hash + (this.firstTurn == null ? 0 : this.firstTurn.getNumber());
        hash += 31 * hash + (this.lastTurn == null ? 0 : this.lastTurn.getNumber());
        hash += 31 * hash + this.duration;
        hash += 31 * (this.temporary ? 1 : 0);
        if (this.scopes != null) {
            for (Scope scope : this.scopes) {
                hash += Utils.hashCode(scope);
            }
        }
        return hash;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.getSource() != null) {
            xw.writeAttribute(SOURCE_TAG, this.getSource());
        }
        if (this.getFirstTurn() != null) {
            xw.writeAttribute(FIRST_TURN_TAG, this.getFirstTurn().getNumber());
        }
        if (this.getLastTurn() != null) {
            xw.writeAttribute(LAST_TURN_TAG, this.getLastTurn().getNumber());
        }
        if (this.duration != 0) {
            xw.writeAttribute(DURATION_TAG, this.duration);
        }
        if (this.temporary) {
            xw.writeAttribute(TEMPORARY_TAG, this.temporary);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Scope scope : this.getScopes()) {
            scope.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        int lastTurn;
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        String str = xr.getAttribute(SOURCE_TAG, null);
        if (str == null) {
            this.setSource(null);
        } else if (spec != null) {
            this.setSource(spec.findType(str));
        }
        int firstTurn = xr.getAttribute(FIRST_TURN_TAG, Integer.MIN_VALUE);
        if (firstTurn != Integer.MIN_VALUE) {
            this.setFirstTurn(new Turn(firstTurn));
        }
        if ((lastTurn = xr.getAttribute(LAST_TURN_TAG, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            this.setLastTurn(new Turn(lastTurn));
        }
        this.duration = xr.getAttribute(DURATION_TAG, 0);
        this.temporary = xr.getAttribute(TEMPORARY_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.scopes = null;
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (Scope.getXMLElementTagName().equals(tag)) {
            this.addScope(new Scope(xr));
        } else {
            super.readChild(xr);
        }
    }
}

