/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import org.w3c.dom.Element;

public class ExportData
extends FreeColObject {
    private static final int HIGH_LEVEL_DEFAULT = 90;
    private static final int LOW_LEVEL_DEFAULT = 10;
    private static final int EXPORT_LEVEL_DEFAULT = 50;
    private int highLevel = 90;
    private int lowLevel = 10;
    private int exportLevel = 50;
    private boolean exported = false;
    private static final String EXPORTED_TAG = "exported";
    private static final String EXPORT_LEVEL_TAG = "exportLevel";
    private static final String HIGH_LEVEL_TAG = "highLevel";
    private static final String LOW_LEVEL_TAG = "lowLevel";

    public ExportData(GoodsType goodsType) {
        this.setId(goodsType.getId());
    }

    public ExportData(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public ExportData(Element element) {
        this.readFromXMLElement(element);
    }

    public final int getHighLevel() {
        return this.highLevel;
    }

    public final void setHighLevel(int newHighLevel) {
        this.highLevel = newHighLevel;
    }

    public final int getLowLevel() {
        return this.lowLevel;
    }

    public final void setLowLevel(int newLowLevel) {
        this.lowLevel = newLowLevel;
    }

    public final int getExportLevel() {
        return this.exportLevel;
    }

    public final void setExportLevel(int newExportLevel) {
        this.exportLevel = newExportLevel;
    }

    public final boolean getExported() {
        return this.exported;
    }

    public final void setExported(boolean newExport) {
        this.exported = newExport;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(EXPORTED_TAG, this.exported);
        xw.writeAttribute(HIGH_LEVEL_TAG, this.highLevel);
        xw.writeAttribute(LOW_LEVEL_TAG, this.lowLevel);
        xw.writeAttribute(EXPORT_LEVEL_TAG, this.exportLevel);
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.exported = xr.getAttribute(EXPORTED_TAG, false);
        this.highLevel = xr.getAttribute(HIGH_LEVEL_TAG, 90);
        this.lowLevel = xr.getAttribute(LOW_LEVEL_TAG, 10);
        this.exportLevel = xr.getAttribute(EXPORT_LEVEL_TAG, 50);
    }

    @Override
    public String getXMLTagName() {
        return ExportData.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "exportData";
    }
}

