/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Unit;

public class EuropeWas {
    private static final Logger logger = Logger.getLogger(EuropeWas.class.getName());
    private Europe europe;
    private int unitCount;

    public EuropeWas(Europe europe) {
        this.europe = europe;
        this.unitCount = europe.getUnitCount();
    }

    public Unit getNewUnit() {
        if (this.europe.getUnitCount() < this.unitCount + 1) {
            return null;
        }
        Unit newUnit = null;
        int idMax = 0;
        String unitPrefix = Unit.getXMLElementTagName() + ":";
        for (Unit u : this.europe.getUnitList()) {
            String uid = u.getId();
            if (!uid.startsWith(unitPrefix)) continue;
            try {
                int id = Integer.parseInt(uid.substring(unitPrefix.length()));
                if (idMax >= id) continue;
                idMax = id;
                newUnit = u;
            }
            catch (NumberFormatException nfe) {}
        }
        return newUnit;
    }

    public void fireChanges() {
        int newUnitCount = this.europe.getUnitCount();
        if (newUnitCount != this.unitCount) {
            this.europe.firePropertyChange("unitChange", this.unitCount, newUnitCount);
        }
    }
}

