/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceFactory;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class FreeColDataFile {
    private static final Logger logger = Logger.getLogger(FreeColDataFile.class.getName());
    private static final Set<String> FILE_ENDINGS = CollectionUtils.makeUnmodifiableSet(".zip");
    private static final String RESOURCE_FILE_PREFIX = "resources";
    private static final String RESOURCE_FILE_SUFFIX = ".properties";
    private static final String resourceScheme = "resource:";
    private final File file;
    private final String jarDirectory;

    public FreeColDataFile(File file) throws IOException {
        if (!file.exists()) {
            for (String ending : FreeColDataFile.getFileEndings()) {
                File tempFile = new File(file.getAbsolutePath() + ending);
                if (!tempFile.exists()) continue;
                file = tempFile;
                break;
            }
        }
        if (!file.exists()) {
            throw new IOException("File " + file.getName() + " does not exist");
        }
        this.file = file;
        if (file.isDirectory()) {
            this.jarDirectory = null;
        } else {
            String jarName = file.getName().substring(0, file.getName().lastIndexOf(46));
            this.jarDirectory = FreeColDataFile.findJarDirectory(jarName, file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findJarDirectory(String expectedName, File file) {
        try (JarFile jf = new JarFile(file);){
            JarEntry entry = jf.entries().nextElement();
            String en = entry.getName();
            int index = en.lastIndexOf(47);
            String name = "";
            if (index > 0) {
                name = en.substring(0, index + 1);
            }
            String string = name;
            return string;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while reading data file.", e);
            return expectedName;
        }
    }

    public static List<String> getFileNames(String prefix, String suffix, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        ArrayList<String> result = new ArrayList<String>(4);
        if (!"".equals(language)) {
            language = "_" + language;
        }
        if (!"".equals(country)) {
            country = "_" + country;
        }
        if (!"".equals(variant)) {
            variant = "_" + variant;
        }
        result.add(prefix + suffix);
        String filename = prefix + language + suffix;
        if (!result.contains(filename)) {
            result.add(filename);
        }
        if (!result.contains(filename = prefix + language + country + suffix)) {
            result.add(filename);
        }
        if (!result.contains(filename = prefix + language + country + variant + suffix)) {
            result.add(filename);
        }
        return result;
    }

    public static List<String> getResourceFileNames() {
        return FreeColDataFile.getFileNames(RESOURCE_FILE_PREFIX, RESOURCE_FILE_SUFFIX, Locale.getDefault());
    }

    protected URI getURI(String name) {
        try {
            if (name.startsWith("urn:")) {
                try {
                    return new URI(name);
                }
                catch (URISyntaxException e) {
                    logger.log(Level.WARNING, "Resource creation failure with: " + name, e);
                    return null;
                }
            }
            if (this.file.isDirectory()) {
                return new File(this.file, name).toURI();
            }
            return new URI("jar:file", this.file + "!/" + this.jarDirectory + name, null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to lookup: " + this.file + "/" + name, e);
            return null;
        }
    }

    public BufferedInputStream getInputStream(String filename) throws IOException {
        URLConnection connection = this.getURI(filename).toURL().openConnection();
        connection.setDefaultUseCaches(false);
        return new BufferedInputStream(connection.getInputStream());
    }

    public ResourceMapping getResourceMapping() {
        Properties properties = new Properties();
        for (String fileName : FreeColDataFile.getResourceFileNames()) {
            try {
                BufferedInputStream is = this.getInputStream(fileName);
                Throwable throwable = null;
                try {
                    properties.load(is);
                    logger.info("ResourceMapping loaded: " + this.file + "/" + fileName);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
            catch (FileNotFoundException e) {
                logger.finest("ResourceMapping not found: " + this.file + "/" + fileName);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "ResourceMapping read exception: " + this.file + "/" + fileName, e);
                return null;
            }
        }
        ResourceMapping rc = new ResourceMapping();
        ArrayList<String> todo = new ArrayList<String>();
        Enumeration<?> pn = properties.propertyNames();
        while (pn.hasMoreElements()) {
            String key = (String)pn.nextElement();
            String value = properties.getProperty(key);
            if (value.startsWith(resourceScheme)) {
                todo.add(key);
                continue;
            }
            URI uri = this.getURI(value);
            if (uri == null) continue;
            rc.add(key, ResourceFactory.createResource(uri));
        }
        boolean progress = true;
        ArrayList<String> miss = new ArrayList<String>();
        while (progress && !todo.isEmpty()) {
            miss.clear();
            progress = false;
            while (!todo.isEmpty()) {
                String key = (String)todo.remove(0);
                String value = properties.getProperty(key).substring(resourceScheme.length());
                Resource r = rc.get(value);
                if (r == null) {
                    miss.add(key);
                    continue;
                }
                rc.add(key, r);
                progress = true;
            }
            todo.addAll(miss);
        }
        if (!todo.isEmpty()) {
            logger.warning("Could not resolve virtual resource/s: " + StringUtils.join(" ", todo));
        }
        return rc;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                for (String ending : FreeColDataFile.getFileEndings()) {
                    if (!name.endsWith(ending)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    protected static Set<String> getFileEndings() {
        return FILE_ENDINGS;
    }
}

