/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;

public final class WarehouseDialog
extends FreeColConfirmDialog {
    private static final Logger logger = Logger.getLogger(WarehouseDialog.class.getName());
    private JPanel warehousePanel = new MigPanel(new MigLayout("wrap 4"));

    public WarehouseDialog(FreeColClient freeColClient, Colony colony) {
        super(freeColClient);
        this.warehousePanel.setOpaque(false);
        for (GoodsType type : freeColClient.getGame().getSpecification().getGoodsTypeList()) {
            if (!type.isStorable()) continue;
            this.warehousePanel.add(new WarehouseGoodsPanel(freeColClient, colony, type));
        }
        JScrollPane scrollPane = new JScrollPane(this.warehousePanel, 20, 30);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        MigPanel panel = new MigPanel(new MigLayout("fill, wrap 1", "", ""));
        String str = Messages.message("warehouseDialog.name");
        panel.add((Component)GUI.getDefaultHeader(str), "align center");
        panel.add((Component)scrollPane, "grow");
        panel.setSize(panel.getPreferredSize());
        ImageIcon icon = this.getGUI().getImageLibrary().getImageIcon(colony, true);
        this.initializeConfirmDialog(true, panel, icon, "ok", "cancel");
    }

    @Override
    public Boolean getResponse() {
        Boolean result = (Boolean)super.getResponse();
        if (result.booleanValue()) {
            for (Component c : this.warehousePanel.getComponents()) {
                if (!(c instanceof WarehouseGoodsPanel)) continue;
                ((WarehouseGoodsPanel)c).saveSettings();
            }
        }
        this.warehousePanel = null;
        return result;
    }

    private class WarehouseGoodsPanel
    extends MigPanel {
        private final Colony colony;
        private final GoodsType goodsType;
        private final JCheckBox export;
        private final JSpinner lowLevel;
        private final JSpinner highLevel;
        private final JSpinner exportLevel;

        public WarehouseGoodsPanel(FreeColClient freeColClient, Colony colony, GoodsType goodsType) {
            super("WarehouseGoodsPanelUI");
            this.colony = colony;
            this.goodsType = goodsType;
            this.setLayout(new MigLayout("wrap 2", "", ""));
            this.setOpaque(false);
            String goodsName = Messages.getName(goodsType);
            this.setBorder(GUI.localizedBorder(goodsType.getNameKey()));
            GUI.padBorder(this, 6, 6, 6, 6);
            ExportData exportData = colony.getExportData(goodsType);
            Goods goods = new Goods(colony.getGame(), colony, goodsType, colony.getGoodsCount(goodsType));
            GoodsLabel goodsLabel = new GoodsLabel(goods, WarehouseDialog.this.getGUI());
            goodsLabel.setHorizontalAlignment(10);
            this.add((Component)goodsLabel, "span 1 2");
            SpinnerNumberModel lowLevelModel = new SpinnerNumberModel(exportData.getLowLevel(), 0, 100, 1);
            this.lowLevel = new JSpinner(lowLevelModel);
            GUI.localizeToolTip((JComponent)this.lowLevel, "warehouseDialog.lowLevel.shortDescription");
            this.add(this.lowLevel);
            SpinnerNumberModel highLevelModel = new SpinnerNumberModel(exportData.getHighLevel(), 0, 100, 1);
            this.highLevel = new JSpinner(highLevelModel);
            GUI.localizeToolTip((JComponent)this.highLevel, "warehouseDialog.highLevel.shortDescription");
            this.add(this.highLevel);
            this.export = new JCheckBox(Messages.message("warehouseDialog.export"), exportData.getExported());
            GUI.localizeToolTip((JComponent)this.export, "warehouseDialog.export.shortDescription");
            if (!colony.hasAbility("model.ability.export")) {
                this.export.setEnabled(false);
            }
            this.add(this.export);
            SpinnerNumberModel exportLevelModel = new SpinnerNumberModel(exportData.getExportLevel(), 0, colony.getWarehouseCapacity(), 1);
            this.exportLevel = new JSpinner(exportLevelModel);
            GUI.localizeToolTip((JComponent)this.exportLevel, "warehouseDialog.exportLevel.shortDescription");
            this.add(this.exportLevel);
            this.setSize(this.getPreferredSize());
        }

        public void saveSettings() {
            int lowLevelValue = ((SpinnerNumberModel)this.lowLevel.getModel()).getNumber().intValue();
            int highLevelValue = ((SpinnerNumberModel)this.highLevel.getModel()).getNumber().intValue();
            int exportLevelValue = ((SpinnerNumberModel)this.exportLevel.getModel()).getNumber().intValue();
            ExportData exportData = this.colony.getExportData(this.goodsType);
            boolean changed = this.export.isSelected() != exportData.getExported() || lowLevelValue != exportData.getLowLevel() || highLevelValue != exportData.getHighLevel() || exportLevelValue != exportData.getExportLevel();
            exportData.setExported(this.export.isSelected());
            exportData.setLowLevel(lowLevelValue);
            exportData.setHighLevel(highLevelValue);
            exportData.setExportLevel(exportLevelValue);
            if (changed) {
                WarehouseDialog.this.freeColClient.getInGameController().setGoodsLevels(this.colony, this.goodsType);
            }
        }
    }
}

