/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;

public abstract class UnitPanel
extends MigPanel
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(UnitPanel.class.getName());
    private PortPanel portPanel;
    private boolean editable;

    public UnitPanel(PortPanel portPanel, String name, boolean editable) {
        if (portPanel == null) {
            throw new RuntimeException("Null port panel.");
        }
        this.portPanel = portPanel;
        this.editable = editable;
        this.setName(name);
    }

    public void initialize() {
        this.cleanup();
        this.addPropertyChangeListeners();
        this.update();
    }

    public void cleanup() {
        this.removePropertyChangeListeners();
    }

    protected void addPropertyChangeListeners() {
    }

    protected void removePropertyChangeListeners() {
    }

    public void update() {
        this.removeAll();
        if (this.portPanel != null) {
            for (Unit unit : this.portPanel.getUnitList()) {
                if (!this.accepts(unit)) continue;
                UnitLabel unitLabel = new UnitLabel(this.portPanel.getFreeColClient(), unit);
                TradeRoute tradeRoute = unit.getTradeRoute();
                if (tradeRoute != null) {
                    unitLabel.setDescriptionLabel(unit.getDescription(Unit.UnitLabelType.NATIONAL) + " (" + tradeRoute.getName() + ")");
                }
                if (this.editable) {
                    unitLabel.setTransferHandler(this.portPanel.getTransferHandler());
                    unitLabel.addMouseListener(this.portPanel.getPressListener());
                }
                this.add(unitLabel);
            }
        }
        this.selectLabel();
        this.revalidate();
        this.repaint();
    }

    public PortPanel getPortPanel() {
        return this.portPanel;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public abstract boolean accepts(Unit var1);

    public void selectLabel() {
    }

    public boolean setSelectedUnit(Unit unit) {
        for (Component component : this.getComponents()) {
            UnitLabel label;
            if (!(component instanceof UnitLabel) || (label = (UnitLabel)component).getUnit() != unit) continue;
            this.getPortPanel().setSelectedUnitLabel(label);
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest(this.getName() + " change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
        this.update();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removePropertyChangeListeners();
        this.portPanel = null;
    }
}

