/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.Draggable;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.StringUtils;

public final class UnitLabel
extends JLabel
implements ActionListener,
Draggable {
    private static Logger logger = Logger.getLogger(UnitLabel.class.getName());
    private final FreeColClient freeColClient;
    private final GUI gui;
    private final Unit unit;
    private boolean selected;
    private boolean isSmall = false;
    private boolean ignoreLocation;

    public UnitLabel(FreeColClient freeColClient, Unit unit) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
        this.unit = unit;
        this.selected = false;
        this.setSmall(false);
        this.setIgnoreLocation(false);
        this.updateIcon();
    }

    public UnitLabel(FreeColClient freeColClient, Unit unit, boolean isSmall) {
        this(freeColClient, unit);
        this.setSmall(isSmall);
        this.setIgnoreLocation(false);
    }

    public UnitLabel(FreeColClient freeColClient, Unit unit, boolean isSmall, boolean ignoreLocation) {
        this(freeColClient, unit);
        this.setSmall(isSmall);
        this.setIgnoreLocation(ignoreLocation);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public void setIgnoreLocation(boolean b) {
        this.ignoreLocation = b;
    }

    public void setSmall(boolean isSmall) {
        ImageLibrary lib = this.gui.getImageLibrary();
        ImageIcon imageIcon = lib.getUnitImageIcon(this.unit);
        ImageIcon disabledImageIcon = lib.getUnitImageIcon(this.unit, true);
        if (isSmall) {
            this.setPreferredSize(null);
            if (imageIcon != null) {
                this.setIcon(new ImageIcon(imageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() / 3 * 2, imageIcon.getIconHeight() / 3 * 2, 4)));
            }
            if (disabledImageIcon != null && imageIcon != null) {
                this.setDisabledIcon(new ImageIcon(disabledImageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() / 3 * 2, imageIcon.getIconHeight() / 3 * 2, 4)));
            }
            this.setBorder(GUI.blankBorder(0, 2, 0, 0));
            this.isSmall = true;
        } else {
            if (this.unit.getLocation() instanceof ColonyTile) {
                Tile tile = ((ColonyTile)this.unit.getLocation()).getTile();
                TileType tileType = tile.getType();
                Image image = lib.getTerrainImage(tileType, tile.getX(), tile.getY());
                this.setSize(new Dimension(image.getWidth(null) / 2, imageIcon.getIconHeight()));
            } else {
                this.setPreferredSize(null);
            }
            this.setIcon(imageIcon);
            this.setDisabledIcon(disabledImageIcon);
            this.setBorder(this.unit.getLocation() instanceof ColonyTile ? GUI.blankBorder(0, 15, 0, 15) : GUI.blankBorder(0, 5, 0, 5));
            this.isSmall = false;
        }
    }

    public String getDescriptionLabel() {
        return this.getToolTipText();
    }

    public void setDescriptionLabel(String label) {
        this.setToolTipText(label);
    }

    @Override
    public void paintComponent(Graphics g) {
        Player player = this.freeColClient.getMyPlayer();
        if (this.ignoreLocation || this.selected || !this.unit.isCarrier() && this.unit.getState() != Unit.UnitState.SENTRY) {
            this.setEnabled(true);
        } else if (this.unit.getOwner() != player && this.unit.getColony() == null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        super.paintComponent(g);
        if (this.ignoreLocation) {
            return;
        }
        if (this.unit.getLocation() instanceof ColonyTile) {
            GoodsType workType = this.unit.getWorkType();
            if (workType != null) {
                int production = ((ColonyTile)this.unit.getLocation()).getTotalProductionOf(workType);
                ProductionLabel pl = new ProductionLabel(this.freeColClient, workType, production);
                g.translate(0, 10);
                pl.paintComponent(g);
                g.translate(0, -10);
            }
        } else if (this.getParent() instanceof ColonyPanel.OutsideColonyPanel || this.getParent() instanceof InPortPanel || this.getParent() instanceof EuropePanel.DocksPanel || this.getParent().getParent() instanceof ReportPanel) {
            String text = Messages.message(this.unit.getOccupationKey(player.owns(this.unit)));
            ImageLibrary lib = this.gui.getImageLibrary();
            g.drawImage(lib.getOccupationIndicatorChip(this.unit, text), 0, 0, null);
            if (this.unit.isDamaged()) {
                String underRepair = Messages.message(StringTemplate.template("underRepair").addAmount("%turns%", this.unit.getTurnsForRepair()));
                String underRepair1 = underRepair.substring(0, underRepair.indexOf(40)).trim();
                String underRepair2 = underRepair.substring(underRepair.indexOf(40)).trim();
                Font font = GUI.LESS_TINY_DEFAULT_FONT;
                Image repairImage1 = ImageLibrary.getStringImage((Graphics2D)g, underRepair1, Color.RED, font);
                Image repairImage2 = ImageLibrary.getStringImage((Graphics2D)g, underRepair2, Color.RED, font);
                int textHeight = repairImage1.getHeight(null) + repairImage2.getHeight(null);
                int leftIndent = Math.min(5, Math.min(this.getWidth() - repairImage1.getWidth(null), this.getWidth() - repairImage2.getWidth(null)));
                g.drawImage(repairImage1, leftIndent, (this.getHeight() - textHeight) / 2, null);
                g.drawImage(repairImage2, leftIndent, (this.getHeight() - textHeight) / 2 + repairImage1.getHeight(null), null);
            }
        }
    }

    public void updateIcon() {
        ImageLibrary lib = this.gui.getImageLibrary();
        this.setIcon(lib.getUnitImageIcon(this.unit));
        this.setDisabledIcon(lib.getUnitImageIcon(this.unit, true));
        this.setDescriptionLabel(this.unit.getDescription(Unit.UnitLabelType.FULL));
        this.setSmall(this.isSmall);
    }

    public boolean canUnitBeEquippedWith(JLabel data) {
        return this.getUnit().hasAbility("model.ability.canBeEquipped") && (data instanceof GoodsLabel || data instanceof MarketLabel);
    }

    public static String getWorkLabel(WorkLocation wl) {
        return "WORK_" + StringUtils.lastPart(wl.getClass().toString(), ".").toUpperCase(Locale.US);
    }

    @Override
    public boolean isOnCarrier() {
        return this.unit != null && this.unit.isOnCarrier();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Game game = this.freeColClient.getGame();
        Specification spec = game.getSpecification();
        InGameController igc = this.freeColClient.getInGameController();
        String[] args = event.getActionCommand().split("/");
        switch (Enum.valueOf(UnitAction.class, args[0].toUpperCase(Locale.US))) {
            case ASSIGN: {
                igc.assignTeacher(this.unit, game.getFreeColGameObject(args[1], Unit.class));
                break;
            }
            case WORK_COLONYTILE: {
                GoodsType gt;
                if (args.length < 3) break;
                ColonyTile colonyTile = game.getFreeColGameObject(args[1], ColonyTile.class);
                if (args.length >= 4 && "!".equals(args[3]) && !igc.claimTile(colonyTile.getWorkTile(), this.unit.getColony())) break;
                if (colonyTile != this.unit.getLocation()) {
                    igc.work(this.unit, colonyTile);
                }
                if ((gt = spec.getGoodsType(args[2])) == null || this.unit.getWorkType() == gt) break;
                igc.changeWorkType(this.unit, gt);
                break;
            }
            case WORK_BUILDING: {
                GoodsType gt;
                if (args.length < 3) break;
                Building building = game.getFreeColGameObject(args[1], Building.class);
                if (building != this.unit.getLocation()) {
                    igc.work(this.unit, building);
                }
                if ((gt = spec.getGoodsType(args[2])) == null || this.unit.getWorkType() == gt) break;
                igc.changeWorkType(this.unit, gt);
                break;
            }
            case ACTIVATE_UNIT: {
                igc.changeState(this.unit, Unit.UnitState.ACTIVE);
                this.gui.setActiveUnit(this.unit);
                break;
            }
            case FORTIFY: {
                igc.changeState(this.unit, Unit.UnitState.FORTIFYING);
                break;
            }
            case SENTRY: {
                igc.changeState(this.unit, Unit.UnitState.SENTRY);
                break;
            }
            case COLOPEDIA: {
                this.gui.showColopediaPanel(this.unit.getType().getId());
                break;
            }
            case LEAVE_TOWN: {
                igc.putOutsideColony(this.unit);
                break;
            }
            case CLEAR_SPECIALITY: {
                igc.clearSpeciality(this.unit);
                break;
            }
            case CLEAR_ORDERS: {
                igc.clearOrders(this.unit);
                break;
            }
            case ASSIGN_TRADE_ROUTE: {
                this.gui.showTradeRoutePanel(this.unit);
                break;
            }
            case LEAVE_SHIP: {
                igc.leaveShip(this.unit);
                break;
            }
            case UNLOAD: {
                igc.unload(this.unit);
            }
        }
        this.updateIcon();
    }

    public static enum UnitAction {
        ASSIGN,
        CLEAR_SPECIALITY,
        ACTIVATE_UNIT,
        FORTIFY,
        SENTRY,
        COLOPEDIA,
        LEAVE_TOWN,
        WORK_COLONYTILE,
        WORK_BUILDING,
        CLEAR_ORDERS,
        ASSIGN_TRADE_ROUTE,
        LEAVE_SHIP,
        UNLOAD;

    }
}

