/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ImageSelection;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;

public final class TradeRouteInputPanel
extends FreeColPanel
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(TradeRouteInputPanel.class.getName());
    public static final DataFlavor STOP_FLAVOR = new DataFlavor(TradeRouteStop.class, "Stop");
    private final TradeRoute newRoute;
    private CargoHandler cargoHandler;
    private MouseListener dragListener;
    private MouseListener dropListener;
    private DefaultListModel<TradeRouteStop> stopListModel;
    private JList<TradeRouteStop> stopList;
    private JTextField tradeRouteName;
    private JComboBox<String> destinationSelector;
    private JCheckBox messagesBox;
    private JButton addStopButton;
    private JButton removeStopButton;
    private GoodsPanel goodsPanel;
    private CargoPanel cargoPanel;

    public TradeRouteInputPanel(FreeColClient freeColClient, TradeRoute newRoute) {
        super(freeColClient, new MigLayout("wrap 4, fill", "[]20[fill]rel"));
        Game game = freeColClient.getGame();
        Player player = this.getMyPlayer();
        final TradeRoute tradeRoute = newRoute.copy(game, TradeRoute.class);
        this.newRoute = newRoute;
        this.cargoHandler = new CargoHandler();
        this.dragListener = new DragListener(this.getFreeColClient(), this);
        this.dropListener = new DropListener();
        this.stopListModel = new DefaultListModel();
        for (TradeRouteStop stop : tradeRoute.getStops()) {
            this.stopListModel.addElement(stop);
        }
        this.stopList = new JList<TradeRouteStop>(this.stopListModel);
        this.stopList.setCellRenderer(new StopRenderer());
        this.stopList.setFixedCellHeight(48);
        this.stopList.setDragEnabled(true);
        this.stopList.setTransferHandler(new StopListHandler());
        this.stopList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u007f') {
                    TradeRouteInputPanel.this.deleteCurrentlySelectedStops();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.stopList.addListSelectionListener(this);
        JScrollPane tradeRouteView = new JScrollPane(this.stopList);
        JLabel nameLabel = GUI.localizedLabel("tradeRouteInputPanel.nameLabel");
        this.tradeRouteName = new JTextField(tradeRoute.getName());
        JLabel destinationLabel = GUI.localizedLabel("tradeRouteInputPanel.destinationLabel");
        this.destinationSelector = new JComboBox();
        this.destinationSelector.setRenderer(new DestinationCellRenderer());
        StringTemplate template = StringTemplate.template("report.allColonies");
        this.destinationSelector.addItem(Messages.message(template));
        if (player.getEurope() != null) {
            this.destinationSelector.addItem(player.getEurope().getId());
        }
        for (Colony colony : freeColClient.getMySortedColonies()) {
            this.destinationSelector.addItem(colony.getId());
        }
        this.messagesBox = new JCheckBox(Messages.message("tradeRouteInputPanel.silence"));
        this.messagesBox.setSelected(tradeRoute.isSilent());
        this.messagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tradeRoute.setSilent(TradeRouteInputPanel.this.messagesBox.isSelected());
            }
        });
        this.addStopButton = GUI.localizedButton("tradeRouteInputPanel.addStop");
        this.addStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeRouteInputPanel.this.addSelectedStops();
            }
        });
        this.removeStopButton = GUI.localizedButton("tradeRouteInputPanel.removeStop");
        this.removeStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeRouteInputPanel.this.deleteCurrentlySelectedStops();
            }
        });
        this.goodsPanel = new GoodsPanel();
        this.goodsPanel.setTransferHandler(this.cargoHandler);
        this.goodsPanel.setEnabled(false);
        this.cargoPanel = new CargoPanel();
        this.cargoPanel.setTransferHandler(this.cargoHandler);
        JButton cancelButton = GUI.localizedButton("cancel");
        cancelButton.setActionCommand("CANCEL");
        cancelButton.addActionListener(this);
        this.setCancelComponent(cancelButton);
        String hdr = Messages.message("tradeRouteInputPanel.editRoute");
        this.add((Component)GUI.getDefaultHeader(hdr), "span, align center");
        this.add((Component)tradeRouteView, "span 1 5, grow");
        this.add(nameLabel);
        this.add((Component)this.tradeRouteName, "span");
        this.add(destinationLabel);
        this.add(this.destinationSelector, "span");
        this.add(this.messagesBox);
        this.add(this.addStopButton);
        this.add((Component)this.removeStopButton, "span");
        this.add((Component)this.goodsPanel, "span");
        this.add((Component)this.cargoPanel, "span, height 80:, growy");
        this.add((Component)this.okButton, "newline 20, span, split 2, tag ok");
        this.add((Component)cancelButton, "tag cancel");
        if (this.stopListModel.getSize() > 0) {
            this.stopList.setSelectedIndex(0);
            TradeRouteStop selectedStop = this.stopListModel.firstElement();
            this.cargoPanel.initialize(selectedStop);
        }
        this.updateButtons();
        this.getGUI().restoreSavedSize(this, this.getPreferredSize());
    }

    private void addSelectedStops() {
        int startIndex = -1;
        int endIndex = -1;
        int sel = this.destinationSelector.getSelectedIndex();
        if (sel == 0) {
            startIndex = 1;
            endIndex = this.destinationSelector.getItemCount();
        } else {
            startIndex = sel;
            endIndex = startIndex + 1;
        }
        ArrayList<GoodsType> cargo = new ArrayList<GoodsType>();
        for (Component comp : this.cargoPanel.getComponents()) {
            CargoLabel label = (CargoLabel)comp;
            cargo.add(label.getType());
        }
        int maxIndex = this.stopList.getMaxSelectionIndex();
        for (int i = startIndex; i < endIndex; ++i) {
            String id = this.destinationSelector.getItemAt(i);
            FreeColGameObject fcgo = this.getGame().getFreeColGameObject(id);
            if (!(fcgo instanceof Location)) continue;
            TradeRouteStop stop = new TradeRouteStop(this.getGame(), (Location)((Object)fcgo));
            stop.setCargo(cargo);
            if (maxIndex < 0) {
                this.stopListModel.addElement(stop);
                continue;
            }
            this.stopListModel.add(++maxIndex, stop);
        }
    }

    private void deleteCurrentlySelectedStops() {
        int count = 0;
        int lastIndex = 0;
        for (int index : this.stopList.getSelectedIndices()) {
            this.stopListModel.remove(index - count);
            ++count;
            lastIndex = index;
        }
        if (this.stopListModel.getSize() > 0) {
            this.stopList.setSelectedIndex(lastIndex - count + 1);
        }
    }

    public void cancelTradeRoute() {
        this.newRoute.setName(null);
        this.getGUI().removeFromCanvas(this);
    }

    public void updateButtons() {
        this.addStopButton.setEnabled(this.stopListModel.getSize() < this.destinationSelector.getItemCount() - 1);
        this.removeStopButton.setEnabled(this.stopList.getSelectedIndices().length > 0);
    }

    private boolean verifyNewTradeRoute() {
        Player player = this.getFreeColClient().getMyPlayer();
        String newName = this.tradeRouteName.getText();
        for (TradeRoute route : player.getTradeRoutes()) {
            if (route.getName() == null || route.getName().equals(this.newRoute.getName()) || !route.getName().equals(newName)) continue;
            StringTemplate template = StringTemplate.template("tradeRoute.duplicateName").addName("%name%", newName);
            this.getGUI().showErrorMessage(template);
            return false;
        }
        if (this.stopListModel.getSize() < 2) {
            this.getGUI().showErrorMessage("tradeRoute.notEnoughStops");
            return false;
        }
        for (int index = 0; index < this.stopListModel.getSize(); ++index) {
            TradeRouteStop stop = this.stopListModel.get(index);
            if (TradeRoute.isStopValid(player, stop)) continue;
            StringTemplate template = StringTemplate.template("tradeRoute.invalidStop").addStringTemplate("%name%", stop.getLocation().getLocationLabelFor(player));
            this.getGUI().showErrorMessage(template);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            if (!this.verifyNewTradeRoute()) {
                return;
            }
            this.newRoute.setName(this.tradeRouteName.getText());
            this.newRoute.clearStops();
            for (int index = 0; index < this.stopListModel.getSize(); ++index) {
                this.newRoute.addStop(this.stopListModel.get(index));
            }
            this.newRoute.setSilent(this.messagesBox.isSelected());
            super.actionPerformed(event);
        } else if ("CANCEL".equals(command)) {
            this.cancelTradeRoute();
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] idx = this.stopList.getSelectedIndices();
        if (idx.length > 0) {
            TradeRouteStop stop = this.stopListModel.get(idx[0]);
            this.cargoPanel.initialize(stop);
            this.goodsPanel.setEnabled(true);
        } else {
            this.goodsPanel.setEnabled(false);
        }
        this.updateButtons();
    }

    @Override
    public void removeNotify() {
        this.cargoHandler = null;
        this.dragListener = null;
        this.dropListener = null;
        this.stopListModel.clear();
        this.stopListModel = null;
        this.stopList = null;
        this.tradeRouteName = null;
        this.destinationSelector = null;
        this.messagesBox = null;
        this.addStopButton = null;
        this.removeStopButton = null;
        this.cargoPanel = null;
        super.removeNotify();
    }

    private class StopRenderer
    implements ListCellRenderer<TradeRouteStop> {
        private final JPanel SELECTED_COMPONENT = new JPanel();
        private final JPanel NORMAL_COMPONENT = new JPanel();

        public StopRenderer() {
            this.NORMAL_COMPONENT.setLayout(new MigLayout("", "[80, center][]"));
            this.NORMAL_COMPONENT.setOpaque(false);
            this.SELECTED_COMPONENT.setLayout(new MigLayout("", "[80, center][]"));
            this.SELECTED_COMPONENT.setOpaque(false);
            this.SELECTED_COMPONENT.setUI((PanelUI)FreeColSelectedPanelUI.createUI(this.SELECTED_COMPONENT));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TradeRouteStop> list, TradeRouteStop value, int index, boolean isSelected, boolean hasFocus) {
            JLabel name;
            JLabel icon;
            JPanel panel = isSelected ? this.SELECTED_COMPONENT : this.NORMAL_COMPONENT;
            panel.removeAll();
            panel.setForeground(list.getForeground());
            panel.setFont(list.getFont());
            Location location = value.getLocation();
            if (location instanceof Europe) {
                Europe europe = (Europe)location;
                TradeRouteInputPanel.this.getLibrary();
                Image image = ImageLibrary.getCoatOfArmsImage(europe.getOwner().getNation(), 0.5);
                icon = new JLabel(new ImageIcon(image));
                name = GUI.localizedLabel(europe.getNameKey());
            } else if (location instanceof Colony) {
                Colony colony = (Colony)location;
                TradeRouteInputPanel.this.getLibrary();
                icon = new JLabel(new ImageIcon(ImageLibrary.getSettlementImage(colony, 0.5)));
                name = new JLabel(colony.getName());
            } else {
                throw new IllegalStateException("Bogus location: " + location);
            }
            panel.add((Component)icon, "spany");
            panel.add((Component)name, "span, wrap");
            for (GoodsType cargo : value.getCargo()) {
                TradeRouteInputPanel.this.getLibrary();
                panel.add(new JLabel(new ImageIcon(ImageLibrary.getGoodsImage(cargo, 0.5))));
            }
            return panel;
        }
    }

    private class StopListHandler
    extends TransferHandler {
        private StopListHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(STOP_FLAVOR)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            DefaultListModel model = (DefaultListModel)list.getModel();
            ArrayList<TradeRouteStop> stops = new ArrayList<TradeRouteStop>();
            for (int index : list.getSelectedIndices()) {
                stops.add((TradeRouteStop)model.get(index));
            }
            return new StopListTransferable(stops);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean importData(JComponent target, Transferable data) {
            JList stl = TradeRouteInputPanel.this.stopList;
            if (this.canImport(target, data.getTransferDataFlavors()) && target == stl && data instanceof StopListTransferable) {
                List<TradeRouteStop> stops = ((StopListTransferable)data).getStops();
                DefaultListModel<TradeRouteStop> model = new DefaultListModel<TradeRouteStop>();
                int index = stl.getMaxSelectionIndex();
                for (TradeRouteStop stop : stops) {
                    if (index < 0) {
                        model.addElement(stop);
                        continue;
                    }
                    model.add(++index, stop);
                }
                stl.setModel(model);
                return true;
            }
            return false;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            try {
                if (source instanceof JList && action == 2) {
                    JList stopList = (JList)source;
                    DefaultListModel listModel = (DefaultListModel)stopList.getModel();
                    for (Object o : (List)data.getTransferData(STOP_FLAVOR)) {
                        listModel.removeElement(o);
                    }
                }
            }
            catch (Exception e) {
                logger.warning(e.toString());
            }
        }
    }

    private static class StopListTransferable
    implements Transferable {
        private List<TradeRouteStop> stops;

        public StopListTransferable(List<TradeRouteStop> stops) {
            this.stops = stops;
        }

        public List<TradeRouteStop> getStops() {
            return this.stops;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return flavor == STOP_FLAVOR ? this.stops : null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{STOP_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == STOP_FLAVOR;
        }
    }

    private class GoodsPanel
    extends JPanel {
        public GoodsPanel() {
            super(new GridLayout(0, 4, 3, 3));
            for (GoodsType goodsType : TradeRouteInputPanel.this.getSpecification().getGoodsTypeList()) {
                if (!goodsType.isStorable()) continue;
                CargoLabel label = new CargoLabel(goodsType);
                this.add(label);
            }
            this.setOpaque(false);
            this.setBorder(GUI.localizedBorder("goods"));
            this.addMouseListener(TradeRouteInputPanel.this.dropListener);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            for (Component child : this.getComponents()) {
                if (!(child instanceof CargoLabel)) continue;
                ((CargoLabel)child).setEnabled(enable);
            }
        }
    }

    private class DestinationCellRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public DestinationCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            FreeColGameObject fcgo = TradeRouteInputPanel.this.getGame().getFreeColGameObject(value);
            if (fcgo instanceof Location) {
                this.setText(Messages.message(((Location)((Object)fcgo)).getLocationLabel()));
            } else {
                this.setText(value);
            }
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }

    private class CargoHandler
    extends TransferHandler {
        private CargoHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new ImageSelection((CargoLabel)c);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(JComponent target, Transferable data) {
            if (!this.canImport(target, data.getTransferDataFlavors())) {
                return false;
            }
            try {
                CargoLabel label = (CargoLabel)data.getTransferData(DefaultTransferHandler.flavor);
                if (target instanceof CargoPanel) {
                    int[] indices;
                    CargoLabel newLabel = new CargoLabel(label.getType());
                    TradeRouteInputPanel.this.cargoPanel.add(newLabel);
                    TradeRouteInputPanel.this.cargoPanel.revalidate();
                    for (int index : indices = TradeRouteInputPanel.this.stopList.getSelectedIndices()) {
                        TradeRouteStop stop = (TradeRouteStop)TradeRouteInputPanel.this.stopListModel.get(index);
                        stop.addCargo(label.getType());
                    }
                    TradeRouteInputPanel.this.stopList.revalidate();
                    TradeRouteInputPanel.this.stopList.repaint();
                }
                return true;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                logger.log(Level.WARNING, "CargoHandler import", ex);
                return false;
            }
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            try {
                CargoLabel label = (CargoLabel)data.getTransferData(DefaultTransferHandler.flavor);
                if (source.getParent() instanceof CargoPanel) {
                    int[] indices;
                    TradeRouteInputPanel.this.cargoPanel.remove(label);
                    for (int stopIndex : indices = TradeRouteInputPanel.this.stopList.getSelectedIndices()) {
                        TradeRouteStop stop = (TradeRouteStop)TradeRouteInputPanel.this.stopListModel.get(stopIndex);
                        ArrayList<GoodsType> cargo = new ArrayList<GoodsType>(stop.getCargo());
                        for (int index = 0; index < cargo.size(); ++index) {
                            if (cargo.get(index) != label.getType()) continue;
                            cargo.remove(index);
                            break;
                        }
                        stop.setCargo(cargo);
                    }
                    TradeRouteInputPanel.this.stopList.revalidate();
                    TradeRouteInputPanel.this.stopList.repaint();
                    TradeRouteInputPanel.this.cargoPanel.revalidate();
                    TradeRouteInputPanel.this.cargoPanel.repaint();
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                logger.log(Level.WARNING, "CargoHandler export", ex);
            }
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(DefaultTransferHandler.flavor)) continue;
                return true;
            }
            return false;
        }
    }

    private class CargoPanel
    extends JPanel {
        public CargoPanel() {
            this.setOpaque(false);
            this.setBorder(GUI.localizedBorder("cargoOnCarrier"));
            this.addMouseListener(TradeRouteInputPanel.this.dropListener);
        }

        public void initialize(TradeRouteStop newStop) {
            this.removeAll();
            if (newStop != null) {
                for (GoodsType goodsType : newStop.getCargo()) {
                    this.add(new CargoLabel(goodsType));
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    private class CargoLabel
    extends JLabel {
        private final GoodsType goodsType;

        public CargoLabel(GoodsType type) {
            TradeRouteInputPanel.this.getLibrary();
            super(ImageLibrary.getGoodsImageIcon(type));
            this.goodsType = type;
            this.setDisabledIcon(this.getDisabledIcon());
            this.setTransferHandler(TradeRouteInputPanel.this.cargoHandler);
            this.addMouseListener(TradeRouteInputPanel.this.dragListener);
        }

        public GoodsType getType() {
            return this.goodsType;
        }
    }
}

