/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;

public final class TilePanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(TilePanel.class.getName());
    private static final String COLOPEDIA = "COLOPEDIA";

    public TilePanel(FreeColClient freeColClient, Tile tile) {
        super(freeColClient, new MigLayout("wrap 2, insets 20 30 10 30", "[right, sg][left, sg]"));
        Player player;
        StringTemplate ownerName;
        TileType tileType = tile.getType();
        JButton colopediaButton = GUI.localizedButton("menuBar.colopedia");
        colopediaButton.setActionCommand(tile.getType().getId());
        colopediaButton.addActionListener(this);
        ComponentInputMap inputMap = new ComponentInputMap(this.okButton);
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, inputMap);
        StringTemplate template = StringTemplate.template("tilePanel.label").addStringTemplate("%label%", tile.getLabel()).addAmount("%x%", tile.getX()).addAmount("%y%", tile.getY());
        this.add((Component)GUI.localizedLabel(template), "span, center");
        ImageLibrary lib = this.getLibrary();
        Image terrain = lib.getTerrainImage(tileType, tile.getX(), tile.getY());
        int width = terrain.getWidth(null);
        int baseHeight = terrain.getHeight(null);
        int height = lib.getCompoundTerrainImageHeight(tileType);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.translate(0, height - baseHeight);
        this.getGUI().displayColonyTile(g, tile, null);
        this.add((Component)new JLabel(new ImageIcon(image)), "span, center");
        if (tile.getRegion() != null) {
            this.add(GUI.localizedLabel("tilePanel.region"));
            this.add(GUI.localizedLabel(tile.getRegion().getLabel()));
        }
        if (tile.getOwner() != null && (ownerName = tile.getOwner().getNationName()) != null) {
            this.add(GUI.localizedLabel("tilePanel.owner"));
            this.add(GUI.localizedLabel(ownerName));
        }
        if (tile.getOwningSettlement() != null) {
            this.add(GUI.localizedLabel("tilePanel.settlement"));
            this.add(new JLabel(tile.getOwningSettlement().getName()));
        }
        if (tileType != null) {
            UnitType colonist = this.getSpecification().getDefaultUnitType();
            JLabel label = null;
            boolean first = true;
            for (ProductionType productionType : tileType.getAvailableProductionTypes(false)) {
                for (AbstractGoods output : productionType.getOutputs()) {
                    GoodsType goodsType = output.getType();
                    int potential = output.getAmount();
                    if (tile.getTileItemContainer() != null) {
                        potential = tile.getTileItemContainer().getTotalBonusPotential(goodsType, colonist, potential, true);
                    }
                    int expertPotential = potential;
                    UnitType expert = this.getSpecification().getExpertForProducing(goodsType);
                    if (expert != null) {
                        expertPotential = (int)expert.applyModifiers(potential, this.getGame().getTurn(), goodsType.getId());
                    }
                    if (potential > 0) {
                        String string = String.valueOf(potential);
                        this.getLibrary();
                        label = new JLabel(string, ImageLibrary.getGoodsImageIcon(goodsType), 0);
                        if (first) {
                            this.add((Component)label, "span, split, center");
                            first = false;
                        } else {
                            this.add(label);
                        }
                    }
                    if (expertPotential <= potential) continue;
                    if (label == null) {
                        String string = String.valueOf(expertPotential);
                        this.getLibrary();
                        label = new JLabel(string, ImageLibrary.getGoodsImageIcon(goodsType), 0);
                        label.setToolTipText(Messages.getName(expert));
                        if (first) {
                            this.add((Component)label, "span, split");
                            first = false;
                            continue;
                        }
                        this.add(new JLabel("/"));
                        this.add(label);
                        continue;
                    }
                    label.setText(String.valueOf(potential) + "/" + String.valueOf(expertPotential));
                    label.setToolTipText(Messages.getName(colonist) + "/" + Messages.getName(expert));
                }
            }
        }
        if ((player = FreeColDebugger.debugDisplayColonyValuePlayer()) != null) {
            List<Double> values = player.getAllColonyValues(tile);
            int result = player.getColonyValue(tile);
            if (result < 0) {
                this.add((Component)new JLabel(DebugUtils.getColonyValue(tile)), "newline 5, span, align center");
            } else {
                for (Player.ColonyValueCategory c : Player.ColonyValueCategory.values()) {
                    String cat = c.toString();
                    this.add((Component)new JLabel(cat + values.get(c.ordinal())), "newline 5, span, align center");
                }
                for (int a = Player.ColonyValueCategory.A_GOODS.ordinal(); a < values.size(); ++a) {
                    this.add((Component)new JLabel("... " + values.get(a)), "newline 5, span, align center");
                }
                this.add((Component)new JLabel("Result " + result), "newline 5, span, align center");
            }
        }
        this.add((Component)this.okButton, "newline 30, span, split 2, align center, tag ok");
        this.add((Component)colopediaButton, "tag help");
        this.setSize(this.getPreferredSize());
        g.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.getGUI().removeFromCanvas(this);
        } else {
            this.getGUI().showColopediaPanel(command);
        }
    }

    @Override
    public String getUIClassID() {
        return "TilePanelUI";
    }
}

