/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.LogBuilder;

public final class SelectDestinationDialog
extends FreeColDialog<Location>
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(SelectDestinationDialog.class.getName());
    private static final int CELL_HEIGHT = 48;
    private static boolean showOnlyMyColonies = true;
    private static Comparator<Destination> destinationComparator = null;
    private final List<Destination> destinations = new ArrayList<Destination>();
    private final JList<Destination> destinationList;
    private JCheckBox onlyMyColoniesBox;
    private JComboBox<String> comparatorBox;

    public SelectDestinationDialog(FreeColClient freeColClient, Unit unit) {
        super(freeColClient);
        ArrayList<GoodsType> goodsTypes = new ArrayList<GoodsType>();
        for (Goods goods : unit.getCompactGoodsList()) {
            goodsTypes.add(goods.getType());
        }
        this.loadDestinations(unit, goodsTypes);
        String sel = Messages.message("selectDestination.text");
        JLabel header = GUI.getDefaultHeader(sel);
        header.setFont(GUI.SMALL_HEADER_FONT);
        DefaultListModel model = new DefaultListModel();
        this.destinationList = new JList(model);
        this.destinationList.setCellRenderer(new LocationRenderer());
        this.destinationList.setFixedCellHeight(48);
        this.destinationList.setSelectionMode(0);
        this.destinationList.addListSelectionListener(this);
        this.destinationList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Destination d = (Destination)SelectDestinationDialog.this.destinationList.getSelectedValue();
                if (d != null) {
                    SelectDestinationDialog.this.setValue(SelectDestinationDialog.this.options.get(0));
                }
            }
        });
        this.updateDestinationList();
        JScrollPane listScroller = new JScrollPane(this.destinationList);
        listScroller.setPreferredSize(new Dimension(300, 300));
        String omcb = Messages.message("selectDestination.onlyMyColonies");
        this.onlyMyColoniesBox = new JCheckBox(omcb, showOnlyMyColonies);
        this.onlyMyColoniesBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                showOnlyMyColonies = SelectDestinationDialog.this.onlyMyColoniesBox.isSelected();
                SelectDestinationDialog.this.updateDestinationList();
            }
        });
        this.comparatorBox = new JComboBox<String>(new String[]{Messages.message("selectDestination.sortByOwner"), Messages.message("selectDestination.sortByName"), Messages.message("selectDestination.sortByDistance")});
        this.comparatorBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SelectDestinationDialog.this.updateDestinationComparator();
                3 v0 = this;
                Collections.sort(SelectDestinationDialog.this.destinations, destinationComparator);
                SelectDestinationDialog.this.updateDestinationList();
            }
        });
        this.comparatorBox.setSelectedIndex(destinationComparator instanceof NameComparator ? 1 : (destinationComparator instanceof DistanceComparator ? 2 : 0));
        MigPanel panel = new MigPanel(new MigLayout("wrap 1, fill", "[align center]", ""));
        panel.add(header);
        panel.add((Component)listScroller, "newline 30, growx, growy");
        panel.add((Component)this.onlyMyColoniesBox, "left");
        panel.add(this.comparatorBox, "left");
        panel.setSize(panel.getPreferredSize());
        List c = SelectDestinationDialog.choices();
        c.add(new ChoiceItem<Location>(Messages.message("ok"), null).okOption());
        c.add(new ChoiceItem<Location>(Messages.message("cancel"), null).cancelOption().defaultOption());
        this.initializeDialog(FreeColDialog.DialogType.QUESTION, true, panel, this.getImageLibrary().getImageIcon(unit, true), c);
    }

    private void loadDestinations(Unit unit, List<GoodsType> goodsTypes) {
        int turns;
        Player player = unit.getOwner();
        Settlement inSettlement = unit.getSettlement();
        boolean canTrade = player.hasAbility("model.ability.tradeWithForeignColonies");
        Europe europe = player.getEurope();
        Game game = this.getGame();
        Map map = game.getMap();
        if (unit.isInEurope() && !unit.getType().canMoveToHighSeas()) {
            return;
        }
        if (unit.isInEurope()) {
            this.destinations.add(new Destination(map, unit.getSailTurns(), unit, goodsTypes));
        } else if (europe != null && player.canMoveToEurope() && unit.getType().canMoveToHighSeas() && (turns = unit.getTurnsToReach(europe)) != Integer.MAX_VALUE) {
            this.destinations.add(new Destination(europe, turns, unit, goodsTypes));
        }
        for (Settlement s : player.getSettlements()) {
            if (s == inSettlement || (!unit.isNaval() ? !Map.isSameContiguity(unit.getLocation(), s.getTile()) : !s.isConnectedPort()) || (turns = unit.getTurnsToReach(s)) == Integer.MAX_VALUE) continue;
            this.destinations.add(new Destination(s, turns, unit, goodsTypes));
        }
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Player p : game.getLivePlayers(player)) {
            if (!p.hasContacted(player) || p.isEuropean() && !canTrade) continue;
            for (Settlement settlement : p.getSettlements()) {
                if (!unit.isNaval() ? !Map.isSameContiguity(unit.getLocation(), settlement.getTile()) : !settlement.isConnectedPort()) continue;
                if (settlement instanceof IndianSettlement && !((IndianSettlement)settlement).hasContacted(player)) continue;
                locs.add(settlement.getTile());
            }
        }
        GoalDeciders.MultipleAdjacentDecider md = new GoalDeciders.MultipleAdjacentDecider(locs);
        unit.search(unit.getLocation(), md.getGoalDecider(), null, Integer.MAX_VALUE, null);
        for (Map.Entry entry : md.getResults().entrySet()) {
            Settlement s = ((Location)entry.getKey()).getTile().getSettlement();
            PathNode p = (PathNode)entry.getValue();
            turns = p.getTotalTurns();
            if (unit.isInEurope()) {
                turns += unit.getSailTurns();
            }
            if (p.getMovesLeft() < unit.getInitialMovesLeft()) {
                ++turns;
            }
            this.destinations.add(new Destination(s, turns, unit, goodsTypes));
        }
        if (destinationComparator == null) {
            destinationComparator = new DestinationComparator(player);
        }
        Collections.sort(this.destinations, destinationComparator);
    }

    private void updateDestinationList() {
        Player player = this.getMyPlayer();
        Destination selected = this.destinationList.getSelectedValue();
        DefaultListModel<Destination> model = new DefaultListModel<Destination>();
        for (Destination d : this.destinations) {
            if (showOnlyMyColonies) {
                if (!(d.location instanceof Europe) && !(d.location instanceof Map) && (!(d.location instanceof Colony) || !player.owns((Colony)d.location))) continue;
                model.addElement(d);
                continue;
            }
            model.addElement(d);
        }
        this.destinationList.setModel(model);
        this.destinationList.setSelectedValue(selected, true);
        if (this.destinationList.getSelectedIndex() < 0) {
            this.destinationList.setSelectedIndex(0);
        }
        this.recenter(this.destinationList.getSelectedValue());
    }

    private void recenter(Destination destination) {
        if (destination != null && destination.location.getTile() != null) {
            this.getGUI().setFocus(destination.location.getTile());
        }
    }

    private void updateDestinationComparator() {
        Player player = this.getMyPlayer();
        switch (this.comparatorBox.getSelectedIndex()) {
            case 1: {
                destinationComparator = new NameComparator(player);
                break;
            }
            case 2: {
                destinationComparator = new DistanceComparator(player);
                break;
            }
            default: {
                destinationComparator = new DestinationComparator(player);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.recenter(this.destinationList.getSelectedValue());
    }

    @Override
    public Location getResponse() {
        Destination d;
        Object value = this.getValue();
        if (((ChoiceItem)this.options.get(0)).equals(value) && (d = this.destinationList.getSelectedValue()) != null) {
            return d.location;
        }
        return null;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.destinations.clear();
        this.onlyMyColoniesBox = null;
        this.comparatorBox = null;
    }

    @Override
    public void requestFocus() {
        this.destinationList.requestFocus();
    }

    private static class LocationRenderer
    extends FreeColComboBoxRenderer<Destination> {
        private LocationRenderer() {
        }

        @Override
        public void setLabelValues(JLabel label, Destination value) {
            if (value.icon != null) {
                label.setIcon(value.icon);
            }
            label.setText(value.text);
        }
    }

    private class DistanceComparator
    extends DestinationComparator {
        public DistanceComparator(Player player) {
            super(player);
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            int result = choice1.turns - choice2.turns;
            return result != 0 ? result : this.compareNames(choice1.location, choice2.location);
        }
    }

    private class NameComparator
    extends DestinationComparator {
        public NameComparator(Player player) {
            super(player);
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            return this.compareNames(choice1.location, choice2.location);
        }
    }

    private class DestinationComparator
    implements Comparator<Destination> {
        protected Player owner;

        public DestinationComparator(Player player) {
            this.owner = player;
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            int score1 = choice1.score;
            int score2 = choice2.score;
            return score1 != score2 ? score1 - score2 : this.compareNames(choice1.location, choice2.location);
        }

        protected int compareNames(Location loc1, Location loc2) {
            if (!(loc1 instanceof Settlement)) {
                return -1;
            }
            if (!(loc2 instanceof Settlement)) {
                return 1;
            }
            Settlement s1 = (Settlement)loc1;
            String name1 = Messages.message(s1.getLocationLabelFor(this.owner));
            Settlement s2 = (Settlement)loc2;
            String name2 = Messages.message(s2.getLocationLabelFor(this.owner));
            return name1.compareTo(name2);
        }
    }

    private class Destination {
        public Unit unit;
        public Location location;
        public int turns;
        public String extras;
        public String text;
        public int score;
        public ImageIcon icon;

        public Destination(Location location, int turns, Unit unit, List<GoodsType> goodsTypes) {
            this.unit = unit;
            this.location = location;
            this.turns = turns;
            this.extras = this.getExtras(location, unit, goodsTypes);
            this.score = this.calculateScore();
            this.icon = null;
            Player player = SelectDestinationDialog.this.getMyPlayer();
            ImageLibrary lib = SelectDestinationDialog.this.getImageLibrary();
            String name = "";
            if (location instanceof Europe) {
                Europe europe = (Europe)location;
                Nation nation = europe.getOwner().getNation();
                name = Messages.getName(europe);
                this.icon = new ImageIcon(lib.getCoatOfArmsImage(nation).getScaledInstance(-1, 48, 4));
            } else if (location instanceof Map) {
                name = Messages.message(location.getLocationLabelFor(player));
                this.icon = lib.getMiscImageIcon("lostCityRumour.image");
            } else if (location instanceof Settlement) {
                Settlement settlement = (Settlement)location;
                name = Messages.message(settlement.getLocationLabelFor(player));
                this.icon = new ImageIcon(lib.getSettlementImage(settlement).getScaledInstance(64, -1, 4));
            }
            StringTemplate template = StringTemplate.template("selectDestination.destinationTurns").addName("%location%", name).addAmount("%turns%", this.turns).addName("%extras%", this.extras);
            this.text = Messages.message(template);
        }

        private String getExtras(Location loc, Unit unit, List<GoodsType> goodsTypes) {
            String sep = ", ";
            Player owner = unit.getOwner();
            LogBuilder lb = new LogBuilder(32);
            boolean dropSep = false;
            if (loc instanceof IndianSettlement && ((IndianSettlement)loc).hasMissionary(owner)) {
                lb.add("\u271d");
            }
            if (loc instanceof Europe && !goodsTypes.isEmpty()) {
                Market market = owner.getMarket();
                for (GoodsType goodsType : goodsTypes) {
                    lb.add(Messages.getName(goodsType), " ", market.getSalePrice(goodsType, 1), ", ");
                    dropSep = true;
                }
            } else if (!(loc instanceof Settlement) || !owner.owns((Settlement)loc)) {
                if (loc instanceof Settlement && ((Settlement)loc).getOwner().atWarWith(owner)) {
                    lb.add("[", Messages.message("model.stance.war"), "]");
                } else if (loc instanceof Settlement) {
                    IndianSettlement is;
                    UnitType sk;
                    if (loc instanceof IndianSettlement && (sk = (is = (IndianSettlement)loc).getLearnableSkill()) != null) {
                        Unit up;
                        Unit unit2 = up = unit.getType().canBeUpgraded(sk, UnitTypeChange.ChangeType.NATIVES) ? unit : null;
                        if (unit.isCarrier()) {
                            for (Unit u : unit.getUnitList()) {
                                if (!u.getType().canBeUpgraded(sk, UnitTypeChange.ChangeType.NATIVES)) continue;
                                up = u;
                                break;
                            }
                        }
                        if (up != null) {
                            lb.add("[", Messages.getName(sk), "]");
                        }
                    }
                    if (!goodsTypes.isEmpty()) {
                        for (GoodsType g : goodsTypes) {
                            String sale = owner.getLastSaleString((Settlement)loc, g);
                            String more = null;
                            if (loc instanceof IndianSettlement) {
                                GoodsType[] wanted = ((IndianSettlement)loc).getWantedGoods();
                                if (wanted.length > 0 && g == wanted[0]) {
                                    more = "***";
                                } else if (wanted.length > 1 && g == wanted[1]) {
                                    more = "**";
                                } else if (wanted.length > 2 && g == wanted[2]) {
                                    more = "*";
                                }
                            }
                            if (sale == null || more == null) continue;
                            lb.add(Messages.getName(g), " ", sale, more, ", ");
                            dropSep = true;
                        }
                    }
                }
            }
            if (dropSep) {
                lb.shrink(", ");
            }
            return lb.toString();
        }

        private int calculateScore() {
            return this.location instanceof Europe || this.location instanceof Map ? 10 : (this.location instanceof Colony ? (this.unit.getOwner().owns((Colony)this.location) ? 20 : 30) : (this.location instanceof IndianSettlement ? 40 : 100));
        }
    }
}

