/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.util.StringUtils;

public class ResourcesDetailPanel
extends ColopediaGameObjectTypePanel<ResourceType> {
    public ResourcesDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.RESOURCES.toString(), 0.75);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        super.addSubTrees(root, this.getSpecification().getResourceTypeList());
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        ResourceType type = this.getSpecification().getResourceType(id);
        panel.setLayout(new MigLayout("wrap 2", "[]20[]"));
        JLabel name = GUI.localizedLabel(type.getNameKey());
        name.setFont(GUI.SMALL_HEADER_FONT);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(GUI.localizedLabel("colopedia.resource.bonusProduction"));
        JPanel goodsPanel = new JPanel();
        goodsPanel.setOpaque(false);
        for (Modifier modifier : type.getModifiers()) {
            String text = ModifierFormat.getModifierAsString(modifier);
            if (modifier.hasScope()) {
                ArrayList<String> scopeStrings = new ArrayList<String>();
                for (Scope scope : modifier.getScopes()) {
                    if (scope.getType() == null) continue;
                    FreeColGameObjectType fcgot = this.getSpecification().findType(scope.getType());
                    scopeStrings.add(Messages.getName(fcgot));
                }
                if (!scopeStrings.isEmpty()) {
                    text = text + " (" + StringUtils.join(", ", scopeStrings) + ")";
                }
            }
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            JButton goodsButton = this.getGoodsButton(goodsType, text);
            goodsPanel.add(goodsButton);
        }
        panel.add(goodsPanel);
        panel.add((Component)GUI.localizedLabel("colopedia.resource.description"), "newline 20");
        panel.add((Component)GUI.getDefaultTextArea(Messages.getDescription(type), 30), "growx");
    }
}

