/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.BooleanOption;

public final class ReportTurnPanel
extends ReportPanel {
    private static final Logger logger = Logger.getLogger(ReportTurnPanel.class.getName());
    private List<ModelMessage> messages;
    private Hashtable<String, Vector<JComponent>> textPanesByMessage = new Hashtable();
    private Hashtable<String, Vector<JComponent>> labelsByMessage = new Hashtable();

    public ReportTurnPanel(FreeColClient freeColClient, List<ModelMessage> messages) {
        super(freeColClient, "reportTurnAction");
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new MigLayout("wrap 4", "[center][550!]:push[][]", ""));
        this.setMessages(messages);
    }

    public void setMessages(List<ModelMessage> messages) {
        this.messages = messages;
        if (messages != null) {
            this.displayMessages();
        }
    }

    private void displayMessages() {
        Game game = this.getFreeColClient().getGame();
        ClientOptions options = this.getClientOptions();
        int groupBy = options.getInteger("model.option.guiMessagesGroupBy");
        Comparator<ModelMessage> comparator = options.getModelMessageComparator(game);
        if (comparator != null) {
            Collections.sort(this.messages, comparator);
        }
        Object source = this;
        ModelMessage.MessageType type = null;
        for (ModelMessage message : this.messages) {
            switch (groupBy) {
                case 2: {
                    FreeColGameObject messageSource = game.getMessageSource(message);
                    if (messageSource == source) break;
                    source = messageSource;
                    this.reportPanel.add((Component)this.getHeadline(source), "newline 20, skip");
                    break;
                }
                case 1: {
                    if (message.getMessageType() == type) break;
                    type = message.getMessageType();
                    JLabel headline = GUI.localizedLabel(message.getMessageTypeName());
                    headline.setFont(GUI.SMALL_HEADER_FONT);
                    this.reportPanel.add((Component)headline, "newline 20, skip, span");
                    break;
                }
            }
            JComponent component = new JLabel();
            FreeColObject messageDisplay = game.getMessageDisplay(message);
            if (messageDisplay != null) {
                JButton button;
                ImageIcon icon = this.getGUI().getImageIcon(messageDisplay, false);
                if (icon != null && icon.getIconHeight() > 40) {
                    Image image = icon.getImage();
                    int newWidth = (int)((double)image.getWidth(null) / (double)image.getHeight(null) * 40.0);
                    image = image.getScaledInstance(newWidth, 40, 4);
                    icon.setImage(image);
                }
                if (messageDisplay instanceof Colony || messageDisplay instanceof Europe) {
                    button = GUI.getLinkButton(null, icon, messageDisplay.getId());
                    button.addActionListener(this);
                    component = button;
                } else if (messageDisplay instanceof Unit) {
                    button = GUI.getLinkButton(null, icon, ReportTurnPanel.upLoc(((Unit)messageDisplay).getLocation()).getId());
                    button.addActionListener(this);
                    component = button;
                } else {
                    component = new JLabel(icon);
                }
            }
            this.reportPanel.add((Component)component, "newline");
            final JTextPane textPane = GUI.getDefaultTextPane();
            this.insertMessage(textPane.getStyledDocument(), message, this.getMyPlayer());
            this.reportPanel.add(textPane);
            boolean ignore = false;
            final JComponent label = component;
            switch (message.getMessageType()) {
                case WAREHOUSE_CAPACITY: {
                    JButton ignoreButton = new JButton("x");
                    GUI.localizeToolTip((JComponent)ignoreButton, new StringTemplate("model.message.ignore", message));
                    final ModelMessage m = message;
                    ignoreButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            boolean flag = label.isEnabled();
                            ReportTurnPanel.this.igc().ignoreMessage(m, flag);
                            textPane.setEnabled(!flag);
                            label.setEnabled(!flag);
                        }
                    });
                    this.reportPanel.add(ignoreButton);
                    ignore = true;
                    break;
                }
            }
            if (!this.textPanesByMessage.containsKey(message.getId())) {
                this.textPanesByMessage.put(message.getId(), new Vector());
            }
            this.textPanesByMessage.get(message.getId()).add(textPane);
            if (!this.labelsByMessage.containsKey(message.getId())) {
                this.labelsByMessage.put(message.getId(), new Vector());
            }
            this.textPanesByMessage.get(message.getId()).add(textPane);
            this.textPanesByMessage.get(message.getId()).add(label);
            final BooleanOption filterOption = options.getBooleanOption(message);
            if (filterOption == null) continue;
            JButton filterButton = new JButton("X");
            GUI.localizeToolTip((JComponent)filterButton, StringTemplate.template("model.message.filter").add("%type%", message.getMessageTypeName()));
            final ModelMessage m = message;
            filterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean flag = filterOption.getValue();
                    filterOption.setValue(!flag);
                    ReportTurnPanel.this.setEnabledByType(m.getMessageType(), !flag);
                }
            });
            if (ignore) {
                this.reportPanel.add(filterButton);
                continue;
            }
            this.reportPanel.add((Component)filterButton, "skip");
        }
    }

    private void setEnabledByType(ModelMessage.MessageType type, boolean enabled) {
        for (ModelMessage m : this.messages) {
            if (m.getMessageType() != type) continue;
            for (JComponent textPane : this.textPanesByMessage.get(m.getId())) {
                textPane.setEnabled(enabled);
            }
            for (JComponent label : this.labelsByMessage.get(m.getId())) {
                label.setEnabled(enabled);
            }
        }
    }

    private JComponent getHeadline(Object source) {
        JComponent headline;
        if (source == null) {
            return new JLabel();
        }
        if (source instanceof Player) {
            Player player = (Player)source;
            headline = GUI.localizedLabel(StringTemplate.template("playerNation").addName("%player%", player.getName()).addStringTemplate("%nation%", player.getNationName()));
        } else if (source instanceof Europe) {
            Europe europe = (Europe)source;
            JButton button = new JButton(Messages.getName(europe));
            button.addActionListener(this);
            button.setActionCommand(europe.getId());
            headline = button;
        } else if (source instanceof Market) {
            Market market = (Market)source;
            JButton button = GUI.localizedButton(market.getOwner().getMarketName());
            button.addActionListener(this);
            button.setActionCommand(this.getMyPlayer().getEurope().getId());
            headline = button;
        } else if (source instanceof Colony) {
            Colony colony = (Colony)source;
            JButton button = new JButton(colony.getName());
            button.addActionListener(this);
            button.setActionCommand(colony.getId());
            headline = button;
        } else if (source instanceof Unit) {
            Unit unit = (Unit)source;
            JButton button = new JButton(unit.getDescription(Unit.UnitLabelType.NATIONAL));
            button.addActionListener(this);
            button.setActionCommand(unit.getLocation().getId());
            headline = button;
        } else if (source instanceof Tile) {
            Tile tile = (Tile)source;
            JButton button = GUI.localizedButton(tile.getLocationLabelFor(this.getMyPlayer()));
            button.addActionListener(this);
            button.setActionCommand(tile.getId());
            headline = button;
        } else {
            headline = source instanceof Nameable ? new JLabel(((Nameable)source).getName()) : new JLabel(source.toString());
        }
        headline.setFont(GUI.SMALL_HEADER_FONT);
        headline.setOpaque(false);
        headline.setForeground(GUI.LINK_COLOR);
        headline.setBorder(GUI.blankBorder(5, 0, 0, 0));
        return headline;
    }

    private void insertMessage(StyledDocument document, ModelMessage message, Player player) {
        try {
            int end;
            int start;
            String input = null;
            String id = message.getId();
            if (id == null || id.equals(input = Messages.message(id))) {
                input = Messages.message(message.getDefaultId());
            }
            if ((start = input.indexOf(37)) == -1) {
                this.insertText(document, input);
                return;
            }
            if (start > 0) {
                this.insertText(document, input.substring(0, start));
            }
            while ((end = input.indexOf(37, start + 1)) >= 0) {
                String var = input.substring(start, end + 1);
                String[] item = this.findReplacementData(message, var);
                FreeColGameObject messageSource = this.getFreeColClient().getGame().getMessageSource(message);
                if (item != null && var.equals(item[0])) {
                    if ("%colony%".equals(var) || var.endsWith("Colony%")) {
                        Colony colony = player.getColonyByName(item[1]);
                        if (colony != null) {
                            this.insertLinkButton(document, colony, item[1]);
                        } else if (messageSource instanceof Tile) {
                            this.insertLinkButton(document, messageSource, item[1]);
                        } else {
                            this.insertText(document, item[1]);
                        }
                    } else if ("%europe%".equals(var) || "%market%".equals(var) && player.isColonial()) {
                        this.insertLinkButton(document, player.getEurope(), Messages.getName(player.getEurope()));
                    } else if ("%unit%".equals(var) || var.endsWith("Unit%") || "%newName%".equals(var)) {
                        Tile tile = null;
                        if (messageSource instanceof Unit) {
                            tile = ((Unit)messageSource).getTile();
                        } else if (messageSource instanceof Tile) {
                            tile = (Tile)messageSource;
                        }
                        if (tile != null) {
                            Settlement settlement = tile.getSettlement();
                            if (settlement != null) {
                                this.insertLinkButton(document, settlement, item[1]);
                            } else {
                                this.insertLinkButton(document, tile, item[1]);
                            }
                        } else {
                            this.insertText(document, item[1]);
                        }
                    } else if ("%location%".equals(var) || var.endsWith("Location%")) {
                        if (messageSource instanceof Europe) {
                            this.insertLinkButton(document, player.getEurope(), Messages.getName(player.getEurope()));
                        } else if (messageSource instanceof Location) {
                            Location loc = ReportTurnPanel.upLoc((Location)((Object)messageSource));
                            this.insertLinkButton(document, (FreeColGameObject)((Object)loc), item[1]);
                        } else {
                            this.insertText(document, item[1]);
                        }
                    } else {
                        this.insertText(document, item[1]);
                    }
                    start = end + 1;
                    continue;
                }
                this.insertText(document, input.substring(start, end));
                start = end;
            }
            if (start < input.length()) {
                this.insertText(document, input.substring(start));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Insert fail: " + message, e);
        }
    }

    private String[] findReplacementData(ModelMessage message, String variable) {
        List<String> data = message.getKeys();
        if (data != null) {
            for (int index = 0; index < data.size(); ++index) {
                if (!variable.equals(data.get(index))) continue;
                return new String[]{variable, Messages.message(message.getReplacements().get(index))};
            }
        }
        return null;
    }

    private void insertText(StyledDocument document, String text) throws Exception {
        document.insertString(document.getLength(), text, document.getStyle("regular"));
    }

    private void insertLinkButton(StyledDocument document, FreeColGameObject object, String name) throws Exception {
        JButton button = GUI.getLinkButton(name, null, object.getId());
        button.addActionListener(this);
        StyleConstants.setComponent(document.getStyle("button"), button);
        document.insertString(document.getLength(), " ", document.getStyle("button"));
    }

    public static Location upLoc(Location loc) {
        if (loc instanceof Unit) {
            loc = ((Unit)loc).getLocation();
        }
        return loc == null ? null : (loc.getSettlement() != null ? loc.getSettlement() : loc);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
    }
}

