/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ReportUnitPanel;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportMilitaryPanel
extends ReportUnitPanel {
    public ReportMilitaryPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportMilitaryAction", true);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(750, 600);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    protected void gatherData() {
        List<Role> militaryRoles = this.getSpecification().getMilitaryRoles();
        for (Unit unit : this.getMyPlayer().getUnits()) {
            Role role;
            if (unit.isNaval() || !militaryRoles.contains(role = unit.getRole()) && !unit.hasAbility("model.ability.expertSoldier") && !unit.isOffensiveUnit()) continue;
            this.addUnit(unit, role.getId());
        }
    }

    @Override
    protected void addREFUnits() {
        Specification spec = this.getSpecification();
        Nation refNation = this.getMyPlayer().getNation().getREFNation();
        this.reportPanel.add((Component)GUI.localizedLabel(refNation.getNameKey()), "span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        List<AbstractUnit> refUnits = this.igc().getREFUnits();
        if (refUnits != null) {
            for (AbstractUnit au : refUnits) {
                if (au.getType(spec).isNaval()) continue;
                this.reportPanel.add((Component)this.createUnitTypeLabel(au), "sg");
            }
        }
    }

    @Override
    protected void addOwnUnits() {
        Specification spec = this.getSpecification();
        Player player = this.getMyPlayer();
        UnitType defaultType = spec.getDefaultUnitType();
        List<Role> militaryRoles = spec.getMilitaryRoles();
        militaryRoles.add(spec.getDefaultRole());
        this.reportPanel.add((Component)GUI.localizedLabel(StringTemplate.template("report.military.forces").addStringTemplate("%nation%", player.getNationName())), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        ArrayList<AbstractUnit> units = new ArrayList<AbstractUnit>();
        for (Role r : militaryRoles) {
            for (UnitType unitType : spec.getUnitTypeList()) {
                int count;
                if (!unitType.isAvailableTo(player) || unitType.isNaval() || !unitType.hasAbility("model.ability.expertSoldier") && !unitType.isOffensive() || (count = this.getCount(r.getId(), unitType)) <= 0) continue;
                units.add(new AbstractUnit(unitType, r.getId(), count));
            }
        }
        for (AbstractUnit au : units) {
            this.reportPanel.add((Component)this.createUnitTypeLabel(au), "sg");
        }
    }
}

