/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;

public final class ReportForeignAffairPanel
extends ReportPanel {
    public ReportForeignAffairPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportForeignAction");
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new MigLayout("wrap 2", "[]push[]", "[align top]"));
        for (Player enemy : this.getGame().getLiveEuropeanPlayers(null)) {
            NationSummary ns = this.igc().getNationSummary(enemy);
            if (ns == null) continue;
            MigPanel enemyPanel = new MigPanel();
            enemyPanel.setLayout(new MigLayout("gapy 0", "[][]20[align right]0[]", ""));
            enemyPanel.setOpaque(false);
            JLabel coatLabel = new JLabel();
            this.getLibrary();
            ImageIcon coatOfArms = ImageLibrary.getCoatOfArmsImageIcon(enemy.getNation());
            if (coatOfArms != null) {
                coatLabel.setIcon(coatOfArms);
            }
            enemyPanel.add((Component)coatLabel, "spany, aligny top");
            enemyPanel.add((Component)GUI.localizedLabel(enemy.getNationName()), "wrap 12");
            enemyPanel.add((Component)GUI.localizedLabel("report.stance"), "newline");
            enemyPanel.add(GUI.localizedLabel(ns.getStance().getLabel()));
            int n = ns.getNumberOfSettlements();
            enemyPanel.add((Component)GUI.localizedLabel("report.numberOfColonies"), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getNumberOfUnits();
            enemyPanel.add((Component)GUI.localizedLabel("report.numberOfUnits"), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getMilitaryStrength();
            enemyPanel.add((Component)GUI.localizedLabel("report.militaryStrength"), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getNavalStrength();
            enemyPanel.add((Component)GUI.localizedLabel("report.navalStrength"), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getGold();
            enemyPanel.add((Component)GUI.localizedLabel("goldTitle"), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getFoundingFathers();
            if (n >= 0) {
                enemyPanel.add((Component)GUI.localizedLabel("report.continentalCongress.title"), "newline 8");
                enemyPanel.add(new JLabel(Integer.toString(n)));
            }
            if ((n = ns.getTax()) >= 0) {
                enemyPanel.add((Component)GUI.localizedLabel("tax"), "newline");
                enemyPanel.add(new JLabel(Integer.toString(n)));
                enemyPanel.add(new JLabel("%"));
            }
            if ((n = ns.getSoL()) >= 0) {
                enemyPanel.add((Component)GUI.localizedLabel("report.sonsOfLiberty"), "newline");
                enemyPanel.add(new JLabel(Integer.toString(n)));
                enemyPanel.add(new JLabel("%"));
            }
            this.reportPanel.add(enemyPanel);
        }
        this.reportPanel.add((Component)GUI.getDefaultTextArea(Messages.message("report.foreignAffairs.notice"), 40), "newline 20, span 8");
        this.reportPanel.doLayout();
    }
}

