/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Region;

public final class ReportExplorationPanel
extends ReportPanel {
    private static final Comparator<Region> regionComparator = new Comparator<Region>(){

        @Override
        public int compare(Region region1, Region region2) {
            int number2;
            int number1 = region1.getDiscoveredIn().getNumber();
            if (number1 == (number2 = region2.getDiscoveredIn().getNumber())) {
                return region2.getScoreValue() - region1.getScoreValue();
            }
            return number2 - number1;
        }
    };

    public ReportExplorationPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportExplorationAction");
        this.reportPanel.removeAll();
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Region region : this.getGame().getMap().getRegions()) {
            if (region.getDiscoveredIn() == null) continue;
            regions.add(region);
        }
        Collections.sort(regions, regionComparator);
        this.reportPanel.setLayout(new MigLayout("wrap 5, fillx", "", ""));
        this.reportPanel.add(GUI.localizedLabel("report.exploration.nameOfRegion"));
        this.reportPanel.add(GUI.localizedLabel("report.exploration.typeOfRegion"));
        this.reportPanel.add(GUI.localizedLabel("report.exploration.discoveredIn"));
        this.reportPanel.add(GUI.localizedLabel("report.exploration.discoveredBy"));
        this.reportPanel.add(GUI.localizedLabel("report.exploration.valueOfRegion"));
        for (Region region : regions) {
            this.reportPanel.add(new JLabel(region.getName()));
            this.reportPanel.add(GUI.localizedLabel(region.getTypeNameKey()));
            this.reportPanel.add(GUI.localizedLabel(region.getDiscoveredIn().getLabel()));
            this.reportPanel.add(GUI.localizedLabel(region.getDiscoveredBy().getNationName()));
            this.reportPanel.add(new JLabel(String.valueOf(region.getScoreValue())));
        }
    }
}

