/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.resources.ResourceManager;

public final class ReportContinentalCongressPanel
extends ReportPanel {
    private static final String none = Messages.message("report.continentalCongress.none");

    public ReportContinentalCongressPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportCongressAction");
        JPanel panel;
        JTabbedPane tabs = new JTabbedPane(1);
        tabs.setOpaque(false);
        Player player = this.getMyPlayer();
        MigPanel recruitingPanel = new MigPanel();
        recruitingPanel.setLayout(new MigLayout("center, wrap 1", "center"));
        if (player.getCurrentFather() == null) {
            recruitingPanel.add((Component)new JLabel(none), "wrap 20");
        } else {
            FoundingFather father = player.getCurrentFather();
            String name = Messages.getName(father);
            JButton button = GUI.getLinkButton(name, null, father.getId());
            button.addActionListener(this);
            recruitingPanel.add(button);
            this.getLibrary();
            JLabel currentFatherLabel = new JLabel(new ImageIcon(ImageLibrary.getFoundingFatherImage(father)));
            currentFatherLabel.setToolTipText(Messages.getDescription(father));
            recruitingPanel.add(currentFatherLabel);
            GoodsType bellsType = this.getSpecification().getGoodsType("model.goods.bells");
            FreeColProgressBar progressBar = new FreeColProgressBar(this.getGUI(), bellsType);
            int total = 0;
            for (Colony colony : player.getColonies()) {
                total += colony.getNetProductionOf(bellsType);
            }
            int bells = player.getLiberty();
            int required = player.getTotalFoundingFatherCost();
            progressBar.update(0, required, bells, total);
            recruitingPanel.add((Component)progressBar, "wrap 20");
        }
        tabs.addTab(Messages.message("report.continentalCongress.recruiting"), null, recruitingPanel, null);
        EnumMap<FoundingFather.FoundingFatherType, MigPanel> panels = new EnumMap<FoundingFather.FoundingFatherType, MigPanel>(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            panel = new MigPanel();
            panel.setLayout(new MigLayout("flowy", "[center]"));
            panels.put(type, (MigPanel)panel);
            JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
            tabs.addTab(Messages.message(FoundingFather.getTypeKey(type)), null, scrollPane, null);
        }
        Map<String, Turn> electionTurns = this.getMyPlayer().getElectionTurns();
        for (FoundingFather father : this.getSpecification().getFoundingFathers()) {
            Image image;
            String name = Messages.getName(father);
            panel = (JPanel)panels.get((Object)father.getType());
            Turn turn = null;
            if (player.hasFather(father)) {
                this.getLibrary();
                image = ImageLibrary.getFoundingFatherImage(father);
                turn = electionTurns.get(name);
            } else {
                image = ResourceManager.getGrayscaleImage(father.getId() + ".image", 1.0);
            }
            panel.add((Component)new JLabel(new ImageIcon(image)), "newline");
            JButton button = GUI.getLinkButton(name, null, father.getId());
            button.addActionListener(this);
            panel.add(button);
            if (turn == null) continue;
            panel.add(GUI.localizedLabel("report.continentalCongress.elected"));
            panel.add(GUI.localizedLabel(turn.getLabel()));
        }
        panels.clear();
        this.setMainComponent(tabs);
    }
}

