/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;

public class PreCombatDialog
extends FreeColConfirmDialog {
    public PreCombatDialog(FreeColClient freeColClient, Unit attacker, FreeColGameObject defender) {
        super(freeColClient);
        Game game = attacker.getGame();
        CombatModel combatModel = game.getCombatModel();
        Turn turn = game.getTurn();
        Set<Modifier> attackModifiers = combatModel.getOffensiveModifiers(attacker, defender);
        Set<Modifier> defenceModifiers = combatModel.getDefensiveModifiers(attacker, defender);
        ArrayList<Modifier> offence = new ArrayList<Modifier>(attackModifiers);
        Collections.sort(offence);
        ArrayList<Modifier> defence = new ArrayList<Modifier>(defenceModifiers);
        Collections.sort(defence);
        MigPanel panel = new MigPanel(new MigLayout("wrap 6", "[sg label]20[sg value, right]1px[sg percent]40[sg label]20[sg value, right]1px[sg percent]", ""));
        String attackerName = attacker.getDescription(Unit.UnitLabelType.NATIONAL);
        UnitLabel attackerLabel = new UnitLabel(freeColClient, attacker, false, true);
        String defenderName = null;
        JLabel defenderLabel = null;
        if (combatModel.combatIsAttack(attacker, defender)) {
            Unit defenderUnit = (Unit)defender;
            defenderName = defenderUnit.getDescription(Unit.UnitLabelType.NATIONAL);
            defenderLabel = new UnitLabel(freeColClient, defenderUnit, false, true);
        } else if (combatModel.combatIsSettlementAttack(attacker, defender)) {
            Settlement settlement = (Settlement)defender;
            defenderName = settlement.getName();
            defenderLabel = new JLabel(this.getGUI().getImageIcon(settlement, false));
        } else {
            throw new IllegalStateException("Bogus attack");
        }
        panel.add((Component)new JLabel(attackerName), "span 3, align center");
        panel.add((Component)new JLabel(defenderName), "span 3, align center");
        panel.add((Component)attackerLabel, "span 3, align center");
        panel.add((Component)defenderLabel, "span 3, align center");
        panel.add((Component)new JSeparator(0), "newline, span 3, growx");
        panel.add((Component)new JSeparator(0), "span 3, growx");
        Iterator offenceI = offence.iterator();
        Iterator defenceI = defence.iterator();
        while (offenceI.hasNext() || defenceI.hasNext()) {
            JLabel[] labels;
            int skip = 0;
            boolean hasOffence = offenceI.hasNext();
            if (hasOffence) {
                labels = ModifierFormat.getModifierLabels((Modifier)offenceI.next(), null, turn);
                skip = this.addLabels(panel, labels, true, 0);
            } else {
                skip = 3;
            }
            if (!defenceI.hasNext()) continue;
            labels = ModifierFormat.getModifierLabels((Modifier)defenceI.next(), null, turn);
            this.addLabels(panel, labels, !hasOffence, skip);
        }
        Font bigFont = this.getFont().deriveFont(1, 20.0f);
        float offenceResult = FeatureContainer.applyModifiers(0.0f, turn, attackModifiers);
        JLabel finalOffenceLabel = GUI.localizedLabel("model.source.finalResult.name");
        finalOffenceLabel.setFont(bigFont);
        panel.add((Component)new JSeparator(0), "newline, span 3, growx");
        panel.add((Component)new JSeparator(0), "span 3, growx");
        panel.add(finalOffenceLabel);
        JLabel finalOffenceResult = new JLabel(ModifierFormat.format(offenceResult));
        finalOffenceResult.setFont(bigFont);
        panel.add(finalOffenceResult);
        float defenceResult = FeatureContainer.applyModifiers(0.0f, turn, defenceModifiers);
        JLabel finalDefenceLabel = GUI.localizedLabel("model.source.finalResult.name");
        finalDefenceLabel.setFont(bigFont);
        panel.add((Component)finalDefenceLabel, "skip");
        JLabel finalDefenceResult = new JLabel(ModifierFormat.format(defenceResult));
        finalDefenceResult.setFont(bigFont);
        panel.add(finalDefenceResult);
        panel.setSize(panel.getPreferredSize());
        this.initializeConfirmDialog(true, panel, null, "ok", "cancel");
    }

    private int addLabels(JPanel panel, JLabel[] labels, boolean newline, int skip) {
        String constraint;
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            if (labels[i] != null) continue;
            len = i;
        }
        String string = constraint = newline ? "newline" : null;
        if (skip > 0) {
            constraint = constraint == null ? "skip " + skip : constraint + ", skip " + skip;
        }
        for (int i = 0; i < len; ++i) {
            if (constraint != null) {
                panel.add((Component)labels[i], constraint);
                constraint = null;
                continue;
            }
            panel.add(labels[i]);
        }
        return 3 - len;
    }
}

