/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.StringUtils;

public class NationTypeDetailPanel
extends ColopediaGameObjectTypePanel<NationType> {
    public NationTypeDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.NATION_TYPES.toString(), 0.75);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        ArrayList<NationType> nations = new ArrayList<NationType>();
        nations.addAll(this.getSpecification().getEuropeanNationTypes());
        nations.addAll(this.getSpecification().getREFNationTypes());
        nations.addAll(this.getSpecification().getIndianNationTypes());
        for (NationType type : nations) {
            ImageIcon icon = new ImageIcon(ResourceManager.getImage("model.goods.bells.image", this.getScale()));
            parent.add(this.buildItem(type, icon));
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        NationType nationType = this.getSpecification().getNationType(id);
        if (nationType instanceof EuropeanNationType) {
            this.buildEuropeanNationTypeDetail((EuropeanNationType)nationType, panel);
        } else if (nationType instanceof IndianNationType) {
            this.buildIndianNationTypeDetail((IndianNationType)nationType, panel);
        }
    }

    private void buildEuropeanNationTypeDetail(EuropeanNationType nationType, JPanel panel) {
        Font boldFont = GUI.SMALLER_SIMPLE_FONT;
        Set<Ability> abilities = nationType.getAbilities();
        Set<Modifier> modifiers = nationType.getModifiers();
        panel.setLayout(new MigLayout("wrap 2, gapx 20"));
        JLabel label = GUI.localizedLabel(nationType.getNameKey());
        label.setFont(GUI.SMALL_HEADER_FONT);
        panel.add((Component)label, "span, align center, wrap 40");
        label = GUI.localizedLabel("colopedia.nationType.units");
        label.setFont(boldFont);
        panel.add((Component)label, "wrap");
        List<AbstractUnit> startingUnits = nationType.getStartingUnits();
        if (!startingUnits.isEmpty()) {
            AbstractUnit startingUnit = startingUnits.get(0);
            if (startingUnits.size() > 1) {
                panel.add((Component)this.getUnitButton(startingUnit), "span, split " + startingUnits.size());
                for (int index = 1; index < startingUnits.size(); ++index) {
                    startingUnit = startingUnits.get(index);
                    panel.add(this.getUnitButton(startingUnit));
                }
            } else {
                panel.add(this.getUnitButton(startingUnit));
            }
        }
        if (!abilities.isEmpty()) {
            label = GUI.localizedLabel("abilities");
            label.setFont(boldFont);
            panel.add((Component)label, "newline 20, span");
            for (Ability ability : abilities) {
                panel.add(this.getAbilityComponent(ability));
            }
        }
        if (!modifiers.isEmpty()) {
            label = GUI.localizedLabel("modifiers");
            label.setFont(boldFont);
            panel.add((Component)label, "newline 20, span");
            for (Modifier modifier : modifiers) {
                panel.add(this.getModifierComponent(modifier));
            }
        }
    }

    private void buildIndianNationTypeDetail(IndianNationType nationType, JPanel panel) {
        List<RandomChoice<UnitType>> skills = nationType.getSkills();
        panel.setLayout(new MigLayout("wrap 2, gapx 20", "", ""));
        JLabel name = GUI.localizedLabel(nationType.getNameKey());
        name.setFont(GUI.SMALL_HEADER_FONT);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(GUI.localizedLabel("colopedia.nationType.aggression"));
        panel.add(GUI.localizedLabel("colopedia.nationType.aggression." + nationType.getAggression().toString().toLowerCase()));
        panel.add(GUI.localizedLabel("colopedia.nationType.numberOfSettlements"));
        panel.add(GUI.localizedLabel("colopedia.nationType.numberOfSettlements." + nationType.getNumberOfSettlements().toString().toLowerCase()));
        panel.add(GUI.localizedLabel("colopedia.nationType.typeOfSettlements"));
        panel.add(new JLabel(Messages.getName(nationType.getCapitalType()), new ImageIcon(this.getLibrary().getSettlementImage(nationType.getCapitalType())), 0));
        ArrayList<String> regionNames = new ArrayList<String>();
        for (String regionName : nationType.getRegionNames()) {
            regionNames.add(Messages.getName(regionName));
        }
        panel.add(GUI.localizedLabel("colopedia.nationType.regions"));
        panel.add(new JLabel(StringUtils.join(", ", regionNames)));
        panel.add((Component)GUI.localizedLabel("colopedia.nationType.skills"), "top, newline 20");
        GridLayout gridLayout = new GridLayout(0, 2);
        gridLayout.setHgap(10);
        JPanel unitPanel = new JPanel(gridLayout);
        unitPanel.setOpaque(false);
        for (RandomChoice<UnitType> choice : skills) {
            unitPanel.add(this.getUnitButton(choice.getObject()));
        }
        panel.add(unitPanel);
    }
}

