/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class MiniMap
extends JPanel
implements MouseInputListener {
    private static final Logger logger = Logger.getLogger(MiniMap.class.getName());
    public static final int MAX_TILE_SIZE = 24;
    public static final int MIN_TILE_SIZE = 4;
    public static final int SCALE_STEP = 4;
    private final FreeColClient freeColClient;
    private final GUI gui;
    private Color backgroundColor = ResourceManager.getColor("miniMapBackground.color");
    private Image backgroundImage = ResourceManager.getImage("MiniMap.back");
    private int tileSize;
    private int firstColumn;
    private int firstRow;
    private int adjustX = 0;
    private int adjustY = 0;

    public MiniMap(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
        this.backgroundColor = Color.BLACK;
        this.setLayout(null);
        this.tileSize = 4 * (freeColClient.getClientOptions().getInteger("model.option.defaultZoomLevel") + 1);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void zoomIn() {
        this.tileSize = Math.min(this.tileSize + 4, 24);
        this.setZoomOption(this.tileSize);
        this.repaint();
    }

    public void zoomOut() {
        this.tileSize = Math.max(this.tileSize - 4, 4);
        this.setZoomOption(this.tileSize);
        this.repaint();
    }

    public void setTileSize(int size) {
        this.tileSize = Math.max(Math.min(size, 24), 4);
        this.setZoomOption(this.tileSize);
        this.repaint();
    }

    public boolean canZoomIn() {
        return this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null && this.tileSize < 24;
    }

    public boolean canZoomOut() {
        return this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null && this.tileSize > 4;
    }

    private void setZoomOption(int tileSize) {
        int zoom = tileSize / 4 - 1;
        this.freeColClient.getClientOptions().setInteger("model.option.defaultZoomLevel", zoom);
    }

    public void setToggleBordersOption(boolean toggle) {
        this.freeColClient.getClientOptions().setBoolean("model.option.miniMapToggleBorders", toggle);
    }

    public void setToggleFogOfWarOption(boolean toggle) {
        this.freeColClient.getClientOptions().setBoolean("model.option.miniMapToggleFogOfWar", toggle);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        graphics.drawImage(this.backgroundImage, 0, 0, null);
        this.paintMap(graphics);
    }

    private Color getMinimapEconomicColor(TileType type) {
        return ResourceManager.getColor(type.getId() + ".economicColor");
    }

    private Color getMinimapPoliticsColor(TileType type) {
        return ResourceManager.getColor(type.getId() + ".politicsColor");
    }

    public void paintMap(Graphics graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g = (Graphics2D)graphics;
        AffineTransform originTransform = g.getTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(ResourceManager.getColor("miniMapBackground.color"));
        g.fillRect(0, 0, width, height);
        if (this.gui.getFocus() == null) {
            return;
        }
        int xSize = width / this.tileSize;
        int ySize = height / this.tileSize * 4;
        this.firstColumn = this.gui.getFocus().getX() - xSize / 2;
        this.firstRow = this.gui.getFocus().getY() - ySize / 2;
        Map map = this.freeColClient.getGame().getMap();
        if (this.firstColumn < 0) {
            this.firstColumn = 0;
        } else if (this.firstColumn + xSize + 1 > map.getWidth()) {
            this.firstColumn = map.getWidth() - xSize - 1;
        }
        if (this.firstRow < 0) {
            this.firstRow = 0;
        } else if (this.firstRow + ySize + 1 > map.getHeight()) {
            this.firstRow = map.getHeight() - ySize - 1;
        }
        if (map.getWidth() <= xSize) {
            this.firstColumn = 0;
            this.adjustX = (xSize - map.getWidth()) * this.tileSize / 2;
            width = map.getWidth() * this.tileSize;
        } else {
            this.adjustX = 0;
        }
        if (map.getHeight() <= ySize) {
            this.firstRow = 0;
            this.adjustY = (ySize - map.getHeight()) * this.tileSize / 4;
            height = map.getHeight() * (this.tileSize / 4);
        } else {
            this.adjustY = 0;
        }
        int lastRow = Math.min(this.firstRow + ySize, map.getHeight() - 1);
        int lastColumn = Math.min(this.firstColumn + xSize, map.getWidth() - 1);
        int tileWidth = this.tileSize;
        int tileHeight = this.tileSize / 2;
        int halfWidth = this.tileSize / 2;
        int halfHeight = this.tileSize / 4;
        GeneralPath tilePath = new GeneralPath();
        tilePath.moveTo(halfWidth, 0.0f);
        tilePath.lineTo(tileWidth, halfHeight);
        tilePath.lineTo(halfWidth, tileHeight);
        tilePath.lineTo(0.0f, halfHeight);
        tilePath.closePath();
        GeneralPath settlementPath = new GeneralPath(tilePath);
        settlementPath.transform(AffineTransform.getScaleInstance(0.7, 0.7));
        settlementPath.transform(AffineTransform.getTranslateInstance(0.15 * (double)tileWidth, 0.15 * (double)tileHeight));
        GeneralPath unitPath = new GeneralPath(tilePath);
        unitPath.transform(AffineTransform.getScaleInstance(0.5, 0.5));
        unitPath.transform(AffineTransform.getTranslateInstance(0.25 * (double)tileWidth, 0.25 * (double)tileHeight));
        GeneralPath paintFull = new GeneralPath(tilePath);
        paintFull.transform(AffineTransform.getScaleInstance(1.0, 1.0));
        g.setStroke(new BasicStroke(1.0f));
        AffineTransform baseTransform = g.getTransform();
        AffineTransform rowTransform = null;
        ImageLibrary library = this.gui.getImageLibrary();
        ClientOptions clientOptions = this.freeColClient.getClientOptions();
        for (int row = this.firstRow; row <= lastRow; ++row) {
            rowTransform = g.getTransform();
            if ((row & 1) == 1) {
                g.translate(halfWidth, 0);
            }
            for (int column = this.firstColumn; column <= lastColumn; ++column) {
                Tile tile = map.getTile(column, row);
                if (tile.isExplored()) {
                    if (clientOptions.getBoolean("model.option.miniMapToggleBorders")) {
                        g.setColor(this.getMinimapPoliticsColor(tile.getType()));
                        g.fill(tilePath);
                        if (tile.getOwner() != null) {
                            Color nationOwner = tile.getOwner().getNationColor();
                            Color colorTransparent = new Color(nationOwner.getRed(), nationOwner.getGreen(), nationOwner.getBlue(), 100);
                            g.setColor(colorTransparent);
                            g.fill(paintFull);
                        }
                    } else {
                        g.setColor(this.getMinimapEconomicColor(tile.getType()));
                        g.fill(tilePath);
                    }
                    if (!tile.hasSettlement()) {
                        Unit unit = tile.getFirstUnit();
                        if (unit != null) {
                            g.setColor(Color.BLACK);
                            g.draw(unitPath);
                            g.setColor(unit.getOwner().getNationColor());
                            g.fill(unitPath);
                        }
                    } else {
                        g.setColor(Color.BLACK);
                        g.draw(settlementPath);
                        g.setColor(tile.getSettlement().getOwner().getNationColor());
                        g.fill(settlementPath);
                    }
                    if (!this.freeColClient.isMapEditor() && !this.freeColClient.getMyPlayer().canSee(tile) && clientOptions.getBoolean("model.option.miniMapToggleFogOfWar")) {
                        Color blackTransparent = new Color(0, 0, 0, 100);
                        g.setColor(blackTransparent);
                        g.fill(paintFull);
                    }
                }
                g.translate(tileWidth, 0);
            }
            g.setTransform(rowTransform);
            g.translate(0, halfHeight);
        }
        g.setTransform(baseTransform);
        if (this.getParent() != null) {
            TileType tileType = this.freeColClient.getGame().getSpecification().getTileTypeList().get(0);
            int miniRectX = (this.gui.getFocus().getX() - this.firstColumn) * this.tileSize;
            int miniRectY = (this.gui.getFocus().getY() - this.firstRow) * this.tileSize / 4;
            Image image = library.getTerrainImage(tileType, 0, 0);
            int miniRectWidth = (this.getParent().getWidth() / image.getWidth(null) + 1) * this.tileSize;
            int miniRectHeight = (this.getParent().getHeight() / image.getHeight(null) + 1) * this.tileSize / 2;
            if (miniRectX + miniRectWidth / 2 > width) {
                miniRectX = width - miniRectWidth / 2 - 1;
            } else if (miniRectX - miniRectWidth / 2 < 0) {
                miniRectX = miniRectWidth / 2;
            }
            if (miniRectY + miniRectHeight / 2 > height) {
                miniRectY = height - miniRectHeight / 2 - 1;
            } else if (miniRectY - miniRectHeight / 2 < 0) {
                miniRectY = miniRectHeight / 2;
            }
            g.setColor(ResourceManager.getColor("miniMapBorder.color"));
            int miniRectMaxX = Math.max(miniRectX - miniRectWidth / 2, 0);
            int miniRectMaxY = Math.max(miniRectY - miniRectHeight / 2, 0);
            int miniRectMinWidth = Math.min(miniRectWidth, width - 1);
            int miniRectMinHeight = Math.min(miniRectHeight, height - 1);
            if (miniRectMaxX + miniRectMinWidth > width - 1) {
                miniRectMaxX = width - miniRectMinWidth - 1;
            }
            if (miniRectMaxY + miniRectMinHeight > height - 1) {
                miniRectMaxY = height - miniRectMinHeight - 1;
            }
            g.drawRect(miniRectMaxX, miniRectMaxY, miniRectMinWidth, miniRectMinHeight);
            if (this.adjustX > 0 && this.adjustY > 0) {
                g.setColor(ResourceManager.getColor("miniMapBorder.color"));
                g.drawRect(0, 0, width - 1, height - 1);
            }
        }
        g.setTransform(originTransform);
    }

    private void focus(int x, int y) {
        int tileY;
        int tileX;
        if (this.adjustX > 0 && this.adjustY > 0) {
            tileX = (x - this.adjustX) / this.tileSize + this.firstColumn + this.adjustX / 4;
            tileY = (y - this.adjustY) / this.tileSize * 4 + this.firstRow + this.adjustY;
        } else {
            tileX = (x - this.adjustX) / this.tileSize + this.firstColumn;
            tileY = (y - this.adjustY) / this.tileSize * 4 + this.firstRow;
        }
        this.gui.setFocus(this.freeColClient.getGame().getMap().getTile(tileX, tileY));
    }

    private void focus(MouseEvent e) {
        if (e.getComponent().isEnabled()) {
            this.focus(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.focus(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.focus(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

