/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.panel.InfoPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;

public abstract class MapControls {
    public static final int MAP_WIDTH = 220;
    public static final int MAP_HEIGHT = 128;
    public static final int GAP = 4;
    public static final int CONTROLS_LAYER = JLayeredPane.MODAL_LAYER;
    protected final FreeColClient freeColClient;
    protected final InfoPanel infoPanel;
    protected MiniMap miniMap;
    protected final UnitButton miniMapToggleBorders;
    protected final UnitButton miniMapToggleFogOfWarButton;
    protected final UnitButton miniMapZoomOutButton;
    protected final UnitButton miniMapZoomInButton;
    protected final List<UnitButton> unitButtons;

    public MapControls(FreeColClient freeColClient, boolean useSkin) {
        this.freeColClient = freeColClient;
        this.infoPanel = new InfoPanel(freeColClient, useSkin);
        this.miniMap = new MiniMap(freeColClient);
        ActionManager am = freeColClient.getActionManager();
        this.unitButtons = new ArrayList<UnitButton>();
        Game game = freeColClient.getGame();
        if (game != null) {
            this.unitButtons.add(new UnitButton(am, "waitAction"));
            this.unitButtons.add(new UnitButton(am, "skipUnitAction"));
            this.unitButtons.add(new UnitButton(am, "sentryAction"));
            this.unitButtons.add(new UnitButton(am, "fortifyAction"));
            Specification spec = game.getSpecification();
            if (spec != null) {
                for (TileImprovementType type : spec.getTileImprovementTypeList()) {
                    FreeColAction action = am.getFreeColAction(type.getSuffix() + "Action");
                    if (type.isNatural() || action == null || !action.hasOrderButtons()) continue;
                    this.unitButtons.add(new UnitButton(am, type.getSuffix() + "Action"));
                }
            }
            this.unitButtons.add(new UnitButton(am, "buildColonyAction"));
            this.unitButtons.add(new UnitButton(am, "disbandUnitAction"));
        }
        this.miniMapToggleBorders = new UnitButton(am, "miniMapToggleBordersAction");
        this.miniMapToggleFogOfWarButton = new UnitButton(am, "miniMapToggleFogOfWarAction");
        this.miniMapZoomOutButton = new UnitButton(am, "miniMapZoomOutAction");
        this.miniMapZoomInButton = new UnitButton(am, "miniMapZoomInAction");
        this.miniMapToggleBorders.setFocusable(false);
        this.miniMapToggleFogOfWarButton.setFocusable(false);
        this.miniMapZoomOutButton.setFocusable(false);
        this.miniMapZoomInButton.setFocusable(false);
        this.infoPanel.setFocusable(false);
        for (UnitButton button : this.unitButtons) {
            button.setFocusable(false);
        }
    }

    public abstract void addToComponent(Canvas var1);

    public boolean canZoomInMapControls() {
        return this.miniMap != null && this.miniMap.canZoomIn();
    }

    public boolean canZoomOutMapControls() {
        return this.miniMap != null && this.miniMap.canZoomOut();
    }

    public abstract boolean isShowing();

    public abstract void removeFromComponent(Canvas var1);

    public abstract void repaint();

    public void toggleView() {
        this.miniMap.setToggleBordersOption(!this.freeColClient.getClientOptions().getBoolean("model.option.miniMapToggleBorders"));
        this.repaint();
    }

    public void toggleFogOfWar() {
        this.miniMap.setToggleFogOfWarOption(!this.freeColClient.getClientOptions().getBoolean("model.option.miniMapToggleFogOfWar"));
        this.repaint();
    }

    public void update() {
        GUI gui = this.freeColClient.getGUI();
        Unit unit = gui.getActiveUnit();
        switch (gui.getViewMode()) {
            case 0: {
                this.infoPanel.update(unit);
                break;
            }
            case 1: {
                this.infoPanel.update(gui.getSelectedTile());
                break;
            }
        }
        for (UnitButton ub : this.unitButtons) {
            ub.setVisible(unit != null);
        }
    }

    public void update(MapEditorTransformPanel.MapTransform mapTransform) {
        if (this.infoPanel != null) {
            this.infoPanel.update(mapTransform);
        }
    }

    public void zoomIn() {
        this.miniMap.zoomIn();
        this.repaint();
    }

    public void zoomOut() {
        this.miniMap.zoomOut();
        this.repaint();
    }
}

