/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.resources.ResourceManager;

public class FirstContactDialog
extends FreeColConfirmDialog {
    private static String BASE_KEY = "event.meeting.";
    private static String IMAGE_BASE_KEY = "EventImage.meeting.";
    private static String NATIVES_KEY = "natives";
    private static String TUTORIAL_KEY = BASE_KEY + NATIVES_KEY + ".tutorial";

    public FirstContactDialog(FreeColClient freeColClient, Player player, Player other, Tile tile, int settlementCount) {
        super(freeColClient);
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "[center]", "[]20"));
        String headerKey = BASE_KEY + other.getNationNameKey();
        String imageKey = IMAGE_BASE_KEY + other.getNationNameKey();
        if (!Messages.containsKey(headerKey)) {
            headerKey = BASE_KEY + NATIVES_KEY;
            imageKey = IMAGE_BASE_KEY + NATIVES_KEY;
        }
        JLabel header = GUI.localizedLabel(headerKey);
        header.setFont(GUI.MEDIUM_HEADER_FONT);
        JLabel image = new JLabel(new ImageIcon(ResourceManager.getImage(imageKey)));
        JTextArea tutorial = null;
        if (!player.hasContactedIndians() && freeColClient.tutorialMode()) {
            tutorial = GUI.getDefaultTextArea(Messages.message(TUTORIAL_KEY));
        }
        String messageId = tile != null ? "welcomeOffer.text" : "welcomeSimple.text";
        String type = ((IndianNationType)other.getNationType()).getSettlementTypeKey(true);
        StringTemplate template = StringTemplate.template(messageId).addStringTemplate("%nation%", other.getNationName()).addName("%camps%", Integer.toString(settlementCount)).add("%settlementType%", type);
        JTextArea text = GUI.getDefaultTextArea(template);
        int columns = (int)Math.floor((double)text.getColumns() * image.getPreferredSize().getWidth() / text.getPreferredSize().getWidth());
        text.setColumns(columns);
        text.setSize(text.getPreferredSize());
        if (tutorial != null) {
            tutorial.setColumns(columns);
            tutorial.setSize(tutorial.getPreferredSize());
        }
        panel.add(header);
        panel.add(image);
        if (tutorial != null) {
            panel.add(tutorial);
        }
        panel.add(text);
        panel.setSize(panel.getPreferredSize());
        ImageIcon icon = this.getImageLibrary().getImageIcon(other, false);
        this.initializeConfirmDialog(false, panel, icon, "welcome.yes", "welcome.no");
    }
}

