/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.io.FreeColDirectories;

public final class ErrorPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(ErrorPanel.class.getName());
    private static final String SHOW = "show";

    public ErrorPanel(FreeColClient freeColClient, String message) {
        super(freeColClient, new MigLayout());
        JButton showButton = GUI.localizedButton("errorMessage.showLogFile");
        showButton.setActionCommand(SHOW);
        showButton.addActionListener(this);
        this.add((Component)GUI.getDefaultTextArea(message, 40), "wrap 20");
        this.add((Component)this.okButton, "split 2, tag ok");
        this.add(showButton);
    }

    public ErrorPanel(FreeColClient freeColClient) {
        super(freeColClient, new MigLayout());
        File logFile = new File(FreeColDirectories.getLogFilePath());
        byte[] buffer = new byte[(int)logFile.length()];
        String message = null;
        try (FileInputStream fis = new FileInputStream(logFile);
             BufferedInputStream logFileStream = new BufferedInputStream(fis);){
            logFileStream.read(buffer);
            message = new String(buffer, "UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        JTextArea textArea = GUI.getDefaultTextArea(message, 40);
        textArea.setFocusable(true);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        this.add((Component)scrollPane, "height 200:200:, wrap 20");
        this.add((Component)this.okButton, "tag ok");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (SHOW.equals(command)) {
            this.getGUI().showLogFilePanel();
        } else {
            super.actionPerformed(event);
        }
    }
}

