/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.OptionsDialog;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

public final class DifficultyDialog
extends OptionsDialog
implements TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(DifficultyDialog.class.getName());
    private static final FileFilter[] filters = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return Messages.message("filter.xml");
        }
    }};
    private OptionGroup selected;
    private Specification specification;

    public DifficultyDialog(FreeColClient freeColClient, Specification specification, OptionGroup level, boolean editable) {
        super(freeColClient, editable, level, Messages.message("difficulty"), "custom.xml", "model.difficulty.custom");
        this.specification = specification;
        this.selected = level;
        this.getOptionUI().getTree().addTreeSelectionListener(this);
        if (this.isEditable()) {
            this.loadDefaultOptions();
            JButton resetButton = GUI.localizedButton("reset");
            this.addResetAction(resetButton);
            JButton loadButton = GUI.localizedButton("load");
            this.addLoadAction(loadButton);
            JButton saveButton = GUI.localizedButton("save");
            this.addSaveAction(saveButton);
            this.panel.add((Component)resetButton, "span, split 3");
            this.panel.add(loadButton);
            this.panel.add(saveButton);
        }
        this.initialize();
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    private void addResetAction(JButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DifficultyDialog.this.getOptionUI().reset();
            }
        });
    }

    private void addLoadAction(JButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File dir = FreeColDirectories.getOptionsDirectory();
                File file = DifficultyDialog.this.getGUI().showLoadDialog(dir, filters);
                if (file != null && DifficultyDialog.this.load(file)) {
                    DifficultyDialog.this.invalidate();
                    DifficultyDialog.this.validate();
                    DifficultyDialog.this.repaint();
                }
            }
        });
    }

    private void addSaveAction(JButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File dir = FreeColDirectories.getOptionsDirectory();
                File file = DifficultyDialog.this.getGUI().showSaveDialog(dir, filters, DifficultyDialog.this.getDefaultFileName(), ".xml");
                if (file != null) {
                    DifficultyDialog.this.getOptionUI().updateOption();
                    DifficultyDialog.this.save(file);
                }
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getPath();
        if (path.getPathCount() >= 2) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(1);
            this.selected = (OptionGroup)node.getUserObject();
        }
    }

    @Override
    public OptionGroup getResponse() {
        OptionGroup value = super.getResponse();
        if (value != null) {
            FreeCol.setDifficulty(value);
        }
        return value;
    }
}

