/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.BuildingToolTip;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Unit;

public class BuildingPanel
extends MigPanel
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(BuildingPanel.class.getName());
    private final FreeColClient freeColClient;
    private final Building building;
    private ProductionLabel productionOutput = null;
    private List<UnitLabel> unitLabels = new ArrayList<UnitLabel>();

    public BuildingPanel(FreeColClient freeColClient, Building building) {
        super(new MigLayout("", "[32][32][32]", "[32][44]"));
        this.freeColClient = freeColClient;
        this.building = building;
        this.setToolTipText(" ");
    }

    public void initialize() {
        this.cleanup();
        this.addPropertyChangeListeners();
        this.update();
    }

    public void cleanup() {
        this.unitLabels.clear();
        this.productionOutput = null;
        this.removePropertyChangeListeners();
        this.removeAll();
    }

    protected void addPropertyChangeListeners() {
        if (this.building != null) {
            this.building.addPropertyChangeListener(this);
        }
    }

    protected void removePropertyChangeListeners() {
        if (this.building != null) {
            this.building.removePropertyChangeListener(this);
        }
    }

    public void update() {
        AbstractGoods output;
        this.removeAll();
        this.unitLabels.clear();
        this.productionOutput = null;
        ProductionInfo info = this.building.getProductionInfo();
        if (info != null && !info.getProduction().isEmpty() && (output = info.getProduction().get(0)).getAmount() > 0) {
            if (this.building.hasAbility("model.ability.avoidExcessProduction")) {
                int stored = this.building.getColony().getGoodsCount(output.getType());
                int capacity = this.building.getColony().getWarehouseCapacity();
                if (output.getAmount() + stored > capacity) {
                    output = new AbstractGoods(output.getType(), capacity - stored);
                }
            }
            AbstractGoods maximum = info.getMaximumProduction().isEmpty() ? output : info.getMaximumProduction().get(0);
            this.productionOutput = new ProductionLabel(this.freeColClient, output, maximum);
        }
        UpkeepLabel upkeep = null;
        if (this.building.getSpecification().getBoolean("model.option.enableUpkeep") && this.building.getType().getUpkeep() > 0) {
            upkeep = new UpkeepLabel(this.building.getType().getUpkeep());
        }
        if (this.productionOutput == null) {
            if (upkeep != null) {
                this.add(upkeep, "span, align center");
            }
        } else if (upkeep == null) {
            this.add((Component)this.productionOutput, "span, align center");
        } else {
            this.add((Component)this.productionOutput, "span, split 2, align center");
            this.add(upkeep);
        }
        for (Unit unit : this.building.getUnitList()) {
            UnitLabel unitLabel = new UnitLabel(this.freeColClient, unit, true);
            this.unitLabels.add(unitLabel);
            this.add(unitLabel);
        }
        this.setSize(new Dimension(96, 76));
        this.revalidate();
        this.repaint();
    }

    public Building getBuilding() {
        return this.building;
    }

    public List<UnitLabel> getUnitLabels() {
        return this.unitLabels;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        logger.finest(this.building.getId() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
        this.update();
    }

    @Override
    public JToolTip createToolTip() {
        return new BuildingToolTip(this.freeColClient, this.building);
    }

    @Override
    public void paintComponent(Graphics g) {
        ImageLibrary lib = this.freeColClient.getGUI().getImageLibrary();
        g.drawImage(ImageLibrary.fadeImage(lib.getBuildingImage(this.building), 0.6f, 192.0f), 0, 0, this);
    }

    public class UpkeepLabel
    extends JLabel {
        private final Image image;

        public UpkeepLabel(int number) {
            super(BuildingPanel.this.freeColClient.getGUI().getImageLibrary().getMiscImageIcon("coin"));
            ImageLibrary lib = BuildingPanel.this.freeColClient.getGUI().getImageLibrary();
            this.image = ImageLibrary.getStringImage(BuildingPanel.this.freeColClient.getGUI().getCanvas().getGraphics(), Integer.toString(number), this.getForeground(), GUI.TINY_SIMPLE_FONT);
        }

        @Override
        public void paintComponent(Graphics g) {
            this.getIcon().paintIcon(null, g, 0, 0);
            g.drawImage(this.image, (this.getIcon().getIconWidth() - this.image.getWidth(null)) / 2, (this.getIcon().getIconHeight() - this.image.getHeight(null)) / 2, null);
        }
    }
}

