/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.common.option.IntegerOption;

public final class IntegerOptionUI
extends OptionUI<IntegerOption> {
    private JSpinner spinner = new JSpinner();

    public IntegerOptionUI(GUI gui, IntegerOption option, boolean editable) {
        super(gui, option, editable);
        int value = option.getValue();
        if (editable) {
            int max;
            int min = option.getMinimumValue();
            if (min > (max = option.getMaximumValue())) {
                int tmp = min;
                min = max;
                max = tmp;
            }
            int stepSize = Math.max(1, Math.min((max - min) / 10, 1000));
            this.spinner.setModel(new SpinnerNumberModel(value, min, max, stepSize));
        } else {
            this.spinner.setModel(new SpinnerNumberModel(value, value, value, 1));
        }
        this.initialize();
    }

    @Override
    public JComponent getComponent() {
        return this.spinner;
    }

    @Override
    public void updateOption() {
        ((IntegerOption)this.getOption()).setValue((Integer)this.spinner.getValue());
    }

    @Override
    public void reset() {
        this.spinner.setValue(((IntegerOption)this.getOption()).getValue());
    }
}

