/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.option.FileOption;

public final class FileOptionUI
extends OptionUI<FileOption> {
    private JPanel panel = new JPanel();
    private final JTextField fileField;

    public FileOptionUI(final GUI gui, FileOption option, boolean editable) {
        super(gui, option, editable);
        this.panel.add(this.getJLabel());
        File file = option.getValue();
        this.fileField = new JTextField(file == null ? null : file.getAbsolutePath(), 20);
        this.fileField.setToolTipText(file == null ? null : file.getAbsolutePath());
        this.fileField.setDisabledTextColor(Color.BLACK);
        this.panel.add(this.fileField);
        JButton browse = GUI.localizedButton("file.browse");
        if (editable) {
            browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = gui.showLoadDialog(FreeColDirectories.getSaveDirectory());
                    if (file == null) {
                        return;
                    }
                    if (!file.isFile()) {
                        gui.showErrorMessage("fileNotFound");
                        return;
                    }
                    FileOptionUI.this.setValue(file);
                }
            });
        }
        this.panel.add(browse);
        JButton remove = GUI.localizedButton("option.remove");
        if (editable) {
            remove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileOptionUI.this.setValue(null);
                }
            });
        }
        this.panel.add(remove);
        browse.setEnabled(editable);
        remove.setEnabled(editable);
        this.fileField.setEnabled(false);
        this.getJLabel().setLabelFor(this.fileField);
    }

    public void setValue(File f) {
        ((FileOption)this.getOption()).setValue(f);
        this.reset();
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        File f = "".equals(this.fileField.getText()) ? null : new File(this.fileField.getText());
        ((FileOption)this.getOption()).setValue(f);
    }

    @Override
    public void reset() {
        File file = ((FileOption)this.getOption()).getValue();
        String text = file == null ? "" : file.getAbsolutePath();
        this.fileField.setText(text);
        this.fileField.setToolTipText(text);
    }
}

