/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

final class UnitMoveAnimation {
    private static final int ANIMATION_DELAY = 33;
    private final Unit unit;
    private final Tile sourceTile;
    private final Tile destinationTile;
    private GUI gui;

    public UnitMoveAnimation(GUI gui, Unit unit, Tile sourceTile, Tile destinationTile) {
        this.gui = gui;
        this.unit = unit;
        this.sourceTile = sourceTile;
        this.destinationTile = destinationTile;
    }

    public void animate() {
        int movementSpeed = this.gui.getAnimationSpeed(this.unit);
        final Point srcP = this.gui.getTilePosition(this.sourceTile);
        final Point dstP = this.gui.getTilePosition(this.destinationTile);
        if (srcP == null || dstP == null || movementSpeed <= 0) {
            return;
        }
        float scale = this.gui.getMapScale();
        final int movementRatio = (int)(Math.pow(2.0, movementSpeed + 1) * (double)scale);
        Rectangle r1 = this.gui.getTileBounds(this.sourceTile);
        Rectangle r2 = this.gui.getTileBounds(this.destinationTile);
        final Rectangle bounds = r1.union(r2);
        this.gui.executeWithUnitOutForAnimation(this.unit, this.sourceTile, new OutForAnimationCallback(){

            @Override
            public void executeWithUnitOutForAnimation(JLabel unitLabel) {
                int stepX;
                Point srcPoint = UnitMoveAnimation.this.gui.getMapViewer().getUnitLabelPositionInTile(unitLabel, srcP);
                Point dstPoint = UnitMoveAnimation.this.gui.getMapViewer().getUnitLabelPositionInTile(unitLabel, dstP);
                double xratio = (double)UnitMoveAnimation.this.gui.getMapViewer().getTileWidth() / (double)UnitMoveAnimation.this.gui.getMapViewer().getTileHeight();
                int n = srcPoint.getX() == dstPoint.getX() ? 0 : (stepX = srcPoint.getX() > dstPoint.getX() ? -1 : 1);
                int stepY = srcPoint.getY() == dstPoint.getY() ? 0 : (srcPoint.getY() > dstPoint.getY() ? -1 : 1);
                UnitMoveAnimation.this.gui.paintImmediatelyCanvasInItsBounds();
                int dropFrames = 0;
                Point point = srcPoint;
                while (!point.equals(dstPoint)) {
                    long time = System.currentTimeMillis();
                    point.x = (int)((double)point.x + (double)stepX * xratio * (double)movementRatio);
                    point.y += stepY * movementRatio;
                    if (stepX < 0 && point.x < dstPoint.x || stepX > 0 && point.x > dstPoint.x) {
                        point.x = dstPoint.x;
                    }
                    if (stepY < 0 && point.y < dstPoint.y || stepY > 0 && point.y > dstPoint.y) {
                        point.y = dstPoint.y;
                    }
                    if (dropFrames <= 0) {
                        unitLabel.setLocation(point);
                        UnitMoveAnimation.this.gui.paintImmediatelyCanvasIn(bounds);
                        int timeTaken = (int)(System.currentTimeMillis() - time);
                        int waitTime = 33 - timeTaken;
                        if (waitTime > 0) {
                            try {
                                Thread.sleep(waitTime);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                            dropFrames = 0;
                            continue;
                        }
                        dropFrames = timeTaken / 33 - 1;
                        continue;
                    }
                    --dropFrames;
                }
            }
        });
    }
}

