/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.common.io.sza.AnimationEvent;
import net.sf.freecol.common.io.sza.ImageAnimationEvent;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class UnitImageAnimation {
    private final Unit unit;
    private final Tile tile;
    private final SimpleZippedAnimation animation;
    private GUI gui;

    public UnitImageAnimation(GUI gui, Unit unit, Tile tile, SimpleZippedAnimation animation) {
        this.gui = gui;
        this.unit = unit;
        this.tile = tile;
        this.animation = animation;
    }

    public void animate() {
        if (this.gui.getTilePosition(this.tile) == null) {
            return;
        }
        this.gui.paintImmediatelyCanvasInItsBounds();
        this.gui.executeWithUnitOutForAnimation(this.unit, this.tile, new OutForAnimationCallback(){

            @Override
            public void executeWithUnitOutForAnimation(JLabel unitLabel) {
                for (AnimationEvent event : UnitImageAnimation.this.animation) {
                    long time = System.nanoTime();
                    if (!(event instanceof ImageAnimationEvent)) continue;
                    ImageAnimationEvent ievent = (ImageAnimationEvent)event;
                    ImageIcon icon = (ImageIcon)unitLabel.getIcon();
                    icon.setImage(ievent.getImage());
                    UnitImageAnimation.this.gui.paintImmediatelyCanvasIn(UnitImageAnimation.this.getDirtyAnimationArea());
                    time = (long)ievent.getDurationInMs() - (System.nanoTime() - time) / 1000000L;
                    if (time <= 0L) continue;
                    try {
                        Thread.sleep(time);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        });
    }

    protected Rectangle getDirtyAnimationArea() {
        return this.gui.getTileBounds(this.tile);
    }
}

