/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.action.AboutAction;
import net.sf.freecol.client.gui.action.AssignTradeRouteAction;
import net.sf.freecol.client.gui.action.BuildColonyAction;
import net.sf.freecol.client.gui.action.CenterAction;
import net.sf.freecol.client.gui.action.ChangeAction;
import net.sf.freecol.client.gui.action.ChangeWindowedModeAction;
import net.sf.freecol.client.gui.action.ChatAction;
import net.sf.freecol.client.gui.action.ClearOrdersAction;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.action.ContinueAction;
import net.sf.freecol.client.gui.action.DebugAction;
import net.sf.freecol.client.gui.action.DeclareIndependenceAction;
import net.sf.freecol.client.gui.action.DetermineHighSeasAction;
import net.sf.freecol.client.gui.action.DisbandUnitAction;
import net.sf.freecol.client.gui.action.DisplayBordersAction;
import net.sf.freecol.client.gui.action.DisplayGridAction;
import net.sf.freecol.client.gui.action.DisplayTileTextAction;
import net.sf.freecol.client.gui.action.EndTurnAction;
import net.sf.freecol.client.gui.action.EuropeAction;
import net.sf.freecol.client.gui.action.ExecuteGotoOrdersAction;
import net.sf.freecol.client.gui.action.FindSettlementAction;
import net.sf.freecol.client.gui.action.FortifyAction;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.action.GotoAction;
import net.sf.freecol.client.gui.action.GotoTileAction;
import net.sf.freecol.client.gui.action.ImprovementAction;
import net.sf.freecol.client.gui.action.LoadAction;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.action.MapEditorAction;
import net.sf.freecol.client.gui.action.MiniMapToggleFogOfWarAction;
import net.sf.freecol.client.gui.action.MiniMapToggleViewAction;
import net.sf.freecol.client.gui.action.MiniMapZoomInAction;
import net.sf.freecol.client.gui.action.MiniMapZoomOutAction;
import net.sf.freecol.client.gui.action.MoveAction;
import net.sf.freecol.client.gui.action.NewAction;
import net.sf.freecol.client.gui.action.NewEmptyMapAction;
import net.sf.freecol.client.gui.action.OpenAction;
import net.sf.freecol.client.gui.action.PreferencesAction;
import net.sf.freecol.client.gui.action.QuitAction;
import net.sf.freecol.client.gui.action.ReconnectAction;
import net.sf.freecol.client.gui.action.RenameAction;
import net.sf.freecol.client.gui.action.ReportCargoAction;
import net.sf.freecol.client.gui.action.ReportColonyAction;
import net.sf.freecol.client.gui.action.ReportContinentalCongressAction;
import net.sf.freecol.client.gui.action.ReportEducationAction;
import net.sf.freecol.client.gui.action.ReportExplorationAction;
import net.sf.freecol.client.gui.action.ReportForeignAction;
import net.sf.freecol.client.gui.action.ReportHighScoresAction;
import net.sf.freecol.client.gui.action.ReportHistoryAction;
import net.sf.freecol.client.gui.action.ReportIndianAction;
import net.sf.freecol.client.gui.action.ReportLabourAction;
import net.sf.freecol.client.gui.action.ReportMilitaryAction;
import net.sf.freecol.client.gui.action.ReportNavalAction;
import net.sf.freecol.client.gui.action.ReportProductionAction;
import net.sf.freecol.client.gui.action.ReportReligionAction;
import net.sf.freecol.client.gui.action.ReportRequirementsAction;
import net.sf.freecol.client.gui.action.ReportTradeAction;
import net.sf.freecol.client.gui.action.ReportTurnAction;
import net.sf.freecol.client.gui.action.RetireAction;
import net.sf.freecol.client.gui.action.SaveAction;
import net.sf.freecol.client.gui.action.SaveAndQuitAction;
import net.sf.freecol.client.gui.action.ScaleMapAction;
import net.sf.freecol.client.gui.action.SentryAction;
import net.sf.freecol.client.gui.action.ShowDifficultyAction;
import net.sf.freecol.client.gui.action.ShowGameOptionsAction;
import net.sf.freecol.client.gui.action.ShowMainAction;
import net.sf.freecol.client.gui.action.ShowMapGeneratorOptionsAction;
import net.sf.freecol.client.gui.action.SkipUnitAction;
import net.sf.freecol.client.gui.action.TilePopupAction;
import net.sf.freecol.client.gui.action.ToggleViewModeAction;
import net.sf.freecol.client.gui.action.TradeRouteAction;
import net.sf.freecol.client.gui.action.UnloadAction;
import net.sf.freecol.client.gui.action.WaitAction;
import net.sf.freecol.client.gui.action.ZoomInAction;
import net.sf.freecol.client.gui.action.ZoomOutAction;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;

public class ActionManager
extends OptionGroup {
    private static final Logger logger = Logger.getLogger(ActionManager.class.getName());
    private final FreeColClient freeColClient;

    public ActionManager(FreeColClient freeColClient) {
        super("actionManager");
        this.freeColClient = freeColClient;
    }

    public void initializeActions(InGameController inGameController, ConnectController connectController) {
        this.add(new AboutAction(this.freeColClient));
        this.add(new AssignTradeRouteAction(this.freeColClient));
        this.add(new BuildColonyAction(this.freeColClient));
        this.add(new CenterAction(this.freeColClient));
        this.add(new ChangeAction(this.freeColClient));
        this.add(new ChangeWindowedModeAction(this.freeColClient));
        this.add(new ChatAction(this.freeColClient));
        this.add(new ClearOrdersAction(this.freeColClient));
        for (ColopediaAction.PanelType panelType : ColopediaAction.PanelType.values()) {
            this.add(new ColopediaAction(this.freeColClient, panelType));
        }
        this.add(new ContinueAction(this.freeColClient));
        this.add(new DebugAction(this.freeColClient));
        this.add(new DeclareIndependenceAction(this.freeColClient));
        this.add(new DetermineHighSeasAction(this.freeColClient));
        this.add(new DisbandUnitAction(this.freeColClient));
        this.add(new DisplayBordersAction(this.freeColClient));
        this.add(new DisplayGridAction(this.freeColClient));
        for (Enum enum_ : DisplayTileTextAction.DisplayText.values()) {
            this.add(new DisplayTileTextAction(this.freeColClient, (DisplayTileTextAction.DisplayText)enum_));
        }
        this.add(new EndTurnAction(this.freeColClient));
        this.add(new EuropeAction(this.freeColClient));
        this.add(new ExecuteGotoOrdersAction(this.freeColClient));
        this.add(new FindSettlementAction(this.freeColClient));
        this.add(new FortifyAction(this.freeColClient));
        this.add(new GotoAction(this.freeColClient));
        this.add(new GotoTileAction(this.freeColClient));
        this.add(new LoadAction(this.freeColClient));
        this.add(new MapControlsAction(this.freeColClient));
        this.add(new MapEditorAction(this.freeColClient));
        this.add(new MiniMapToggleViewAction(this.freeColClient));
        this.add(new MiniMapToggleViewAction(this.freeColClient, true));
        this.add(new MiniMapToggleFogOfWarAction(this.freeColClient));
        this.add(new MiniMapToggleFogOfWarAction(this.freeColClient, true));
        this.add(new MiniMapZoomInAction(this.freeColClient));
        this.add(new MiniMapZoomInAction(this.freeColClient, true));
        this.add(new MiniMapZoomOutAction(this.freeColClient));
        this.add(new MiniMapZoomOutAction(this.freeColClient, true));
        for (Enum enum_ : Map.Direction.values()) {
            this.add(new MoveAction(this.freeColClient, (Map.Direction)enum_));
            this.add(new MoveAction(this.freeColClient, (Map.Direction)enum_, true));
        }
        this.add(new NewAction(this.freeColClient));
        this.add(new NewEmptyMapAction(this.freeColClient));
        this.add(new OpenAction(this.freeColClient));
        this.add(new PreferencesAction(this.freeColClient));
        this.add(new SaveAndQuitAction(this.freeColClient));
        this.add(new QuitAction(this.freeColClient));
        this.add(new ReconnectAction(this.freeColClient));
        this.add(new RenameAction(this.freeColClient));
        this.add(new ReportCargoAction(this.freeColClient));
        this.add(new ReportContinentalCongressAction(this.freeColClient));
        this.add(new ReportColonyAction(this.freeColClient));
        this.add(new ReportEducationAction(this.freeColClient));
        this.add(new ReportExplorationAction(this.freeColClient));
        this.add(new ReportForeignAction(this.freeColClient));
        this.add(new ReportHighScoresAction(this.freeColClient));
        this.add(new ReportHistoryAction(this.freeColClient));
        this.add(new ReportIndianAction(this.freeColClient));
        this.add(new ReportLabourAction(this.freeColClient));
        this.add(new ReportMilitaryAction(this.freeColClient));
        this.add(new ReportNavalAction(this.freeColClient));
        this.add(new ReportProductionAction(this.freeColClient));
        this.add(new ReportReligionAction(this.freeColClient));
        this.add(new ReportRequirementsAction(this.freeColClient));
        this.add(new ReportTradeAction(this.freeColClient));
        this.add(new ReportTurnAction(this.freeColClient));
        this.add(new RetireAction(this.freeColClient));
        this.add(new SaveAction(this.freeColClient));
        this.add(new ScaleMapAction(this.freeColClient));
        this.add(new SentryAction(this.freeColClient));
        this.add(new ShowDifficultyAction(this.freeColClient));
        this.add(new ShowGameOptionsAction(this.freeColClient));
        this.add(new ShowMainAction(this.freeColClient));
        this.add(new ShowMapGeneratorOptionsAction(this.freeColClient));
        this.add(new SkipUnitAction(this.freeColClient));
        this.add(new TilePopupAction(this.freeColClient));
        this.add(new ToggleViewModeAction(this.freeColClient));
        this.add(new TradeRouteAction(this.freeColClient));
        this.add(new UnloadAction(this.freeColClient));
        this.add(new WaitAction(this.freeColClient));
        this.add(new ZoomInAction(this.freeColClient));
        this.add(new ZoomOutAction(this.freeColClient));
    }

    public void addSpecificationActions(Specification spec) {
        for (TileImprovementType type : spec.getTileImprovementTypeList()) {
            if (type.isNatural()) continue;
            this.add(new ImprovementAction(this.freeColClient, type));
        }
    }

    public FreeColAction getFreeColAction(String id) {
        return (FreeColAction)super.getOption(id);
    }

    public void update() {
        Iterator<Option> it = this.iterator();
        while (it.hasNext()) {
            ((FreeColAction)it.next()).update();
        }
    }
}

