/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.AbstractCanvasListener;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class CanvasMouseMotionListener
extends AbstractCanvasListener
implements MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseMotionListener.class.getName());
    private static final int DRAG_THRESHOLD = 16;
    private Tile lastTile;

    public CanvasMouseMotionListener(FreeColClient freeColClient) {
        super(freeColClient);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getY() >= 1) {
            this.performAutoScrollIfActive(e);
        }
        if (this.mapViewer.isGotoStarted()) {
            Tile tile;
            if (this.mapViewer.getActiveUnit() == null) {
                this.mapViewer.stopGoto();
            }
            if ((tile = this.mapViewer.convertToMapTile(e.getX(), e.getY())) != null && this.lastTile != tile) {
                Unit active = this.mapViewer.getActiveUnit();
                this.lastTile = tile;
                if (active != null && active.getTile() != tile) {
                    PathNode dragPath = active.findPath(tile);
                    this.mapViewer.setGotoPath(dragPath);
                } else {
                    this.mapViewer.setGotoPath(null);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.performDragScrollIfActive(e);
        Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
        if (tile != null && (e.getModifiers() & 0x10) == 16) {
            if (this.mapViewer.isGotoStarted()) {
                Unit active = this.mapViewer.getActiveUnit();
                if (active == null) {
                    this.mapViewer.stopGoto();
                } else if (this.lastTile != tile) {
                    this.lastTile = tile;
                    PathNode dragPath = active.findPath(tile);
                    this.mapViewer.setGotoPath(dragPath);
                }
            } else {
                int deltaX = Math.abs(e.getX() - this.mapViewer.getDragPoint().x);
                int deltaY = Math.abs(e.getY() - this.mapViewer.getDragPoint().y);
                if (deltaX >= 16 || deltaY >= 16) {
                    this.mapViewer.startGoto();
                }
            }
        }
    }
}

