/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class CanvasMouseListener
implements ActionListener,
MouseListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseListener.class.getName());
    private static final int doubleClickDelay = 200;
    private FreeColClient freeColClient;
    private final Canvas canvas;
    private final MapViewer mapViewer;
    private Timer doubleClickTimer = new Timer(200, this);
    private int centerX;
    private int centerY;

    public CanvasMouseListener(FreeColClient freeColClient, Canvas canvas, MapViewer mapViewer) {
        this.freeColClient = freeColClient;
        this.canvas = canvas;
        this.mapViewer = mapViewer;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            if (e.getClickCount() > 1) {
                Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
                Colony colony = tile.getColony();
                if (colony != null) {
                    if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
                        this.canvas.showForeignColony(colony);
                    } else {
                        this.canvas.showColonyPanel(colony, null);
                    }
                }
            } else {
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseClicked!", ex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        int me = e.getButton();
        if (e.isPopupTrigger()) {
            me = 3;
        }
        Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
        switch (me) {
            case 1: {
                this.mapViewer.setDragPoint(e.getX(), e.getY());
                if (this.mapViewer.isGotoStarted()) {
                    PathNode path = this.mapViewer.getGotoPath();
                    if (path != null) {
                        this.mapViewer.stopGoto();
                        this.freeColClient.getInGameController().goToTile(this.mapViewer.getActiveUnit(), path.getLastNode().getTile());
                    }
                } else if (this.doubleClickTimer.isRunning()) {
                    this.doubleClickTimer.stop();
                } else {
                    this.centerX = e.getX();
                    this.centerY = e.getY();
                    this.doubleClickTimer.start();
                }
                this.canvas.requestFocus();
                break;
            }
            case 2: {
                Unit unit;
                if (tile == null || (unit = this.mapViewer.getActiveUnit()) == null || unit.getTile() == tile) break;
                PathNode dragPath = unit.findPath(tile);
                this.mapViewer.startGoto();
                this.mapViewer.setGotoPath(dragPath);
                break;
            }
            case 3: {
                if (this.mapViewer.isGotoStarted()) {
                    this.mapViewer.stopGoto();
                }
                this.canvas.showTilePopup(tile, e.getX(), e.getY());
                break;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (this.mapViewer.getGotoPath() != null) {
                PathNode temp = this.mapViewer.getGotoPath();
                this.mapViewer.stopGoto();
                this.freeColClient.getInGameController().goToTile(this.mapViewer.getActiveUnit(), temp.getLastNode().getTile());
            } else if (this.mapViewer.isGotoStarted()) {
                this.mapViewer.stopGoto();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseReleased!", ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doubleClickTimer.stop();
        this.mapViewer.setSelectedTile(this.mapViewer.convertToMapTile(this.centerX, this.centerY), true);
    }
}

