/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.AbstractCanvasListener;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.server.generator.TerrainGenerator;

public final class CanvasMapEditorMouseListener
extends AbstractCanvasListener
implements MouseListener,
MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMapEditorMouseListener.class.getName());
    private final Canvas canvas;
    private Point endPoint;
    private Point startPoint;

    public CanvasMapEditorMouseListener(FreeColClient freeColClient, Canvas canvas) {
        super(freeColClient);
        this.canvas = canvas;
    }

    private GUI getGUI() {
        return this.freeColClient.getGUI();
    }

    private Map getMap() {
        return this.freeColClient.getGame() == null ? null : this.freeColClient.getGame().getMap();
    }

    private void drawBox(JComponent component, Point startPoint, Point endPoint) {
        MapEditorController controller;
        if (startPoint == null || endPoint == null || startPoint.distance(endPoint) == 0.0 || (controller = this.freeColClient.getMapEditorController()) == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)component.getGraphics();
        graphics.setColor(Color.WHITE);
        int x = Math.min(startPoint.x, endPoint.x);
        int y = Math.min(startPoint.y, endPoint.y);
        int width = Math.abs(startPoint.x - endPoint.x);
        int height = Math.abs(startPoint.y - endPoint.y);
        graphics.drawRect(x, y, width, height);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        try {
            if (e.getClickCount() > 1) {
                this.mapViewer.convertToMapTile(e.getX(), e.getY());
            } else {
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseClicked!", ex);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.getMap() == null || !e.getComponent().isEnabled()) {
            return;
        }
        try {
            if (e.getButton() == 1) {
                Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
                if (tile != null) {
                    this.getGUI().setSelectedTile(tile, false);
                }
                this.endPoint = null;
                this.startPoint = null;
            } else if (e.getButton() == 2) {
                this.startPoint = e.getPoint();
                JComponent component = (JComponent)e.getSource();
                this.drawBox(component, this.startPoint, this.endPoint);
            } else if (e.getButton() == 3 || e.isPopupTrigger()) {
                this.startPoint = e.getPoint();
                Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
                if (tile != null) {
                    if (tile.hasRiver()) {
                        TileImprovement river = tile.getRiver();
                        String style = this.canvas.showRiverStyleDialog(tile);
                        if (style != null) {
                            if ("DELETE".equals(style)) {
                                tile.getTileItemContainer().removeTileItem(river);
                            } else {
                                river.updateRiverConnections(style);
                            }
                        }
                    }
                    if (tile.getIndianSettlement() != null) {
                        this.canvas.showEditSettlementDialog(tile.getIndianSettlement());
                    }
                } else {
                    this.getGUI().setSelectedTile(null, false);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mousePressed!", ex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int y;
        int x;
        int max_y;
        int min_y;
        int max_x;
        int min_x;
        Tile end;
        if (this.getMap() == null || e.getButton() == 1 || this.getGUI().getFocus() == null) {
            return;
        }
        JComponent component = (JComponent)e.getSource();
        MapEditorController controller = this.freeColClient.getMapEditorController();
        boolean isTransformActive = controller.getMapTransform() != null;
        this.endPoint = e.getPoint();
        if (this.startPoint == null) {
            this.startPoint = this.endPoint;
        }
        this.drawBox(component, this.startPoint, this.endPoint);
        Tile start = this.mapViewer.convertToMapTile(this.startPoint.x, this.startPoint.y);
        Tile tile = end = this.startPoint == this.endPoint ? start : this.mapViewer.convertToMapTile(this.endPoint.x, this.endPoint.y);
        if (!isTransformActive && end.getX() >= 0 && end.getY() >= 0) {
            this.getGUI().setFocus(end);
            return;
        }
        if (start.getX() < end.getX()) {
            min_x = start.getX();
            max_x = end.getX();
        } else {
            min_x = end.getX();
            max_x = start.getX();
        }
        if (start.getY() < end.getY()) {
            min_y = start.getY();
            max_y = end.getY();
        } else {
            min_y = end.getY();
            max_y = start.getY();
        }
        Tile t = null;
        for (x = min_x; x <= max_x; ++x) {
            for (y = min_y; y <= max_y; ++y) {
                t = this.getMap().getTile(x, y);
                if (t == null) continue;
                controller.transform(t);
            }
        }
        if (controller.getMapTransform() instanceof MapEditorTransformPanel.TileTypeTransform) {
            for (x = min_x - 2; x <= max_x + 2; ++x) {
                for (y = min_y - 2; y <= max_y + 2; ++y) {
                    t = this.getMap().getTile(x, y);
                    if (t == null || !t.getType().isWater()) continue;
                    TerrainGenerator.encodeStyle(t);
                }
            }
        }
        this.getGUI().refresh();
        this.canvas.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        JComponent component = (JComponent)e.getSource();
        this.drawBox(component, this.startPoint, this.endPoint);
        this.endPoint = e.getPoint();
        this.drawBox(component, this.startPoint, this.endPoint);
        this.performDragScrollIfActive(e);
        this.getGUI().refresh();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getMap() == null || e.getY() < 1) {
            return;
        }
        this.performAutoScrollIfActive(e);
    }
}

