/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.CanvasMouseListener;
import net.sf.freecol.client.gui.CanvasMouseMotionListener;
import net.sf.freecol.client.gui.FrameMotionListener;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.TilePopup;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.panel.AboutPanel;
import net.sf.freecol.client.gui.panel.BuildQueuePanel;
import net.sf.freecol.client.gui.panel.CaptureGoodsDialog;
import net.sf.freecol.client.gui.panel.ChatPanel;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ChooseFoundingFatherDialog;
import net.sf.freecol.client.gui.panel.ClientOptionsDialog;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColorChooserPanel;
import net.sf.freecol.client.gui.panel.CompactLabourReport;
import net.sf.freecol.client.gui.panel.ConfirmDeclarationDialog;
import net.sf.freecol.client.gui.panel.DeclarationPanel;
import net.sf.freecol.client.gui.panel.DialogHandler;
import net.sf.freecol.client.gui.panel.DifficultyDialog;
import net.sf.freecol.client.gui.panel.DiplomaticTradeDialog;
import net.sf.freecol.client.gui.panel.DumpCargoDialog;
import net.sf.freecol.client.gui.panel.EditOptionDialog;
import net.sf.freecol.client.gui.panel.EditSettlementDialog;
import net.sf.freecol.client.gui.panel.EmigrationDialog;
import net.sf.freecol.client.gui.panel.EndTurnDialog;
import net.sf.freecol.client.gui.panel.ErrorPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.EventPanel;
import net.sf.freecol.client.gui.panel.FindSettlementPanel;
import net.sf.freecol.client.gui.panel.FirstContactDialog;
import net.sf.freecol.client.gui.panel.FreeColChoiceDialog;
import net.sf.freecol.client.gui.panel.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.FreeColStringInputDialog;
import net.sf.freecol.client.gui.panel.GameOptionsDialog;
import net.sf.freecol.client.gui.panel.IndianSettlementPanel;
import net.sf.freecol.client.gui.panel.InformationPanel;
import net.sf.freecol.client.gui.panel.LabourData;
import net.sf.freecol.client.gui.panel.LoadDialog;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.client.gui.panel.MainPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MapGeneratorOptionsDialog;
import net.sf.freecol.client.gui.panel.MapSizeDialog;
import net.sf.freecol.client.gui.panel.MonarchDialog;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.client.gui.panel.Parameters;
import net.sf.freecol.client.gui.panel.ParametersDialog;
import net.sf.freecol.client.gui.panel.PreCombatDialog;
import net.sf.freecol.client.gui.panel.PurchasePanel;
import net.sf.freecol.client.gui.panel.RecruitPanel;
import net.sf.freecol.client.gui.panel.ReportCargoPanel;
import net.sf.freecol.client.gui.panel.ReportColonyPanel;
import net.sf.freecol.client.gui.panel.ReportContinentalCongressPanel;
import net.sf.freecol.client.gui.panel.ReportEducationPanel;
import net.sf.freecol.client.gui.panel.ReportExplorationPanel;
import net.sf.freecol.client.gui.panel.ReportForeignAffairPanel;
import net.sf.freecol.client.gui.panel.ReportHighScoresPanel;
import net.sf.freecol.client.gui.panel.ReportHistoryPanel;
import net.sf.freecol.client.gui.panel.ReportIndianPanel;
import net.sf.freecol.client.gui.panel.ReportLabourDetailPanel;
import net.sf.freecol.client.gui.panel.ReportLabourPanel;
import net.sf.freecol.client.gui.panel.ReportMilitaryPanel;
import net.sf.freecol.client.gui.panel.ReportNavalPanel;
import net.sf.freecol.client.gui.panel.ReportProductionPanel;
import net.sf.freecol.client.gui.panel.ReportReligiousPanel;
import net.sf.freecol.client.gui.panel.ReportRequirementsPanel;
import net.sf.freecol.client.gui.panel.ReportTradePanel;
import net.sf.freecol.client.gui.panel.ReportTurnPanel;
import net.sf.freecol.client.gui.panel.RiverStyleDialog;
import net.sf.freecol.client.gui.panel.SaveDialog;
import net.sf.freecol.client.gui.panel.ScaleMapSizeDialog;
import net.sf.freecol.client.gui.panel.SelectAmountDialog;
import net.sf.freecol.client.gui.panel.SelectDestinationDialog;
import net.sf.freecol.client.gui.panel.SelectTributeAmountDialog;
import net.sf.freecol.client.gui.panel.ServerListPanel;
import net.sf.freecol.client.gui.panel.StartGamePanel;
import net.sf.freecol.client.gui.panel.StatisticsPanel;
import net.sf.freecol.client.gui.panel.StatusPanel;
import net.sf.freecol.client.gui.panel.TilePanel;
import net.sf.freecol.client.gui.panel.TradeRouteInputPanel;
import net.sf.freecol.client.gui.panel.TradeRoutePanel;
import net.sf.freecol.client.gui.panel.TrainPanel;
import net.sf.freecol.client.gui.panel.VictoryDialog;
import net.sf.freecol.client.gui.panel.WarehouseDialog;
import net.sf.freecol.client.gui.panel.WorkProductionPanel;
import net.sf.freecol.client.gui.video.VideoComponent;
import net.sf.freecol.client.gui.video.VideoListener;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColFileFilter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.Video;

public final class Canvas
extends JDesktopPane {
    private static final Logger logger = Logger.getLogger(Canvas.class.getName());
    private static final int MAXTRY = 3;
    private final FreeColClient freeColClient;
    private GUI gui;
    private MainPanel mainPanel;
    private final StartGamePanel startGamePanel;
    private final StatusPanel statusPanel;
    private final ChatPanel chatPanel;
    private final MapViewer mapViewer;
    private final ServerListPanel serverListPanel;
    private Dimension oldSize = null;
    private Dimension initialSize = null;
    private boolean clientOptionsDialogShowing = false;
    private LoadingSavegameDialog loadingSavegameDialog;
    private FileFilter[] fileFilters = null;
    private final List<FreeColDialog<?>> dialogs = new ArrayList();

    public Canvas(FreeColClient freeColClient, Dimension size, MapViewer mapViewer) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
        this.mapViewer = mapViewer;
        this.initialSize = size;
        this.setLocation(0, 0);
        this.setSize(size);
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setLayout(null);
        this.startGamePanel = new StartGamePanel(freeColClient);
        this.serverListPanel = new ServerListPanel(freeColClient, freeColClient.getConnectController());
        this.statusPanel = new StatusPanel(freeColClient);
        this.chatPanel = new ChatPanel(freeColClient);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.createKeyBindings();
        logger.info("Canvas created.");
    }

    private JInternalFrame addAsFrame(JComponent comp, boolean toolBox, PopupPosition popupPosition, boolean resizable) {
        JInternalFrame f;
        int FRAME_EMPTY_SPACE = 60;
        JInternalFrame jInternalFrame = f = toolBox ? new ToolBoxFrame() : new JInternalFrame();
        if (f.getContentPane() instanceof JComponent) {
            JComponent c = (JComponent)f.getContentPane();
            c.setOpaque(false);
            c.setBorder(null);
        }
        if (comp.getBorder() != null) {
            if (comp.getBorder() instanceof EmptyBorder) {
                f.setBorder(GUI.blankBorder(10, 10, 10, 10));
            } else {
                f.setBorder(comp.getBorder());
                comp.setBorder(GUI.blankBorder(5, 5, 5, 5));
            }
        } else {
            f.setBorder(null);
        }
        FrameMotionListener fml = new FrameMotionListener(f);
        comp.addMouseMotionListener(fml);
        comp.addMouseListener(fml);
        if (f.getUI() instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI biu = (BasicInternalFrameUI)f.getUI();
            biu.setNorthPane(null);
            biu.setSouthPane(null);
            biu.setWestPane(null);
            biu.setEastPane(null);
        }
        f.getContentPane().add(comp);
        f.setOpaque(false);
        f.pack();
        int width = f.getWidth();
        int height = f.getHeight();
        if (width > this.getWidth() - 60) {
            width = Math.min(width, this.getWidth());
        }
        if (height > this.getHeight() - 60) {
            height = Math.min(height, this.getHeight());
        }
        f.setSize(width, height);
        Point p = this.chooseLocation(comp, width, height, popupPosition);
        f.setLocation(p);
        this.add((Component)f, MODAL_LAYER);
        f.setName(comp.getClass().getSimpleName());
        f.setFrameIcon(null);
        f.setVisible(true);
        f.setResizable(resizable);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return f;
    }

    private void addCentered(Component comp, Integer i) {
        comp.setLocation((this.getWidth() - comp.getWidth()) / 2, (this.getHeight() - comp.getHeight()) / 2);
        this.add(comp, i);
    }

    private void addToCanvas(Component comp, Integer i) {
        if (comp != this.statusPanel && !(comp instanceof JMenuItem) && this.statusPanel.isVisible()) {
            this.removeFromCanvas(this.statusPanel);
        }
        try {
            super.add(comp, i == null ? JLayeredPane.DEFAULT_LAYER : i);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "addToCanvas(" + comp + ", " + i + ") failed.", e);
        }
    }

    private Point chooseLocation(Component comp, int width, int height, PopupPosition popupPosition) {
        Point p = null;
        if ((comp instanceof FreeColPanel || comp instanceof FreeColDialog) && (p = this.getSavedPosition(comp)) != null && (p.getX() < 0.0 || p.getX() >= (double)(this.getWidth() - width) || p.getY() < 0.0 || p.getY() >= (double)(this.getHeight() - height))) {
            p = null;
        }
        int x = 0;
        int y = 0;
        if (p != null) {
            x = (int)p.getX();
            y = (int)p.getY();
        } else if (popupPosition != null) {
            switch (popupPosition) {
                case CENTERED: {
                    x = (this.getWidth() - width) / 2;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case CENTERED_LEFT: {
                    x = (this.getWidth() - width) / 4;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case CENTERED_RIGHT: {
                    x = (this.getWidth() - width) * 3 / 4;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case ORIGIN: {
                    y = 0;
                    x = 0;
                }
            }
        }
        p = this.getClearSpace(x, y, width, height, 3);
        if (p != null && p.x >= 0 && p.x < this.getWidth() && p.y >= 0 && p.y < this.getHeight()) {
            x = p.x;
            y = p.y;
        }
        return new Point(x, y);
    }

    private void createKeyBindings() {
        for (Option option : this.freeColClient.getActionManager().getOptions()) {
            FreeColAction action = (FreeColAction)option;
            this.getInputMap().put(action.getAccelerator(), action.getId());
            this.getActionMap().put(action.getId(), action);
        }
    }

    private Point getClearSpace(int x, int y, int w, int h, int tries) {
        Rectangle bounds = this.getBounds();
        if (!bounds.contains(x, y)) {
            return null;
        }
        tries = 3 * tries + 1;
        ArrayList<Point> todo = new ArrayList<Point>();
        Point p = new Point(x, y);
        todo.add(p);
        while (!todo.isEmpty()) {
            p = (Point)todo.remove(0);
            Rectangle r = new Rectangle(p.x, p.y, w, h);
            if (!bounds.contains(r)) continue;
            FreeColDialog<?> c = null;
            for (FreeColDialog<?> freeColDialog : this.getComponents()) {
                if (!freeColDialog.getBounds().intersects(r)) continue;
                c = freeColDialog;
                break;
            }
            if (c == null) {
                for (FreeColDialog<?> fcd : this.dialogs) {
                    if (!fcd.getBounds().intersects(r)) continue;
                    c = fcd;
                    break;
                }
            }
            if (c == null) {
                return p;
            }
            if (--tries <= 0) break;
            int n = todo.size();
            todo.add(n, new Point(c.getX() + c.getWidth() + 1, c.getY() + c.getHeight() + 1));
            todo.add(n, new Point(x, c.getY() + c.getHeight() + 1));
            todo.add(n, new Point(c.getX() + c.getWidth() + 1, y));
        }
        return new Point(x, y);
    }

    private ColonyPanel getColonyPanel(Colony colony) {
        for (Component c1 : this.getComponents()) {
            if (!(c1 instanceof JInternalFrame)) continue;
            for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                if (!(c2 instanceof ColonyPanel) || ((ColonyPanel)c2).getColony() != colony) continue;
                return (ColonyPanel)c2;
            }
        }
        return null;
    }

    private JInternalFrame getInternalFrame(Component c) {
        Component temp;
        for (temp = c; temp != null && !(temp instanceof JInternalFrame); temp = temp.getParent()) {
        }
        return (JInternalFrame)temp;
    }

    private PopupPosition getPopupPosition(Tile tile) {
        if (tile == null) {
            return PopupPosition.CENTERED;
        }
        int where = this.mapViewer.setOffsetFocus(tile);
        return where > 0 ? PopupPosition.CENTERED_LEFT : (where < 0 ? PopupPosition.CENTERED_RIGHT : PopupPosition.CENTERED);
    }

    private Point getSavedPosition(Component comp) {
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co == null) {
            return null;
        }
        try {
            if (!co.getBoolean("model.option.rememberPanelPositions")) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        try {
            return new Point(co.getInteger(className + ".x"), co.getInteger(className + ".y"));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Dimension getSavedSize(Component comp) {
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co == null) {
            return null;
        }
        try {
            if (!co.getBoolean("model.option.rememberPanelSizes")) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        try {
            return new Dimension(co.getInteger(className + ".w"), co.getInteger(className + ".h"));
        }
        catch (Exception e) {
            return null;
        }
    }

    private void notifyClose(Component c, JInternalFrame frame) {
        if (frame == null) {
            return;
        }
        if (c instanceof FreeColPanel) {
            FreeColPanel fcp = (FreeColPanel)c;
            fcp.firePropertyChange("closing", false, true);
            this.savePosition(fcp, frame.getLocation());
            this.saveSize(fcp, fcp.getSize());
        }
    }

    private void removeEuropeanSubpanels() {
        FreeColPanel panel = this.getExistingFreeColPanel(RecruitPanel.class);
        if (panel != null) {
            this.removeFromCanvas(panel);
        }
        if ((panel = this.getExistingFreeColPanel(PurchasePanel.class)) != null) {
            this.removeFromCanvas(panel);
        }
        if ((panel = this.getExistingFreeColPanel(TrainPanel.class)) != null) {
            this.removeFromCanvas(panel);
        }
    }

    private void saveInteger(String className, String key, int value) {
        if (this.freeColClient != null && this.freeColClient.getClientOptions() != null) {
            Option o = this.freeColClient.getClientOptions().getOption(className + key);
            if (o == null) {
                Specification specification = this.freeColClient.getGame() == null ? null : this.freeColClient.getGame().getSpecification();
                IntegerOption io = new IntegerOption(className + key, specification);
                io.setValue(value);
                this.freeColClient.getClientOptions().add(io);
            } else if (o instanceof IntegerOption) {
                ((IntegerOption)o).setValue(value);
            }
        }
    }

    private void savePosition(Component comp, Point position) {
        try {
            if (!this.freeColClient.getClientOptions().getBoolean("model.option.rememberPanelPositions")) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        this.saveInteger(className, ".x", position.x);
        this.saveInteger(className, ".y", position.y);
    }

    private void saveSize(Component comp, Dimension size) {
        try {
            if (!this.freeColClient.getClientOptions().getBoolean("model.option.rememberPanelSizes")) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        this.saveInteger(className, ".w", size.width);
        this.saveInteger(className, ".h", size.height);
    }

    private void setBlinking(boolean on) {
        if (on) {
            for (FreeColDialog<?> f : this.dialogs) {
                if (!f.isModal()) continue;
                return;
            }
            this.mapViewer.restartBlinking();
        } else {
            if (this.gui.getViewMode() != 0) {
                return;
            }
            this.mapViewer.stopBlinking();
        }
    }

    private <T> T showFreeColDialog(FreeColDialog<T> freeColDialog, Tile tile) {
        this.viewFreeColDialog(freeColDialog, tile);
        T response = freeColDialog.getResponse();
        this.remove(freeColDialog);
        this.dialogRemove(freeColDialog);
        if (freeColDialog.isModal()) {
            this.setBlinking(true);
        }
        return response;
    }

    private void showFreeColPanel(FreeColPanel panel, Tile tile, boolean resizable) {
        this.showSubPanel(panel, this.getPopupPosition(tile), resizable);
    }

    private void showSubPanel(FreeColPanel panel, boolean resizable) {
        this.showSubPanel(panel, PopupPosition.CENTERED, resizable);
    }

    private void showSubPanel(FreeColPanel panel, PopupPosition popupPosition, boolean resizable) {
        this.repaint();
        this.addAsFrame(panel, false, popupPosition, resizable);
        panel.requestFocus();
    }

    @Override
    public Component add(Component comp) {
        this.add(comp, JLayeredPane.DEFAULT_LAYER);
        return comp;
    }

    public void add(Component comp, Integer i) {
        this.addToCanvas(comp, i);
        this.gui.updateMenuBar();
        this.freeColClient.updateActions();
    }

    public void closeMenus() {
        for (JInternalFrame frame : this.getAllFrames()) {
            for (Component c : frame.getContentPane().getComponents()) {
                this.notifyClose(c, frame);
            }
            frame.dispose();
        }
        while (!this.dialogs.isEmpty()) {
            FreeColDialog<?> dialog = this.dialogs.remove(0);
            dialog.dispose();
        }
    }

    public void closeMainPanel() {
        if (this.mainPanel != null) {
            this.remove(this.mainPanel);
            this.mainPanel = null;
        }
    }

    public void closeStatusPanel() {
        if (this.statusPanel.isVisible()) {
            this.remove(this.statusPanel);
        }
    }

    public boolean containsInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        if (keyListeners.length > 0) {
            return true;
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        if (mouseListeners.length > 0) {
            return true;
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        return mouseMotionListeners.length > 0;
    }

    public void dialogAdd(FreeColDialog<?> fcd) {
        this.dialogs.add(fcd);
    }

    public void dialogRemove(FreeColDialog<?> fcd) {
        this.dialogs.remove(fcd);
    }

    public <T extends FreeColPanel> T getExistingFreeColPanel(Class<T> type) {
        for (Component c1 : this.getComponents()) {
            if (!(c1 instanceof JInternalFrame)) continue;
            for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                try {
                    FreeColPanel ret = (FreeColPanel)type.cast(c2);
                    if (ret == null) continue;
                    final JInternalFrame jif = (JInternalFrame)c1;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jif.toFront();
                            jif.repaint();
                        }
                    });
                    return (T)ret;
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public LoadingSavegameDialog getLoadingSavegameDialog() {
        return this.loadingSavegameDialog;
    }

    public Component getShowingSubPanel() {
        for (Component c : this.getComponents()) {
            if (c instanceof ToolBoxFrame) continue;
            if (c instanceof JInternalFrame) {
                return c;
            }
            if (!(c instanceof JInternalFrame.JDesktopIcon)) continue;
            return c;
        }
        return null;
    }

    public boolean isClientOptionsDialogShowing() {
        return this.clientOptionsDialogShowing;
    }

    public boolean isMapboardActionsEnabled() {
        return !this.isShowingSubPanel();
    }

    public boolean isShowingSubPanel() {
        return this.getShowingSubPanel() != null;
    }

    public void refresh() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void removeFromCanvas(Component comp) {
        if (comp == null) {
            return;
        }
        Rectangle updateBounds = comp.getBounds();
        JInternalFrame frame = this.getInternalFrame(comp);
        this.notifyClose(comp, frame);
        if (frame != null && frame != comp) {
            frame.dispose();
        } else {
            try {
                super.remove(comp);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Java crash", e);
            }
        }
        this.repaint(updateBounds.x, updateBounds.y, updateBounds.width, updateBounds.height);
    }

    public void removeInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        for (int i = 0; i < keyListeners.length; ++i) {
            this.removeKeyListener(keyListeners[i]);
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        for (int i = 0; i < mouseListeners.length; ++i) {
            this.removeMouseListener(mouseListeners[i]);
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListeners.length; ++i) {
            this.removeMouseMotionListener(mouseMotionListeners[i]);
        }
        for (Component c : this.getComponents()) {
            this.removeFromCanvas(c);
        }
    }

    public void restoreSavedSize(Component comp, Dimension d) {
        Dimension size = this.getSavedSize(comp);
        if (size == null) {
            size = d;
            this.saveSize(comp, size);
        }
        if (!comp.getPreferredSize().equals(size)) {
            comp.setPreferredSize(size);
        }
    }

    public void returnToTitle() {
        this.closeMenus();
        this.removeInGameComponents();
        this.showMainPanel(null);
        this.gui.playSound("sound.intro.general");
        this.repaint();
    }

    public void setupMouseListeners(MapViewer mapViewer) {
        this.addMouseListener(new CanvasMouseListener(this.freeColClient, this, mapViewer));
        this.addMouseMotionListener(new CanvasMouseMotionListener(this.freeColClient));
    }

    public void updateSizes() {
        if (this.oldSize == null) {
            this.oldSize = this.getSize();
        }
        if (this.oldSize.width != this.getWidth() || this.oldSize.height != this.getHeight()) {
            this.gui.updateMapControlsInCanvas();
            this.mapViewer.setSize(this.getSize());
            this.mapViewer.forceReposition();
            this.oldSize = this.getSize();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.updateSizes();
        Graphics2D g2d = (Graphics2D)g;
        this.mapViewer.display(g2d);
    }

    @Override
    public void remove(Component comp) {
        this.removeFromCanvas(comp);
        boolean takeFocus = comp != this.statusPanel;
        this.gui.updateMenuBar();
        this.freeColClient.updateActions();
        if (takeFocus && !this.isShowingSubPanel()) {
            this.requestFocus();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(640, 480);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.initialSize;
    }

    public void displayChat(String sender, String message, boolean privateChat) {
        this.startGamePanel.displayChat(sender, message, privateChat);
    }

    public void refreshPlayersTable() {
        this.startGamePanel.refreshPlayersTable();
    }

    public void updateGameOptions() {
        this.startGamePanel.updateGameOptions();
    }

    public void updateMapGeneratorOptions() {
        this.startGamePanel.updateMapGeneratorOptions();
    }

    public <T> T showChoiceDialog(boolean modal, Tile tile, Object obj, ImageIcon icon, String cancelKey, List<ChoiceItem<T>> choices) {
        FreeColChoiceDialog<T> fcd = new FreeColChoiceDialog<T>(this.freeColClient, modal, obj, icon, cancelKey, choices);
        return this.showFreeColDialog(fcd, tile);
    }

    public boolean showConfirmDialog(boolean modal, Tile tile, Object obj, ImageIcon icon, String okKey, String cancelKey) {
        FreeColConfirmDialog fcd = new FreeColConfirmDialog(this.freeColClient, modal, obj, icon, okKey, cancelKey);
        return this.showFreeColDialog(fcd, tile);
    }

    public String showInputDialog(boolean modal, Tile tile, StringTemplate template, String defaultValue, String okKey, String cancelKey) {
        FreeColStringInputDialog fcd = new FreeColStringInputDialog(this.freeColClient, modal, Messages.message(template), defaultValue, okKey, cancelKey);
        return this.showFreeColDialog(fcd, tile);
    }

    public <T> void viewFreeColDialog(FreeColDialog<T> freeColDialog, Tile tile) {
        freeColDialog.setLocation(this.chooseLocation(freeColDialog, freeColDialog.getWidth(), freeColDialog.getHeight(), this.getPopupPosition(tile)));
        this.dialogAdd(freeColDialog);
        if (freeColDialog.isModal()) {
            this.setBlinking(false);
        }
        freeColDialog.requestFocus();
        freeColDialog.setVisible(true);
    }

    public void removeTradeRoutePanel(TradeRoutePanel panel) {
        this.remove(panel);
        TradeRouteInputPanel trip = this.getExistingFreeColPanel(TradeRouteInputPanel.class);
        if (trip != null) {
            trip.cancelTradeRoute();
        }
    }

    public void showAboutPanel() {
        this.showSubPanel(new AboutPanel(this.freeColClient), false);
    }

    public void showBuildQueuePanel(Colony colony) {
        BuildQueuePanel panel = this.getExistingFreeColPanel(BuildQueuePanel.class);
        if (panel == null || panel.getColony() != colony) {
            this.showSubPanel(new BuildQueuePanel(this.freeColClient, colony), true);
        }
    }

    public void showBuildQueuePanel(Colony colony, Runnable callBack) {
        BuildQueuePanel panel = new BuildQueuePanel(this.freeColClient, colony);
        panel.addClosingCallback(callBack);
        this.showSubPanel(panel, true);
    }

    public void showCaptureGoodsDialog(Unit unit, List<Goods> gl, DialogHandler<List<Goods>> handler) {
        SwingUtilities.invokeLater(new DialogCallback<List<Goods>>(new CaptureGoodsDialog(this.freeColClient, unit, gl), null, handler));
    }

    public void showChatPanel() {
        if (this.freeColClient.isSinglePlayer()) {
            return;
        }
        this.showSubPanel(this.chatPanel, true);
    }

    public void showChooseFoundingFatherDialog(List<FoundingFather> ffs, DialogHandler<FoundingFather> handler) {
        SwingUtilities.invokeLater(new DialogCallback<FoundingFather>(new ChooseFoundingFatherDialog(this.freeColClient, ffs), null, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionGroup showClientOptionsDialog() {
        ClientOptionsDialog dialog = new ClientOptionsDialog(this.freeColClient);
        OptionGroup group = null;
        this.clientOptionsDialogShowing = true;
        try {
            group = this.showFreeColDialog(dialog, null);
        }
        finally {
            this.clientOptionsDialogShowing = false;
            if (group != null) {
                this.freeColClient.updateActions();
                this.gui.resetMenuBar();
                this.gui.updateMapControls();
            }
        }
        return group;
    }

    public ColonyPanel showColonyPanel(Colony colony, Unit unit) {
        ColonyPanel panel = this.getColonyPanel(colony);
        if (panel == null) {
            panel = new ColonyPanel(this.freeColClient, colony);
            this.showFreeColPanel(panel, colony.getTile(), true);
        } else {
            panel.requestFocus();
        }
        if (panel != null && unit != null) {
            panel.setSelectedUnit(unit);
        }
        return panel;
    }

    public void showColopediaPanel(String nodeId) {
        this.showSubPanel(new ColopediaPanel(this.freeColClient, nodeId), false);
    }

    public ColorChooserPanel showColorChooserPanel(ActionListener al) {
        ColorChooserPanel ccp = new ColorChooserPanel(this.freeColClient, al);
        this.showFreeColPanel(ccp, null, false);
        return ccp;
    }

    public void showCompactLabourReport() {
        CompactLabourReport details = new CompactLabourReport(this.freeColClient);
        details.initialize();
        this.showSubPanel(details, false);
    }

    public void showCompactLabourReport(LabourData.UnitData unitData) {
        CompactLabourReport details = new CompactLabourReport(this.freeColClient, unitData);
        details.initialize();
        this.showSubPanel(details, false);
    }

    public List<String> showConfirmDeclarationDialog() {
        return this.showFreeColDialog(new ConfirmDeclarationDialog(this.freeColClient), null);
    }

    public void showDeclarationPanel() {
        this.showSubPanel(new DeclarationPanel(this.freeColClient), PopupPosition.CENTERED, false);
    }

    public OptionGroup showDifficultyDialog() {
        Game game = this.freeColClient.getGame();
        Specification spec = game.getSpecification();
        return this.showFreeColDialog(new DifficultyDialog(this.freeColClient, spec, spec.getDifficultyOptionGroup(), false), null);
    }

    public OptionGroup showDifficultyDialog(Specification spec, OptionGroup group) {
        return this.showFreeColDialog(new DifficultyDialog(this.freeColClient, spec, group, group.isEditable()), null);
    }

    public void showDumpCargoDialog(Unit unit, DialogHandler<List<Goods>> handler) {
        SwingUtilities.invokeLater(new DialogCallback<List<Goods>>(new DumpCargoDialog(this.freeColClient, unit), unit.getTile(), handler));
    }

    public boolean showEditOptionDialog(Option option) {
        return this.showFreeColDialog(new EditOptionDialog(this.freeColClient, option), null);
    }

    public void showEditSettlementDialog(IndianSettlement settlement) {
        this.showFreeColDialog(new EditSettlementDialog(this.freeColClient, settlement), null);
    }

    public void showEmigrationDialog(Player player, boolean fountainOfYouth, DialogHandler<Integer> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Integer>(new EmigrationDialog(this.freeColClient, player.getEurope(), fountainOfYouth), null, handler));
    }

    public void showEndTurnDialog(List<Unit> units, DialogHandler<Boolean> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Boolean>(new EndTurnDialog(this.freeColClient, units), null, handler));
    }

    public void showErrorMessage(String messageId) {
        this.showErrorMessage(messageId, "Unspecified error: " + messageId);
    }

    public void showErrorMessage(String messageId, String message) {
        String display = null;
        if (messageId != null) {
            display = Messages.message(messageId);
        }
        if (display == null || "".equals(display)) {
            display = message;
        }
        ErrorPanel errorPanel = new ErrorPanel(this.freeColClient, display);
        this.showSubPanel(errorPanel, true);
    }

    public void showEuropePanel() {
        if (this.freeColClient.getGame() == null) {
            this.showErrorMessage("europe.noGame");
        } else {
            EuropePanel panel = this.getExistingFreeColPanel(EuropePanel.class);
            if (panel == null) {
                panel = new EuropePanel(this.freeColClient, this);
                panel.addClosingCallback(new Runnable(){

                    @Override
                    public void run() {
                        Canvas.this.removeEuropeanSubpanels();
                    }
                });
                this.showSubPanel(panel, false);
            }
        }
    }

    public void showEventPanel(String header, String image, String footer) {
        this.showSubPanel(new EventPanel(this.freeColClient, header, image, footer), PopupPosition.CENTERED, false);
    }

    public void showFindSettlementPanel() {
        this.showSubPanel(new FindSettlementPanel(this.freeColClient), PopupPosition.ORIGIN, true);
    }

    public void showFirstContactDialog(Player player, Player other, Tile tile, int settlementCount, DialogHandler<Boolean> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Boolean>(new FirstContactDialog(this.freeColClient, player, other, tile, settlementCount), tile, handler));
    }

    public void showForeignColony(Settlement settlement) {
        if (settlement instanceof Colony) {
            Colony colony = this.freeColClient.getFreeColServer().getGame().getFreeColGameObject(settlement.getId(), Colony.class);
            this.showColonyPanel(colony, null);
        }
    }

    public OptionGroup showGameOptionsDialog(boolean editable, boolean custom) {
        GameOptionsDialog god = new GameOptionsDialog(this.freeColClient, editable, custom);
        return this.showFreeColDialog(god, null);
    }

    public void showHighScoresPanel(String messageId, List<HighScore> scores) {
        this.showSubPanel(new ReportHighScoresPanel(this.freeColClient, messageId, scores), PopupPosition.ORIGIN, false);
    }

    public void showIndianSettlementPanel(IndianSettlement indianSettlement) {
        IndianSettlementPanel panel = new IndianSettlementPanel(this.freeColClient, indianSettlement);
        this.showFreeColPanel(panel, indianSettlement.getTile(), true);
    }

    public void showInformationMessage(FreeColObject displayObject, String messageId) {
        this.showInformationMessage(displayObject, StringTemplate.key(messageId));
    }

    public void showInformationMessage(FreeColObject displayObject, StringTemplate template) {
        Tile tile;
        String text = Messages.message(template);
        ImageIcon icon = displayObject == null ? null : this.gui.getImageIcon(displayObject, false);
        Tile tile2 = tile = displayObject instanceof Location ? ((Location)((Object)displayObject)).getTile() : null;
        if (this.freeColClient.getClientOptions().getBoolean("model.option.audioAlerts")) {
            this.gui.playSound("sound.event.alertSound");
        }
        this.showFreeColPanel(new InformationPanel(this.freeColClient, text, displayObject, icon), tile, true);
    }

    public void showInformationMessage(ModelMessage message) {
        this.showInformationMessage(this.freeColClient.getGame().getMessageDisplay(message), message);
    }

    public void showInformationMessage(String messageId) {
        this.showInformationMessage(null, StringTemplate.key(messageId));
    }

    public void showInformationMessage(StringTemplate template) {
        this.showInformationMessage(null, template);
    }

    public File showLoadDialog(File directory) {
        if (this.fileFilters == null) {
            this.fileFilters = new FileFilter[]{FreeColFileFilter.freeColSaveDirectoryFilter};
        }
        return this.showFreeColDialog(new LoadDialog(this.freeColClient, directory, this.fileFilters), null);
    }

    public File showLoadDialog(File directory, FileFilter[] fileFilters) {
        File response = null;
        while ((response = this.showFreeColDialog(new LoadDialog(this.freeColClient, directory, fileFilters), null)) != null && !response.isFile()) {
            this.showErrorMessage("noSuchFile");
        }
        return response;
    }

    public boolean showLoadingSavegameDialog(boolean publicServer, boolean singlePlayer) {
        this.loadingSavegameDialog = new LoadingSavegameDialog(this.freeColClient);
        return this.showFreeColDialog(this.loadingSavegameDialog, null);
    }

    public void showLogFilePanel() {
        this.showSubPanel(new ErrorPanel(this.freeColClient), true);
    }

    public void showMainPanel(String userMsg) {
        this.closeMenus();
        this.gui.getFrame().setJMenuBar(null);
        this.mainPanel = new MainPanel(this.freeColClient);
        this.addCentered(this.mainPanel, JLayeredPane.DEFAULT_LAYER);
        if (userMsg != null) {
            this.showInformationMessage(userMsg);
        }
        this.mainPanel.requestFocus();
    }

    public void showMapEditorTransformPanel() {
        JInternalFrame f = this.addAsFrame(new MapEditorTransformPanel(this.freeColClient), true, PopupPosition.CENTERED, false);
        f.setLocation(f.getX(), 50);
        this.repaint();
    }

    public OptionGroup showMapGeneratorOptionsDialog(boolean editable) {
        MapGeneratorOptionsDialog mgod = new MapGeneratorOptionsDialog(this.freeColClient, editable);
        return this.showFreeColDialog(mgod, null);
    }

    public Dimension showMapSizeDialog() {
        return this.showFreeColDialog(new MapSizeDialog(this.freeColClient), null);
    }

    public void showModelMessages(List<ModelMessage> messages) {
        if (messages.isEmpty()) {
            return;
        }
        Game game = this.freeColClient.getGame();
        int n = messages.size();
        String[] texts = new String[n];
        FreeColObject[] fcos = new FreeColObject[n];
        ImageIcon[] icons = new ImageIcon[n];
        Tile tile = null;
        for (int i = 0; i < n; ++i) {
            ModelMessage m = messages.get(i);
            texts[i] = Messages.message(m);
            fcos[i] = game.getMessageSource(m);
            icons[i] = this.gui.getImageIcon(game.getMessageDisplay(m), false);
            if (tile != null || !(fcos[i] instanceof Location)) continue;
            tile = ((Location)((Object)fcos[i])).getTile();
        }
        this.showFreeColPanel(new InformationPanel(this.freeColClient, texts, fcos, icons), tile, true);
    }

    public void showMonarchDialog(Monarch.MonarchAction action, StringTemplate template, String monarchKey, DialogHandler<Boolean> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Boolean>(new MonarchDialog(this.freeColClient, action, template, monarchKey), null, handler));
    }

    public void showNameNewLandDialog(String key, String defaultName, Unit unit, DialogHandler<String> handler) {
        SwingUtilities.invokeLater(new DialogCallback<String>(new FreeColStringInputDialog(this.freeColClient, false, Messages.message(key), defaultName, "ok", null), unit.getTile(), handler));
    }

    public void showNameNewRegionDialog(StringTemplate template, String defaultName, Unit unit, DialogHandler<String> handler) {
        SwingUtilities.invokeLater(new DialogCallback<String>(new FreeColStringInputDialog(this.freeColClient, false, Messages.message(template), defaultName, "ok", null), unit.getTile(), handler));
    }

    public DiplomaticTrade showDiplomaticTradeDialog(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment) {
        if (!(our instanceof Unit) && !(our instanceof Colony) || !(other instanceof Unit) && !(other instanceof Colony) || our instanceof Colony && other instanceof Colony) {
            throw new RuntimeException("Bad DTD args: " + our + ", " + other);
        }
        DiplomaticTradeDialog dtd = new DiplomaticTradeDialog(this.freeColClient, our, other, agreement, comment);
        return this.showFreeColDialog(dtd, ((Location)((Object)our)).getTile());
    }

    public void showNewPanel() {
        this.showSubPanel(new NewPanel(this.freeColClient), false);
    }

    public void showNewPanel(Specification specification) {
        this.showSubPanel(new NewPanel(this.freeColClient, specification), false);
    }

    public void showOpenGamePanel() {
        this.showErrorMessage("openGame.unimplemented");
    }

    public void showOpeningVideoPanel(final String userMsg) {
        this.closeMenus();
        Video video = ResourceManager.getVideo("Opening.video");
        boolean muteAudio = !this.gui.canPlaySound();
        final VideoComponent vp = new VideoComponent(video, muteAudio);
        final class AbortListener
        implements ActionListener,
        KeyListener,
        MouseListener,
        VideoListener {
            private Timer t = null;

            AbortListener() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.execute();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.execute();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void stopped() {
                this.execute();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.execute();
            }

            private void setTimer(Timer t) {
                this.t = t;
            }

            private void execute() {
                Canvas.this.removeKeyListener(this);
                Canvas.this.removeMouseListener(this);
                vp.removeMouseListener(this);
                vp.stop();
                Canvas.this.remove(vp);
                if (this.t != null) {
                    this.t.stop();
                }
                Canvas.this.gui.playSound("sound.intro.general");
                Canvas.this.showMainPanel(userMsg);
            }
        }
        AbortListener l = new AbortListener();
        this.addMouseListener(l);
        this.addKeyListener(l);
        vp.addMouseListener(l);
        this.addCentered(vp, JLayeredPane.PALETTE_LAYER);
        vp.play();
        Timer t = new Timer(80000, l);
        l.setTimer(t);
        t.setRepeats(false);
        t.start();
    }

    public Parameters showParametersDialog() {
        return this.showFreeColDialog(new ParametersDialog(this.freeColClient), null);
    }

    public boolean showPreCombatDialog(Unit attacker, FreeColGameObject defender, Tile tile) {
        return this.showFreeColDialog(new PreCombatDialog(this.freeColClient, attacker, defender), tile);
    }

    public void showPurchasePanel() {
        PurchasePanel panel = this.getExistingFreeColPanel(PurchasePanel.class);
        if (panel == null) {
            this.showFreeColPanel(new PurchasePanel(this.freeColClient), null, false);
        }
    }

    public void showRecruitPanel() {
        RecruitPanel panel = this.getExistingFreeColPanel(RecruitPanel.class);
        if (panel == null) {
            this.showFreeColPanel(new RecruitPanel(this.freeColClient), null, false);
        }
    }

    public void showReportLabourDetailPanel(UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        ReportLabourDetailPanel details = new ReportLabourDetailPanel(this.freeColClient, unitType, data, unitCount, colonies);
        details.initialize();
        this.showSubPanel(details, true);
    }

    public String showRiverStyleDialog(Tile tile) {
        return this.showFreeColDialog(new RiverStyleDialog(this.freeColClient), tile);
    }

    public File showSaveDialog(File directory, String defaultName) {
        if (this.fileFilters == null) {
            this.fileFilters = new FileFilter[]{FreeColFileFilter.freeColSaveDirectoryFilter};
        }
        return this.showSaveDialog(directory, this.fileFilters, defaultName, ".fsg");
    }

    public File showSaveDialog(File directory, FileFilter[] fileFilters, String defaultName, String extension) {
        return this.showFreeColDialog(new SaveDialog(this.freeColClient, directory, fileFilters, defaultName, extension), null);
    }

    public Dimension showScaleMapSizeDialog() {
        return this.showFreeColDialog(new ScaleMapSizeDialog(this.freeColClient), null);
    }

    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        SelectAmountDialog fcd = new SelectAmountDialog(this.freeColClient, goodsType, available, defaultAmount, needToPay);
        Integer result = this.showFreeColDialog(fcd, null);
        return result == null ? -1 : result;
    }

    public int showSelectTributeAmountDialog(StringTemplate question, int maximum) {
        SelectTributeAmountDialog fcd = new SelectTributeAmountDialog(this.freeColClient, question, maximum);
        Integer result = this.showFreeColDialog(fcd, null);
        return result == null ? -1 : result;
    }

    public Location showSelectDestinationDialog(Unit unit) {
        return this.showFreeColDialog(new SelectDestinationDialog(this.freeColClient, unit), unit.getTile());
    }

    public void showServerListPanel(List<ServerInfo> serverList) {
        this.closeMenus();
        this.serverListPanel.initialize(serverList);
        this.showSubPanel(this.serverListPanel, true);
    }

    public void showSettlement(Settlement settlement) {
        if (settlement instanceof Colony) {
            if (settlement.getOwner().equals(this.freeColClient.getMyPlayer())) {
                this.showColonyPanel((Colony)settlement, null);
            } else if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
                this.showForeignColony(settlement);
            }
        } else if (settlement instanceof IndianSettlement) {
            this.showIndianSettlementPanel((IndianSettlement)settlement);
        } else {
            throw new IllegalStateException("Bogus settlement");
        }
    }

    public ColonyPanel showSpyColonyPanel(Tile tile) {
        Colony colony = tile.getColony();
        if (colony == null) {
            return null;
        }
        ColonyPanel panel = new ColonyPanel(this.freeColClient, colony);
        this.showFreeColPanel(panel, tile, true);
        return panel;
    }

    public void showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        if (game == null) {
            logger.warning("StartGamePanel requires game != null.");
        } else if (player == null) {
            logger.warning("StartGamePanel requires player != null.");
        } else {
            this.closeMenus();
            this.startGamePanel.initialize(singlePlayerMode);
            this.showSubPanel(this.startGamePanel, false);
        }
    }

    public void showStatisticsPanel() {
        this.showSubPanel(new StatisticsPanel(this.freeColClient), true);
    }

    public void showStatusPanel(String message) {
        this.statusPanel.setStatusMessage(message);
        this.addCentered(this.statusPanel, JLayeredPane.POPUP_LAYER);
    }

    public void showTilePanel(Tile tile) {
        if (tile == null || !tile.isExplored()) {
            return;
        }
        this.showSubPanel(new TilePanel(this.freeColClient, tile), false);
    }

    public void showTilePopup(Tile tile, int x, int y) {
        if (tile == null) {
            return;
        }
        TilePopup tp = new TilePopup(this.freeColClient, tile);
        if (tp.hasItem()) {
            tp.show(this, x, y);
            tp.repaint();
        } else if (tile.isExplored()) {
            this.showTilePanel(tile);
        }
    }

    public void showTradeRoutePanel(Unit unit) {
        this.showFreeColPanel(new TradeRoutePanel(this.freeColClient, unit), unit == null ? null : unit.getTile(), true);
    }

    public void showTradeRouteInputPanel(TradeRoute newRoute, Runnable callBack) {
        TradeRouteInputPanel panel = new TradeRouteInputPanel(this.freeColClient, newRoute);
        panel.addClosingCallback(callBack);
        this.showSubPanel(panel, null, true);
    }

    public void showTrainPanel() {
        TrainPanel panel = this.getExistingFreeColPanel(TrainPanel.class);
        if (panel == null) {
            this.showFreeColPanel(new TrainPanel(this.freeColClient), null, false);
        }
    }

    public void showVictoryDialog(DialogHandler<Boolean> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Boolean>(new VictoryDialog(this.freeColClient), null, handler));
    }

    public boolean showWarehouseDialog(Colony colony) {
        return this.showFreeColDialog(new WarehouseDialog(this.freeColClient, colony), null);
    }

    public void showWorkProductionPanel(Unit unit) {
        this.showSubPanel(new WorkProductionPanel(this.freeColClient, unit), true);
    }

    public void updateEuropeanSubpanels() {
        TrainPanel tp;
        PurchasePanel pp;
        RecruitPanel rp = this.getExistingFreeColPanel(RecruitPanel.class);
        if (rp != null) {
            rp.update();
        }
        if ((pp = this.getExistingFreeColPanel(PurchasePanel.class)) != null) {
            pp.update();
        }
        if ((tp = this.getExistingFreeColPanel(TrainPanel.class)) != null) {
            tp.update();
        }
    }

    public void showReportCargoPanel() {
        ReportCargoPanel r = this.getExistingFreeColPanel(ReportCargoPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportCargoPanel(this.freeColClient), true);
        }
    }

    public void showReportColonyPanel() {
        ReportColonyPanel r = this.getExistingFreeColPanel(ReportColonyPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportColonyPanel(this.freeColClient), true);
        }
    }

    public void showReportContinentalCongressPanel() {
        ReportContinentalCongressPanel r = this.getExistingFreeColPanel(ReportContinentalCongressPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportContinentalCongressPanel(this.freeColClient), true);
        }
    }

    public void showReportEducationPanel() {
        ReportEducationPanel r = this.getExistingFreeColPanel(ReportEducationPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportEducationPanel(this.freeColClient), true);
        }
    }

    public void showReportExplorationPanel() {
        ReportExplorationPanel r = this.getExistingFreeColPanel(ReportExplorationPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportExplorationPanel(this.freeColClient), true);
        }
    }

    public void showReportForeignAffairPanel() {
        ReportForeignAffairPanel r = this.getExistingFreeColPanel(ReportForeignAffairPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportForeignAffairPanel(this.freeColClient), true);
        }
    }

    public void showReportHistoryPanel() {
        ReportHistoryPanel r = this.getExistingFreeColPanel(ReportHistoryPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportHistoryPanel(this.freeColClient), true);
        }
    }

    public void showReportIndianPanel() {
        ReportIndianPanel r = this.getExistingFreeColPanel(ReportIndianPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportIndianPanel(this.freeColClient), true);
        }
    }

    public void showReportLabourPanel() {
        ReportLabourPanel r = this.getExistingFreeColPanel(ReportLabourPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportLabourPanel(this.freeColClient), true);
        }
    }

    public void showReportMilitaryPanel() {
        ReportMilitaryPanel r = this.getExistingFreeColPanel(ReportMilitaryPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportMilitaryPanel(this.freeColClient), true);
        }
    }

    public void showReportNavalPanel() {
        ReportNavalPanel r = this.getExistingFreeColPanel(ReportNavalPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportNavalPanel(this.freeColClient), true);
        }
    }

    public void showReportProductionPanel() {
        ReportProductionPanel r = this.getExistingFreeColPanel(ReportProductionPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportProductionPanel(this.freeColClient), true);
        }
    }

    public void showReportReligiousPanel() {
        ReportReligiousPanel r = this.getExistingFreeColPanel(ReportReligiousPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportReligiousPanel(this.freeColClient), true);
        }
    }

    public void showReportRequirementsPanel() {
        ReportRequirementsPanel r = this.getExistingFreeColPanel(ReportRequirementsPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportRequirementsPanel(this.freeColClient), true);
        }
    }

    public void showReportTradePanel() {
        ReportTradePanel r = this.getExistingFreeColPanel(ReportTradePanel.class);
        if (r == null) {
            this.showSubPanel(new ReportTradePanel(this.freeColClient), true);
        }
    }

    public void showReportTurnPanel(List<ModelMessage> messages) {
        ReportTurnPanel r = this.getExistingFreeColPanel(ReportTurnPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportTurnPanel(this.freeColClient, messages), true);
        } else {
            r.setMessages(messages);
        }
    }

    private static class ToolBoxFrame
    extends JInternalFrame {
        private ToolBoxFrame() {
        }
    }

    public static enum PopupPosition {
        ORIGIN,
        CENTERED,
        CENTERED_LEFT,
        CENTERED_RIGHT;

    }

    private class DialogCallback<T>
    implements Runnable {
        private final FreeColDialog<T> fcd;
        private final Tile tile;
        private final DialogHandler<T> handler;

        public DialogCallback(FreeColDialog<T> fcd, Tile tile, DialogHandler<T> handler) {
            this.fcd = fcd;
            this.tile = tile;
            this.handler = handler;
        }

        @Override
        public void run() {
            Canvas.this.viewFreeColDialog(this.fcd, this.tile);
            new Thread(this.fcd.toString()){

                @Override
                public void run() {
                    while (!DialogCallback.this.fcd.responded()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    DialogCallback.this.handler.handle(DialogCallback.this.fcd.getResponse());
                }
            }.start();
        }
    }
}

