/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.MessageHandler;
import org.w3c.dom.Element;

public abstract class InputHandler
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(InputHandler.class.getName());
    private final FreeColClient freeColClient;

    public InputHandler(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
    }

    protected FreeColClient getFreeColClient() {
        return this.freeColClient;
    }

    protected GUI getGUI() {
        return this.freeColClient.getGUI();
    }

    protected Game getGame() {
        return this.freeColClient.getGame();
    }

    @Override
    public abstract Element handle(Connection var1, Element var2);

    protected Element disconnect(Element element) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InputHandler.this.getGUI().containsInGameComponents()) {
                    if (InputHandler.this.freeColClient.getFreeColServer() == null) {
                        InputHandler.this.getGUI().returnToTitle();
                    } else {
                        InputHandler.this.getGUI().removeInGameComponents();
                    }
                }
            }
        });
        return null;
    }

    protected Element unknown(Element element) {
        logger.warning("Unknown message type: " + element.getTagName());
        return null;
    }
}

