/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyWas;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeWas;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.NetworkConstants;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.FreeColServer;

public final class InGameController
implements NetworkConstants {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    private static final short UNIT_LAST_MOVE_DELAY = 300;
    private static final StringTemplate abortTrade = StringTemplate.template("");
    private final FreeColClient freeColClient;
    private GUI gui;
    private MoveMode moveMode = MoveMode.NEXT_ACTIVE_UNIT;
    private HashMap<String, Integer> messagesToIgnore = new HashMap();
    private final List<ModelMessage> turnReportMessages = new ArrayList<ModelMessage>();

    public InGameController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
    }

    private ServerAPI askServer() {
        return this.freeColClient.askServer();
    }

    private Specification getSpecification() {
        return this.freeColClient.getGame().getSpecification();
    }

    private boolean requireOurTurn() {
        if (!this.freeColClient.currentPlayerIsMyPlayer()) {
            if (this.freeColClient.isInGame()) {
                this.gui.showInformationMessage("notYourTurn");
            }
            return false;
        }
        return true;
    }

    private Settlement getSettlementAt(Tile tile, Map.Direction direction) {
        return tile.getNeighbourOrNull(direction).getSettlement();
    }

    private StringTemplate getNationAt(Tile tile, Map.Direction direction) {
        Tile newTile = tile.getNeighbourOrNull(direction);
        Player player = null;
        player = newTile.hasSettlement() ? newTile.getSettlement().getOwner() : (newTile.getFirstUnit() != null ? newTile.getFirstUnit().getOwner() : this.freeColClient.getGame().getUnknownEnemy());
        return player.getNationName();
    }

    private void updateControls() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InGameController.this.freeColClient.updateActions();
                InGameController.this.gui.updateMenuBar();
            }
        });
    }

    private boolean askAssignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (tradeRoute == unit.getTradeRoute()) {
            return true;
        }
        if (tradeRoute != null && unit.getTradeRoute() != null && !this.gui.confirmClearTradeRoute(unit)) {
            return false;
        }
        return this.askServer().assignTradeRoute(unit, tradeRoute) && unit.getTradeRoute() == tradeRoute;
    }

    private boolean askClaimTile(Player player, Tile tile, FreeColGameObject claimant, int price) {
        Player owner = tile.getOwner();
        if (price < 0) {
            return false;
        }
        if (price > 0) {
            GUI.ClaimAction act = this.gui.getClaimChoice(tile, player, price, owner);
            if (act == null) {
                return false;
            }
            switch (act) {
                case ACCEPT: {
                    break;
                }
                case STEAL: {
                    price = -1;
                    break;
                }
                default: {
                    logger.warning("Claim dialog fail: " + (Object)((Object)act));
                    return false;
                }
            }
        }
        return this.askServer().claimTile(tile, claimant, price) && player.owns(tile);
    }

    private boolean askClearGotoOrders(Unit unit) {
        if (!this.askAssignTradeRoute(unit, null)) {
            return false;
        }
        if (unit.getDestination() == null) {
            return true;
        }
        this.gui.clearGotoPath();
        return this.askSetDestination(unit, null);
    }

    private Unit askEmigrate(Europe europe, int slot) {
        if (europe == null || !Europe.MigrationType.validMigrantSlot(slot)) {
            return null;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        Unit ret = null;
        if (this.askServer().emigrate(slot)) {
            europeWas.fireChanges();
            ret = europeWas.getNewUnit();
        }
        return ret;
    }

    private boolean askLoadGoods(GoodsType type, int amount, Unit carrier) {
        boolean ret;
        TradeLocation trl = carrier.getTradeLocation();
        if (trl == null) {
            return false;
        }
        int loadable = carrier.getLoadableAmount(type);
        if (amount > loadable) {
            amount = loadable;
        }
        Player player = carrier.getOwner();
        Market market = player.getMarket();
        int price = 0;
        if (carrier.isInEurope()) {
            if (!player.canTrade(type)) {
                return false;
            }
            if (!player.checkGold(market.getBidPrice(type, amount))) {
                this.gui.showErrorMessage("notEnoughGold");
                return false;
            }
            price = market.getCostToBuy(type);
        }
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        boolean bl = ret = this.askServer().loadGoods(type, amount, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount;
        if (ret && price > 0) {
            for (TransactionListener l : market.getTransactionListener()) {
                l.logPurchase(type, amount, price);
            }
        }
        return ret;
    }

    private boolean askSetDestination(Unit unit, Location destination) {
        return this.askServer().setDestination(unit, destination) && unit.getDestination() == destination;
    }

    private boolean askUnloadGoods(GoodsType type, int amount, Unit carrier) {
        boolean ret;
        Player player = this.freeColClient.getMyPlayer();
        Market market = player.getMarket();
        int price = 0;
        int tax = 0;
        if (carrier.isInEurope() && player.canTrade(type)) {
            price = market.getPaidForSale(type);
            tax = player.getTax();
        }
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        boolean bl = ret = this.askServer().unloadGoods(type, amount, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount;
        if (ret && price > 0) {
            for (TransactionListener l : market.getTransactionListener()) {
                l.logSale(type, amount, price, tax);
            }
        }
        return ret;
    }

    private String getSaveGameString(Game game) {
        Player player = this.freeColClient.getMyPlayer();
        String gid = Integer.toHexString(game.getUUID().hashCode());
        Turn turn = game.getTurn();
        String turnString = Integer.toString(turn.getYear());
        switch (turn.getSeason()) {
            case SPRING: {
                turnString = turnString + "_1_" + Messages.message("spring");
                break;
            }
            case AUTUMN: {
                turnString = turnString + "_2_" + Messages.message("autumn");
                break;
            }
        }
        String fileName = gid + "_" + Messages.message(player.getNationName()) + "_" + turnString;
        return fileName.replaceAll(" ", "_");
    }

    private void autoSaveGame() {
        Game game = this.freeColClient.getGame();
        if (game == null) {
            return;
        }
        ClientOptions options = this.freeColClient.getClientOptions();
        String prefix = options.getText("model.option.autoSavePrefix");
        String lastTurnName = prefix + "-" + options.getText("model.option.lastTurnName") + ".fsg";
        String beforeLastTurnName = prefix + "-" + options.getText("model.option.beforeLastTurnName") + ".fsg";
        File autoSaveDir = FreeColDirectories.getAutosaveDirectory();
        File lastTurnFile = new File(autoSaveDir, lastTurnName);
        File beforeLastTurnFile = new File(autoSaveDir, beforeLastTurnName);
        if (lastTurnFile.exists()) {
            beforeLastTurnFile.delete();
            lastTurnFile.renameTo(beforeLastTurnFile);
        }
        this.saveGame(lastTurnFile);
        int saveGamePeriod = options.getInteger("model.option.autosavePeriod");
        int turnNumber = game.getTurn().getNumber();
        if (saveGamePeriod <= 1 || saveGamePeriod != 0 && turnNumber % saveGamePeriod == 0) {
            String fileName = prefix + "-" + this.getSaveGameString(game) + ".fsg";
            this.saveGame(new File(autoSaveDir, fileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveGame(File file) {
        FreeColServer server = this.freeColClient.getFreeColServer();
        boolean result = false;
        this.gui.showStatusPanel(Messages.message("status.savingGame"));
        try {
            server.setActiveUnit(this.gui.getActiveUnit());
            server.saveGame(file, this.freeColClient.getClientOptions());
            result = true;
        }
        catch (IOException e) {
            this.gui.showErrorMessage("couldNotSaveGame");
        }
        finally {
            this.gui.closeStatusPanel();
        }
        return result;
    }

    private boolean shouldAllowMessage(ModelMessage message) {
        BooleanOption option = this.freeColClient.getClientOptions().getBooleanOption(message);
        return option == null ? true : option.getValue();
    }

    private synchronized void startIgnoringMessage(String key, int turn) {
        logger.finer("Ignoring model message with key " + key);
        this.messagesToIgnore.put(key, turn);
    }

    private synchronized void stopIgnoringMessage(String key) {
        logger.finer("Removing model message with key " + key + " from ignored messages.");
        this.messagesToIgnore.remove(key);
    }

    private synchronized Integer getTurnForMessageIgnored(String key) {
        return this.messagesToIgnore.get(key);
    }

    public void displayTurnReportMessages() {
        this.gui.showReportTurnPanel(this.turnReportMessages);
    }

    public boolean displayModelMessages(boolean allMessages, boolean endOfTurn) {
        Player player = this.freeColClient.getMyPlayer();
        int thisTurn = this.freeColClient.getGame().getTurn().getNumber();
        final ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        for (ModelMessage m : allMessages ? player.getModelMessages() : player.getNewModelMessages()) {
            if (this.shouldAllowMessage(m)) {
                if (m.getMessageType() == ModelMessage.MessageType.WAREHOUSE_CAPACITY) {
                    String key = m.getSourceId();
                    block1 : switch (m.getTemplateType()) {
                        case TEMPLATE: {
                            for (String otherkey : m.getKeys()) {
                                if (!"%goods%".equals(otherkey)) continue;
                                key = key + otherkey;
                                break block1;
                            }
                            break;
                        }
                    }
                    Integer turn = this.getTurnForMessageIgnored(key);
                    if (turn != null && turn == thisTurn - 1) {
                        this.startIgnoringMessage(key, thisTurn);
                        m.setBeenDisplayed(true);
                        continue;
                    }
                }
                messages.add(m);
            }
            m.setBeenDisplayed(true);
        }
        ArrayList<String> todo = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.messagesToIgnore.entrySet()) {
            if (entry.getValue() >= thisTurn - 1) continue;
            todo.add(entry.getKey());
        }
        while (!todo.isEmpty()) {
            String key = (String)todo.remove(0);
            this.stopIgnoringMessage(key);
        }
        if (!messages.isEmpty()) {
            Runnable uiTask;
            if (endOfTurn) {
                this.turnReportMessages.addAll(messages);
                uiTask = new Runnable(){

                    @Override
                    public void run() {
                        InGameController.this.displayTurnReportMessages();
                    }
                };
            } else {
                uiTask = new Runnable(){

                    @Override
                    public void run() {
                        InGameController.this.gui.showModelMessages(messages);
                    }
                };
            }
            this.updateControls();
            if (SwingUtilities.isEventDispatchThread()) {
                uiTask.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(uiTask);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    logger.log(Level.WARNING, "Message display", ex);
                }
            }
        }
        return !messages.isEmpty();
    }

    private boolean doExecuteGotoOrders() {
        Unit unit;
        if (this.gui.isShowingSubPanel()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit active = this.gui.getActiveUnit();
        Unit stillActive = null;
        this.moveMode = this.moveMode.maximize(MoveMode.EXECUTE_GOTO_ORDERS);
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        while (player.hasNextTradeRouteUnit()) {
            unit = player.getNextTradeRouteUnit();
            this.gui.setActiveUnit(unit);
            if (!this.moveToDestination(unit, messages)) continue;
            stillActive = unit;
        }
        if (!messages.isEmpty()) {
            for (ModelMessage m : messages) {
                player.addModelMessage(m);
            }
            this.displayModelMessages(false, false);
            this.gui.setActiveUnit(stillActive != null ? stillActive : active);
            return false;
        }
        stillActive = null;
        if (active != null) {
            player.setNextGoingToUnit(active);
        }
        while (player.hasNextGoingToUnit()) {
            unit = player.getNextGoingToUnit();
            this.gui.setActiveUnit(unit);
            if (this.moveToDestination(unit, null)) {
                stillActive = unit;
            }
            if (!this.gui.isShowingSubPanel()) continue;
            this.gui.requestFocusForSubPanel();
            stillActive = unit;
            break;
        }
        this.gui.setActiveUnit(stillActive != null ? stillActive : active);
        return stillActive == null;
    }

    private boolean doEndTurn(boolean showDialog) {
        if (showDialog) {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Unit unit : this.freeColClient.getMyPlayer().getUnits()) {
                if (!unit.couldMove()) continue;
                units.add(unit);
            }
            if (!units.isEmpty()) {
                this.gui.showEndTurnDialog(units);
                return false;
            }
        }
        this.moveMode = this.moveMode.maximize(MoveMode.END_TURN);
        if (!this.doExecuteGotoOrders()) {
            return false;
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.DESYNC) && DebugUtils.checkDesyncAction(this.freeColClient)) {
            this.freeColClient.getConnectController().reconnect();
            return false;
        }
        this.gui.closeMenus();
        this.gui.setActiveUnit(null);
        for (Unit unit : this.freeColClient.getMyPlayer().getUnits()) {
            if (unit.getState() != Unit.UnitState.SKIPPED) continue;
            unit.setState(Unit.UnitState.ACTIVE);
        }
        this.moveMode = MoveMode.NEXT_ACTIVE_UNIT;
        this.turnReportMessages.clear();
        return this.askServer().endTurn();
    }

    private boolean updateActiveUnit(Tile tile) {
        this.displayModelMessages(false, false);
        if (this.moveMode != MoveMode.NEXT_ACTIVE_UNIT && !this.doExecuteGotoOrders()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && !unit.isDisposed() && unit.couldMove()) {
            return false;
        }
        if (player.hasNextActiveUnit()) {
            this.gui.setActiveUnit(player.getNextActiveUnit());
            return true;
        }
        this.gui.setActiveUnit(null);
        if (!this.doExecuteGotoOrders()) {
            return true;
        }
        ClientOptions options = this.freeColClient.getClientOptions();
        if (tile != null) {
            this.gui.setSelectedTile(tile, false);
        } else if (options.getBoolean("model.option.autoEndTurn")) {
            this.doEndTurn(options.getBoolean("model.option.showEndTurnDialog"));
        }
        return true;
    }

    private boolean moveToDestination(Unit unit, List<ModelMessage> messages) {
        if (!this.requireOurTurn() || unit.isAtSea() || unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED) {
            return false;
        }
        if (unit.getTradeRoute() != null) {
            return this.followTradeRoute(unit, messages);
        }
        Location destination = unit.getDestination();
        if (destination == null) {
            return unit.getMovesLeft() > 0;
        }
        Player player = this.freeColClient.getMyPlayer();
        PathNode path = unit.findPath(destination);
        if (path == null) {
            StringTemplate src = unit.getLocation().getLocationLabelFor(player);
            StringTemplate dst = destination.getLocationLabelFor(player);
            StringTemplate template = StringTemplate.template("selectDestination.failed").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%location%", src).addStringTemplate("%destination%", dst);
            this.gui.showInformationMessage((FreeColObject)unit, template);
            return false;
        }
        this.gui.setActiveUnit(unit);
        if (this.movePath(unit, path) && unit.isAtLocation(destination)) {
            this.askClearGotoOrders(unit);
            if (!this.checkCashInTreasureTrain(unit) && unit.getMovesLeft() > 0 && unit.getState() != Unit.UnitState.SKIPPED) {
                return true;
            }
        }
        return false;
    }

    public boolean moveDirection(Unit unit, Map.Direction direction, boolean interactive) {
        Unit.MoveType mt = unit.getMoveType(direction);
        Location destination = unit.getDestination();
        boolean clearDestination = destination != null && unit.hasTile() && Map.isSameLocation(unit.getTile().getNeighbourOrNull(direction), destination);
        boolean result = mt.isLegal();
        switch (mt) {
            case MOVE_HIGH_SEAS: {
                if (this.freeColClient.getMyPlayer().getEurope() != null) {
                    if (destination == null) {
                        result = this.moveHighSeas(unit, direction);
                        break;
                    }
                    if (destination instanceof Europe) {
                        result = this.moveTo(unit, destination);
                        break;
                    }
                }
            }
            case MOVE: {
                result = this.moveMove(unit, direction);
                break;
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                result = this.moveExplore(unit, direction);
                break;
            }
            case ATTACK_UNIT: {
                result = this.moveAttack(unit, direction);
                break;
            }
            case ATTACK_SETTLEMENT: {
                result = this.moveAttackSettlement(unit, direction);
                break;
            }
            case EMBARK: {
                result = this.moveEmbark(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: {
                result = this.moveLearnSkill(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: {
                result = this.moveScoutIndianSettlement(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: {
                result = this.moveUseMissionary(unit, direction);
                break;
            }
            case ENTER_FOREIGN_COLONY_WITH_SCOUT: {
                result = this.moveScoutColony(unit, direction);
                break;
            }
            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                result = this.moveTrade(unit, direction);
                break;
            }
            case MOVE_NO_ACCESS_BEACHED: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessBeached").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_CONTACT: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessContact").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_GOODS: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessGoods").addStringTemplate("%nation%", nation).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ACCESS_LAND: {
                if (this.moveDisembark(unit, direction) || !interactive) break;
                this.gui.playSound("sound.event.illegalMove");
                break;
            }
            case MOVE_NO_ACCESS_MISSION_BAN: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessMissionBan").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_SETTLEMENT: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessSettlement").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_SKILL: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessSkill").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ACCESS_TRADE: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessTrade").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_WAR: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessWar").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_WATER: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessWater").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ATTACK_MARINE: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAttackWater").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_MOVES: {
                clearDestination = false;
                unit.setState(Unit.UnitState.SKIPPED);
                break;
            }
            case MOVE_NO_TILE: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noTile").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            default: {
                if (interactive || clearDestination) {
                    this.gui.playSound("sound.event.illegalMove");
                }
                result = false;
            }
        }
        if (clearDestination && !unit.isDisposed()) {
            this.askClearGotoOrders(unit);
        }
        return result;
    }

    private boolean movePath(Unit unit, PathNode path) {
        while (path != null) {
            if (!unit.isAtLocation(path.getLocation())) {
                if (path.getLocation() instanceof Europe) {
                    if (unit.hasTile() && unit.getTile().isDirectlyHighSeasConnected()) {
                        this.moveTo(unit, path.getLocation());
                    } else {
                        logger.warning("Can not move to Europe from " + unit.getLocation() + " on path: " + path.fullPathToString());
                    }
                    return false;
                }
                if (path.getLocation() instanceof Tile) {
                    if (path.getDirection() == null) {
                        if (unit.isInEurope()) {
                            this.moveTo(unit, unit.getGame().getMap());
                        } else {
                            logger.warning("Null direction on path: " + path.fullPathToString());
                        }
                        return false;
                    }
                    if (!this.moveDirection(unit, path.getDirection(), false)) {
                        return false;
                    }
                    if (unit.hasTile() && unit.getTile().getDiscoverableRegion() != null) {
                        return false;
                    }
                } else {
                    if (path.getLocation() instanceof Unit) {
                        return this.moveEmbark(unit, path.getDirection());
                    }
                    logger.warning("Bad path: " + path.fullPathToString());
                }
            }
            path = path.next;
        }
        return true;
    }

    private boolean moveAttack(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Unit u = target.getFirstUnit();
        if (u == null || unit.getOwner().owns(u)) {
            return false;
        }
        this.askClearGotoOrders(unit);
        if (this.gui.confirmHostileAction(unit, target) && this.gui.confirmPreCombat(unit, target)) {
            this.askServer().attack(unit, direction);
        }
        return false;
    }

    private boolean moveAttackSettlement(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Settlement settlement = target.getSettlement();
        if (settlement == null || unit.getOwner().owns(settlement)) {
            return false;
        }
        GUI.ArmedUnitSettlementAction act = this.gui.getArmedUnitSettlementChoice(settlement);
        if (act == null) {
            return true;
        }
        switch (act) {
            case SETTLEMENT_ATTACK: {
                if (!this.gui.confirmHostileAction(unit, target) || !this.gui.confirmPreCombat(unit, target)) break;
                this.askServer().attack(unit, direction);
                Colony col = target.getColony();
                if (col != null && unit.getOwner().owns(col)) {
                    this.gui.showColonyPanel(col, unit);
                }
                return false;
            }
            case SETTLEMENT_TRIBUTE: {
                int amount;
                int n = settlement instanceof Colony ? this.gui.confirmEuropeanTribute(unit, (Colony)settlement, this.getNationSummary(settlement.getOwner())) : (amount = settlement instanceof IndianSettlement ? this.gui.confirmNativeTribute(unit, (IndianSettlement)settlement) : -1);
                if (amount <= 0) {
                    return true;
                }
                return this.moveTribute(unit, amount, direction);
            }
            default: {
                logger.warning("showArmedUnitSettlementDialog fail: " + (Object)((Object)act));
            }
        }
        return true;
    }

    private boolean moveDiplomacy(Unit unit, Map.Direction direction, DiplomaticTrade dt) {
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement == null || !(settlement instanceof Colony)) {
            return false;
        }
        Colony colony = (Colony)settlement;
        Game game = this.freeColClient.getGame();
        Player player = unit.getOwner();
        Player other = colony.getOwner();
        if (other == player.getREFPlayer()) {
            return false;
        }
        StringTemplate nation = other.getNationName();
        ModelMessage m = null;
        while (dt != null) {
            DiplomaticTrade.TradeStatus status = dt.getStatus();
            dt = this.askServer().diplomacy(game, unit, colony, dt);
            if (status != DiplomaticTrade.TradeStatus.PROPOSE_TRADE) break;
            status = dt == null ? DiplomaticTrade.TradeStatus.REJECT_TRADE : dt.getStatus();
            m = null;
            switch (status) {
                case PROPOSE_TRADE: {
                    break;
                }
                case ACCEPT_TRADE: {
                    m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "negotiationDialog.offerAccepted", colony).addStringTemplate("%nation%", nation);
                    dt = null;
                    break;
                }
                case REJECT_TRADE: {
                    m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "negotiationDialog.offerRejected", colony).addStringTemplate("%nation%", nation);
                    dt = null;
                    break;
                }
                default: {
                    throw new RuntimeException("Bogus trade status" + (Object)((Object)status));
                }
            }
            if (m != null) {
                player.addModelMessage(m);
            }
            if (dt == null) continue;
            dt = this.gui.showDiplomaticTradeDialog(unit, colony, dt, dt.getSendMessage(player, colony));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveDisembark(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile.getFirstUnit() != null && tile.getFirstUnit().getOwner() != unit.getOwner()) {
            return false;
        }
        ArrayList<Unit> disembarkable = new ArrayList<Unit>();
        unit.setStateToAllChildren(Unit.UnitState.ACTIVE);
        for (Unit u : unit.getUnitList()) {
            if (!u.getMoveType(tile).isProgress()) continue;
            disembarkable.add(u);
        }
        if (disembarkable.isEmpty()) {
            return false;
        }
        while (!disembarkable.isEmpty()) {
            Unit u;
            if (disembarkable.size() == 1) {
                if (!this.gui.confirm(true, tile, StringTemplate.key("disembark.text"), disembarkable.get(0), "ok", "cancel")) break;
                this.moveDirection((Unit)disembarkable.get(0), direction, false);
                break;
            }
            ArrayList choices = new ArrayList();
            for (Unit dUnit : disembarkable) {
                choices.add(new ChoiceItem<Unit>(dUnit.getDescription(Unit.UnitLabelType.NATIONAL), dUnit));
            }
            if (disembarkable.size() > 1) {
                choices.add(new ChoiceItem<Unit>(Messages.message("all"), unit));
            }
            if ((u = (Unit)this.gui.getChoice(true, unit.getTile(), Messages.message("disembark.text"), unit, "disembark.cancel", choices)) == null) break;
            if (u == unit) {
                for (Unit dUnit : disembarkable) {
                    try {
                        this.moveDirection(dUnit, direction, false);
                    }
                    catch (Throwable throwable) {}
                }
                return true;
            }
            this.moveDirection(u, direction, false);
            disembarkable.remove(u);
        }
        return true;
    }

    private boolean moveEmbark(Unit unit, Map.Direction direction) {
        if (unit.getColony() != null && !this.gui.confirmLeaveColony(unit)) {
            return false;
        }
        Tile sourceTile = unit.getTile();
        Tile destinationTile = sourceTile.getNeighbourOrNull(direction);
        Unit carrier = null;
        ArrayList choices = new ArrayList();
        for (Unit u : destinationTile.getUnitList()) {
            if (!u.canAdd(unit)) continue;
            String m = u.getDescription(Unit.UnitLabelType.NATIONAL);
            choices.add(new ChoiceItem<Unit>(m, u));
            carrier = u;
        }
        if (choices.isEmpty()) {
            throw new RuntimeException("Unit " + unit.getId() + " found no carrier to embark upon.");
        }
        if (choices.size() != 1 && (carrier = (Unit)this.gui.getChoice(true, unit.getTile(), Messages.message("embark.text"), unit, "embark.cancel", choices)) == null) {
            return true;
        }
        this.askClearGotoOrders(unit);
        if (!this.askServer().embark(unit, carrier, direction) || unit.getLocation() != carrier) {
            unit.setState(Unit.UnitState.SKIPPED);
            return false;
        }
        unit.getOwner().invalidateCanSeeTiles();
        return false;
    }

    private boolean moveExplore(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (!this.gui.confirm(true, unit.getTile(), StringTemplate.key("exploreLostCityRumour.text"), unit, "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            return true;
        }
        if (tile.getLostCityRumour().getType() == LostCityRumour.RumourType.MOUNDS && !this.gui.confirm(true, unit.getTile(), StringTemplate.key("exploreMoundsRumour.text"), unit, "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            this.askServer().declineMounds(unit, direction);
        }
        return this.moveMove(unit, direction);
    }

    private boolean moveHighSeas(Unit unit, Map.Direction direction) {
        Tile oldTile = unit.getTile();
        Tile newTile = oldTile.getNeighbourOrNull(direction);
        if (newTile == null || !oldTile.isDirectlyHighSeasConnected() && newTile.isDirectlyHighSeasConnected()) {
            if (unit.getTradeRoute() != null) {
                TradeRouteStop stop = unit.getStop();
                if (stop != null && TradeRoute.isStopValid(unit, stop) && stop.getLocation() instanceof Europe) {
                    this.moveTo(unit, stop.getLocation());
                    return false;
                }
            } else {
                if (unit.getDestination() instanceof Europe) {
                    this.moveTo(unit, unit.getDestination());
                    return false;
                }
                if (this.gui.confirm(true, oldTile, StringTemplate.template("highseas.text").addAmount("%number%", unit.getSailTurns()), unit, "highseas.yes", "highseas.no")) {
                    this.moveTo(unit, unit.getOwner().getEurope());
                    return false;
                }
            }
        }
        return this.moveMove(unit, direction);
    }

    private boolean moveLearnSkill(Unit unit, Map.Direction direction) {
        this.askClearGotoOrders(unit);
        if (!this.askServer().askSkill(unit, direction)) {
            return false;
        }
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        UnitType skill = settlement.getLearnableSkill();
        if (skill == null) {
            this.gui.showInformationMessage((FreeColObject)settlement, "indianSettlement.noMoreSkill");
        } else if (!unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
            this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("indianSettlement.cantLearnSkill").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).add("%skill%", skill.getNameKey()));
        } else if (this.gui.confirm(true, unit.getTile(), StringTemplate.template("learnSkill.text").add("%skill%", skill.getNameKey()), unit, "learnSkill.yes", "learnSkill.no") && this.askServer().learnSkill(unit, direction)) {
            if (unit.isDisposed()) {
                this.gui.showInformationMessage((FreeColObject)settlement, "learnSkill.die");
                return false;
            }
            if (unit.getType() != skill) {
                this.gui.showInformationMessage((FreeColObject)settlement, "learnSkill.leave");
            }
        }
        return false;
    }

    private boolean moveMove(Unit unit, Map.Direction direction) {
        if (unit.canCarryUnits() && unit.hasSpaceLeft() && (unit.getColony() != null || unit.isInEurope())) {
            boolean boarded = false;
            for (Unit sentry : unit.getLocation().getUnitList()) {
                if (sentry.getState() != Unit.UnitState.SENTRY) continue;
                if (unit.canAdd(sentry)) {
                    boarded |= this.boardShip(sentry, unit);
                    logger.finest("Unit " + unit + " loaded sentry " + sentry);
                    continue;
                }
                logger.finest("Unit " + sentry + " is too big to board " + unit);
            }
            if (boarded && unit.getMovesLeft() <= 0) {
                return false;
            }
        }
        if (!this.askServer().move(unit, direction)) {
            unit.setState(Unit.UnitState.SKIPPED);
            return false;
        }
        unit.getOwner().invalidateCanSeeTiles();
        Tile tile = unit.getTile();
        ClientOptions options = this.freeColClient.getClientOptions();
        if (unit.getMovesLeft() <= 0 && options.getBoolean("model.option.unitLastMoveDelay")) {
            this.gui.paintImmediatelyCanvasInItsBounds();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (unit.isDisposed() || this.checkCashInTreasureTrain(unit)) {
            return false;
        }
        if (tile.getColony() != null && unit.isCarrier() && unit.getTradeRoute() == null && (unit.getDestination() == null || unit.getDestination().getTile() == tile.getTile())) {
            this.gui.showColonyPanel(tile.getColony(), unit);
        }
        if (unit.getMovesLeft() <= 0) {
            return false;
        }
        this.displayModelMessages(false);
        if (!this.gui.onScreen(tile)) {
            this.gui.setSelectedTile(tile, false);
        }
        return true;
    }

    private boolean moveScoutColony(Unit unit, Map.Direction direction) {
        Game game = this.freeColClient.getGame();
        Colony colony = (Colony)this.getSettlementAt(unit.getTile(), direction);
        boolean canNeg = colony.getOwner() != unit.getOwner().getREFPlayer();
        this.askClearGotoOrders(unit);
        GUI.ScoutColonyAction act = this.gui.getScoutForeignColonyChoice(colony, unit, canNeg);
        if (act == null) {
            return true;
        }
        switch (act) {
            case FOREIGN_COLONY_ATTACK: {
                return this.moveAttackSettlement(unit, direction);
            }
            case FOREIGN_COLONY_NEGOTIATE: {
                Player player = unit.getOwner();
                DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.DIPLOMATIC, player, colony.getOwner(), null, 0);
                agreement = this.gui.showDiplomaticTradeDialog(unit, colony, agreement, agreement.getSendMessage(player, colony));
                return agreement == null || agreement.getStatus() == DiplomaticTrade.TradeStatus.REJECT_TRADE ? true : this.moveDiplomacy(unit, direction, agreement);
            }
            case FOREIGN_COLONY_SPY: {
                return this.moveSpy(unit, direction);
            }
        }
        logger.warning("showScoutForeignColonyDialog fail: " + (Object)((Object)act));
        return true;
    }

    private boolean moveScoutIndianSettlement(Unit unit, Map.Direction direction) {
        GUI.ScoutIndianSettlementAction act;
        Tile unitTile = unit.getTile();
        Tile tile = unitTile.getNeighbourOrNull(direction);
        IndianSettlement settlement = tile.getIndianSettlement();
        Player player = unit.getOwner();
        this.askClearGotoOrders(unit);
        String number = this.askServer().scoutSettlement(unit, direction);
        if (number == null) {
            number = Messages.message("many");
        }
        if ((act = this.gui.getScoutIndianSettlementChoice(settlement, number)) == null) {
            return true;
        }
        switch (act) {
            case INDIAN_SETTLEMENT_ATTACK: {
                if (!this.gui.confirmPreCombat(unit, tile)) {
                    return true;
                }
                this.askServer().attack(unit, direction);
                return false;
            }
            case INDIAN_SETTLEMENT_SPEAK: {
                int oldGold = player.getGold();
                String result = this.askServer().scoutSpeakToChief(unit, direction);
                if (result == null) {
                    return false;
                }
                if ("die".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakDie");
                    return false;
                }
                if ("expert".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.expertScout").add("%unit%", unit.getType().getNameKey()));
                } else if ("tales".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakTales");
                } else if ("beads".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.speakBeads").addAmount("%amount%", player.getGold() - oldGold));
                } else if ("nothing".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.speakNothing").addStringTemplate("%nation%", player.getNationName()));
                } else {
                    logger.warning("Invalid result from askScoutSpeak: " + result);
                }
                return false;
            }
            case INDIAN_SETTLEMENT_TRIBUTE: {
                return this.moveTribute(unit, 1, direction);
            }
        }
        logger.warning("showScoutIndianSettlementDialog fail: " + (Object)((Object)act));
        return true;
    }

    private boolean moveSpy(Unit unit, Map.Direction direction) {
        this.askServer().spy(unit, direction);
        return false;
    }

    private boolean moveTrade(Unit unit, Map.Direction direction) {
        this.askClearGotoOrders(unit);
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement instanceof Colony) {
            Game game = this.freeColClient.getGame();
            Player player = unit.getOwner();
            DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.TRADE, player, settlement.getOwner(), null, 0);
            return (agreement = this.gui.showDiplomaticTradeDialog(unit, settlement, agreement, agreement.getSendMessage(player, settlement))) == null || agreement.getStatus() == DiplomaticTrade.TradeStatus.REJECT_TRADE ? true : this.moveDiplomacy(unit, direction, agreement);
        }
        if (settlement instanceof IndianSettlement) {
            return this.moveTradeIndianSettlement(unit, direction);
        }
        throw new RuntimeException("Bogus settlement: " + settlement.getId());
    }

    private boolean moveTradeIndianSettlement(Unit unit, Map.Direction direction) {
        StringTemplate baseTemplate;
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        StringTemplate template = baseTemplate = StringTemplate.template("tradeProposition.welcome").addStringTemplate("%nation%", settlement.getOwner().getNationName()).addName("%settlement%", settlement.getName());
        boolean[] results = this.askServer().openTransactionSession(unit, settlement);
        while (results != null) {
            GUI.TradeAction act;
            boolean gif;
            boolean buy = results[0] && unit.hasSpaceLeft();
            boolean sel = results[1] && unit.hasGoodsCargo();
            boolean bl = gif = results[2] && unit.hasGoodsCargo();
            if (!buy && !sel && !gif || (act = this.gui.getIndianSettlementTradeChoice(settlement, template, buy, sel, gif)) == null) break;
            StringTemplate t = null;
            switch (act) {
                case BUY: {
                    t = this.attemptBuyFromSettlement(unit, settlement);
                    if (t == null) {
                        results[0] = false;
                        template = baseTemplate;
                        break;
                    }
                    template = t;
                    break;
                }
                case SELL: {
                    t = this.attemptSellToSettlement(unit, settlement);
                    if (t == null) {
                        results[1] = false;
                        template = baseTemplate;
                        break;
                    }
                    template = t;
                    break;
                }
                case GIFT: {
                    t = this.attemptGiftToSettlement(unit, settlement);
                    if (t == null) {
                        results[2] = false;
                        template = baseTemplate;
                        break;
                    }
                    template = t;
                    break;
                }
                default: {
                    logger.warning("showIndianSettlementTradeDialog fail: " + (Object)((Object)act));
                    results = null;
                }
            }
            if (template != abortTrade) continue;
            template = baseTemplate;
        }
        this.askServer().closeTransactionSession(unit, settlement);
        if (unit.getMovesLeft() > 0) {
            this.gui.setActiveUnit(unit);
        }
        return false;
    }

    private StringTemplate tradeFailMessage(int fail, Settlement settlement, Goods goods) {
        switch (fail) {
            case 0: {
                return StringTemplate.template("trade.noTradeGoods").add("%goods%", goods.getNameKey());
            }
            case -2: {
                return StringTemplate.template("trade.noTradeHaggle");
            }
            case -3: {
                return StringTemplate.template("trade.noTradeHostile");
            }
        }
        return StringTemplate.template("trade.noTrade").addName("%settlement%", settlement.getLocationLabelFor(this.freeColClient.getMyPlayer()));
    }

    private StringTemplate attemptBuyFromSettlement(Unit unit, Settlement settlement) {
        block10: {
            GUI.BuyAction act;
            Game game = this.freeColClient.getGame();
            Player player = this.freeColClient.getMyPlayer();
            Goods goods = null;
            List<Goods> forSale = this.askServer().getGoodsForSaleInSettlement(game, unit, settlement);
            block4: while (true) {
                if (forSale.isEmpty()) {
                    return StringTemplate.template("trade.nothingToSell");
                }
                ArrayList choices = new ArrayList();
                for (Goods g : forSale) {
                    String label = Messages.message(g.getLabel(true));
                    choices.add(new ChoiceItem<Goods>(label, g));
                }
                goods = (Goods)this.gui.getChoice(true, unit.getTile(), Messages.message("buyProposition.text"), settlement, "buyProposition.nothing", choices);
                if (goods == null) break block10;
                int gold = -1;
                block6: while (true) {
                    if ((gold = this.askServer().buyProposition(unit, settlement, goods, gold)) <= 0) {
                        return this.tradeFailMessage(gold, settlement, goods);
                    }
                    boolean canBuy = player.checkGold(gold);
                    act = this.gui.getBuyChoice(unit, settlement, goods, gold, canBuy);
                    if (act == null) continue block4;
                    switch (act) {
                        case BUY: {
                            if (this.askServer().buyFromSettlement(unit, settlement, goods, gold)) {
                                this.updateControls();
                                return null;
                            }
                            return abortTrade;
                        }
                        case HAGGLE: {
                            gold = gold * 9 / 10;
                            continue block6;
                        }
                    }
                    break;
                }
                break;
            }
            logger.warning("showBuyDialog fail: " + (Object)((Object)act));
            return null;
        }
        return abortTrade;
    }

    /*
     * Exception decompiling
     */
    private StringTemplate attemptSellToSettlement(Unit unit, Settlement settlement) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 0[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StringTemplate attemptGiftToSettlement(Unit unit, Settlement settlement) {
        ArrayList choices = new ArrayList();
        for (Goods g : unit.getGoodsList()) {
            String label = Messages.message(g.getLabel(true));
            choices.add(new ChoiceItem<Goods>(label, g));
        }
        Goods goods = (Goods)this.gui.getChoice(true, unit.getTile(), Messages.message("gift.text"), settlement, "cancel", choices);
        if (goods != null && this.askServer().deliverGiftToSettlement(unit, settlement, goods)) {
            return null;
        }
        return abortTrade;
    }

    private boolean moveTribute(Unit unit, int amount, Map.Direction direction) {
        Game game = this.freeColClient.getGame();
        Player player = unit.getOwner();
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Settlement settlement = target.getSettlement();
        Player other = settlement.getOwner();
        if (settlement.getOwner().isIndian()) {
            this.askServer().demandTribute(unit, direction);
            return false;
        }
        DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.TRIBUTE, player, other, null, 0);
        agreement.add(new StanceTradeItem(game, player, other, Player.Stance.PEACE));
        agreement.add(new GoldTradeItem(game, other, player, amount));
        return this.moveDiplomacy(unit, direction, agreement);
    }

    private boolean moveUseMissionary(Unit unit, Map.Direction direction) {
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        Player player = unit.getOwner();
        boolean canEstablish = !settlement.hasMissionary();
        boolean canDenounce = !canEstablish && !settlement.hasMissionary(player);
        this.askClearGotoOrders(unit);
        GUI.MissionaryAction act = this.gui.getMissionaryChoice(unit, settlement, canEstablish, canDenounce);
        if (act == null) {
            return true;
        }
        switch (act) {
            case ESTABLISH_MISSION: 
            case DENOUNCE_HERESY: {
                if (!this.askServer().missionary(unit, direction, act == GUI.MissionaryAction.DENOUNCE_HERESY) || !settlement.hasMissionary(player)) break;
                this.gui.playSound("sound.event.missionEstablished");
                player.invalidateCanSeeTiles();
                this.displayModelMessages(false, false);
                break;
            }
            case INCITE_INDIANS: {
                ArrayList choices = new ArrayList();
                for (Player p : this.freeColClient.getGame().getLiveEuropeanPlayers(player)) {
                    String label = Messages.message(p.getNationName());
                    choices.add(new ChoiceItem<Player>(label, p));
                }
                Player enemy = (Player)this.gui.getChoice(true, unit.getTile(), Messages.message("missionarySettlement.inciteQuestion"), unit, "missionarySettlement.cancel", choices);
                if (enemy == null) {
                    return true;
                }
                int gold = this.askServer().incite(unit, direction, enemy, -1);
                if (gold < 0) break;
                if (!player.checkGold(gold)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("missionarySettlement.inciteGoldFail").add("%player%", enemy.getName()).addAmount("%amount%", gold));
                    break;
                }
                if (!this.gui.confirm(true, unit.getTile(), StringTemplate.template("missionarySettlement.inciteConfirm").add("%player%", enemy.getName()).addAmount("%amount%", gold), unit, "yes", "no") || this.askServer().incite(unit, direction, enemy, gold) < 0) break;
                this.updateControls();
                break;
            }
            default: {
                logger.warning("showUseMissionaryDialog fail");
            }
        }
        return false;
    }

    private boolean followTradeRoute(Unit unit, List<ModelMessage> messages) {
        Player player = unit.getOwner();
        TradeRoute tr = unit.getTradeRoute();
        boolean detailed = this.freeColClient.getClientOptions().getBoolean("model.option.guiShowGoodsMovement");
        boolean checkProduction = this.freeColClient.getClientOptions().getBoolean("model.option.stockAccountsForProduction");
        List<TradeRouteStop> stops = tr.getStops();
        boolean result = false;
        boolean more = true;
        LogBuilder lb = new LogBuilder(detailed && !tr.isSilent() ? 256 : -1);
        lb.mark();
        block0: while (true) {
            TradeRouteStop stop;
            if (!TradeRoute.isStopValid(unit, stop = unit.getStop())) {
                lb.add(" ", Messages.message(stop.getLabelFor("tradeRoute.invalidStop", player)));
                this.clearOrders(unit);
                result = true;
                break;
            }
            boolean atStop = Map.isSameLocation(stop.getLocation(), unit.getLocation());
            if (atStop) {
                int turns;
                int index;
                lb.mark();
                this.unloadUnitAtStop(unit, lb);
                this.loadUnitAtStop(unit, lb);
                lb.grew(" ", Messages.message(stop.getLabelFor("tradeRoute.atStop", player)));
                if (unit.getMovesLeft() <= 0) break;
                int next = index = unit.validateCurrentStop();
                do {
                    if (++next >= stops.size()) {
                        next = 0;
                    }
                    if (next == index) {
                        lb.add(" ", Messages.message("tradeRoute.wait"));
                        unit.setState(Unit.UnitState.SKIPPED);
                        break block0;
                    }
                    stop = stops.get(next);
                    if (TradeRoute.isStopValid(unit, stop)) continue;
                    lb.add(" ", Messages.message(stop.getLabelFor("tradeRoute.invalidStop", player)));
                    this.clearOrders(unit);
                    result = true;
                    break block0;
                } while (!stop.hasWork(unit, turns = !checkProduction ? 0 : unit.getTurnsToReach(stop.getLocation())));
                if (!this.askServer().setCurrentStop(unit, next)) {
                    unit.setState(Unit.UnitState.SKIPPED);
                    break;
                }
                while (true) {
                    if (++index >= stops.size()) {
                        index = 0;
                    }
                    if (index == next) continue block0;
                    TradeRouteStop skip = stops.get(index);
                    lb.add(" ", Messages.message(skip.getLabelFor("tradeRoute.skipStop", player)));
                }
            }
            if (unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED || !more) {
                lb.add(" ", Messages.message(stop.getLabelFor("tradeRoute.toStop", player)));
                break;
            }
            Location destination = stop.getLocation();
            PathNode path = unit.findPath(destination);
            if (path == null) {
                lb.add(" ", Messages.message(stop.getLabelFor("tradeRoute.pathStop", player)));
                unit.setState(Unit.UnitState.SKIPPED);
                break;
            }
            more = this.movePath(unit, path);
            if (more) continue;
            unit.setState(Unit.UnitState.SKIPPED);
        }
        if (lb.grew(new Object[0])) {
            ModelMessage m = new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "tradeRoute.prefix", unit).addName("%route%", tr.getName()).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addName("%data%", lb.toString());
            if (messages != null) {
                messages.add(m);
            } else {
                player.addModelMessage(m);
            }
        }
        if (result) {
            result = unit.getMovesLeft() > 0;
        }
        return result;
    }

    private boolean loadUnitAtStop(Unit unit, LogBuilder lb) {
        TradeLocation trl = unit.getTradeLocation();
        if (trl == null) {
            return false;
        }
        TradeRouteStop stop = unit.getStop();
        boolean ret = false;
        List<AbstractGoods> toLoad = stop.getCompactCargo();
        for (Goods g : unit.getCompactGoods()) {
            AbstractGoods ag = AbstractGoods.findByType(g.getType(), toLoad);
            if (ag != null) {
                int goodsAmount = g.getAmount();
                int amount = ag.getAmount() - goodsAmount;
                if (amount <= 0) {
                    toLoad.remove(ag);
                    continue;
                }
                ag.setAmount(amount);
                continue;
            }
            int loadable = unit.getLoadableAmount(g.getType());
            if (loadable <= 0) continue;
            toLoad.add(0, new AbstractGoods(g.getType(), loadable));
        }
        Iterator<AbstractGoods> iterator = toLoad.iterator();
        while (iterator.hasNext()) {
            AbstractGoods ag = iterator.next();
            int amount = stop.getExportAmount(ag.getType(), 0);
            if (amount <= 0) {
                if (stop.getCargo().contains(ag.getType())) {
                    int present = stop.getGoodsCount(ag.getType());
                    lb.add(" ", this.getLoadGoodsMessage(ag.getType(), 0, present, 0, -1));
                }
                iterator.remove();
                continue;
            }
            ag.setAmount(Math.min(amount, ag.getAmount()));
        }
        for (AbstractGoods ag : toLoad) {
            int demand;
            GoodsType type = ag.getType();
            ret = this.askLoadGoods(type, demand = ag.getAmount(), unit);
            if (!ret) continue;
            int present = stop.getGoodsCount(type);
            int export = stop.getExportAmount(type, 0);
            lb.add(" ", this.getLoadGoodsMessage(type, demand, present, export, demand));
        }
        return ret;
    }

    private String getLoadGoodsMessage(GoodsType type, int amount, int present, int export, int demand) {
        int more;
        String key;
        if (demand < export) {
            key = "tradeRoute.loadStopImport";
            more = export - demand;
        } else if (present > export && demand > export) {
            key = amount == 0 ? "tradeRoute.loadStopNoExport" : "tradeRoute.loadStopExport";
            more = present - export;
        } else {
            key = "tradeRoute.loadStop";
            more = -1;
        }
        return Messages.message(StringTemplate.template(key).addAmount("%amount%", amount).add("%goods%", type.getNameKey()).addAmount("%more%", more));
    }

    private boolean unloadUnitAtStop(Unit unit, LogBuilder lb) {
        TradeLocation trl = unit.getTradeLocation();
        if (trl == null) {
            return false;
        }
        TradeRouteStop stop = unit.getStop();
        List<GoodsType> goodsTypesToLoad = stop.getCargo();
        boolean ret = false;
        Game game = this.freeColClient.getGame();
        for (Goods goods : unit.getCompactGoodsList()) {
            int atStop;
            GoodsType type = goods.getType();
            if (goodsTypesToLoad.contains(type)) continue;
            int present = goods.getAmount();
            int toUnload = present;
            int amount = toUnload;
            if (amount > (atStop = trl.getImportAmount(type, 0))) {
                StringTemplate locName = ((Location)((Object)trl)).getLocationLabel();
                String overflow = Integer.toString(toUnload - atStop);
                int option = this.freeColClient.getClientOptions().getInteger("model.option.unloadOverflowResponse");
                switch (option) {
                    case 0: {
                        StringTemplate template = StringTemplate.template("traderoute.warehouseCapacity").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%colony%", locName).addName("%amount%", overflow).add("%goods%", goods.getNameKey());
                        if (this.gui.confirm(true, unit.getTile(), template, unit, "yes", "no")) break;
                        amount = atStop;
                        break;
                    }
                    case 1: {
                        amount = atStop;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        logger.warning("Illegal UNLOAD_OVERFLOW_RESPONSE: " + Integer.toString(option));
                    }
                }
            }
            if (!(ret = amount == 0 ? false : this.askUnloadGoods(type, amount, unit))) continue;
            lb.add(" ", this.getUnloadGoodsMessage(unit, type, amount, present, atStop, toUnload));
        }
        return ret;
    }

    private String getUnloadGoodsMessage(Unit unit, GoodsType type, int amount, int present, int atStop, int toUnload) {
        String key = null;
        int onBoard = unit.getGoodsCount(type);
        int unloaded = present - onBoard;
        int more = 0;
        if (unloaded < amount) {
            key = "tradeRoute.unloadStopFail";
            more = unloaded;
        } else if (amount > atStop) {
            if (amount == toUnload) {
                key = "tradeRoute.unloadStopImport";
                more = toUnload - atStop;
            } else {
                key = amount == 0 ? "tradeRoute.unloadStopNoExport" : "tradeRoute.unloadStopExport";
                more = onBoard;
            }
        } else {
            key = "tradeRoute.unloadStop";
        }
        return Messages.message(StringTemplate.template(key).addAmount("%amount%", amount).addAmount("%more%", more).add("%goods%", type.getNameKey()));
    }

    public boolean abandonColony(Colony colony) {
        boolean ret;
        Player player = this.freeColClient.getMyPlayer();
        if (!this.requireOurTurn() || colony == null || !player.owns(colony) || colony.getUnitCount() > 0) {
            return false;
        }
        Tile tile = colony.getTile();
        boolean bl = ret = this.askServer().abandonColony(colony) && !tile.hasSettlement();
        if (ret) {
            player.invalidateCanSeeTiles();
            this.gui.setActiveUnit(null);
            this.gui.setSelectedTile(tile, false);
        }
        return ret;
    }

    public boolean assignTeacher(Unit student, Unit teacher) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(this.requireOurTurn() && student != null && player.owns(student) && student.getColony() != null && student.isInColony() && teacher != null && player.owns(teacher) && student.canBeStudent(teacher) && teacher.getColony() != null && student.getColony() == teacher.getColony() && teacher.getColony().canTrain(teacher))) {
            return false;
        }
        UnitWas unitWas = new UnitWas(student);
        boolean ret = this.askServer().assignTeacher(student, teacher);
        unitWas.fireChanges();
        return ret;
    }

    public boolean assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askAssignTradeRoute(unit, tradeRoute);
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean boardShip(Unit unit, Unit carrier) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null || unit.isCarrier() || carrier == null || !carrier.canCarryUnits() || !Map.isSameLocation(unit.getLocation(), carrier.getLocation())) {
            return false;
        }
        ColonyWas colonyWas = unit.getColony() != null ? new ColonyWas(unit.getColony()) : null;
        EuropeWas europeWas = unit.isInEurope() ? new EuropeWas(unit.getOwner().getEurope()) : null;
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().embark(unit, carrier, null) && unit.getLocation() == carrier;
        if (ret) {
            this.gui.playSound("sound.event.loadCargo");
        }
        unitWas.fireChanges();
        if (colonyWas != null) {
            colonyWas.fireChanges();
        }
        if (europeWas != null) {
            europeWas.fireChanges();
        }
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean buildColony(Unit unit) {
        String warnings;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit == null) {
            return false;
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return false;
        }
        if (!unit.canBuildColony()) {
            this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("buildColony.badUnit").addName("%unit%", unit.getName()));
            return false;
        }
        Colony colony = tile.getColony();
        if (colony != null) {
            this.askServer().joinColony(unit, colony);
            this.gui.showColonyPanel(colony, unit);
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Player.NoClaimReason reason = player.canClaimToFoundSettlementReason(tile);
        switch (reason) {
            case NONE: 
            case NATIVES: {
                break;
            }
            default: {
                this.gui.showInformationMessage("noClaimReason." + reason.toString().toLowerCase(Locale.US));
                return false;
            }
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowColonyWarnings") && (warnings = tile.getBuildColonyWarnings(unit)) != null && !this.gui.confirm(true, tile, StringTemplate.label(warnings), unit, "buildColony.yes", "buildColony.no")) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = true;
        if (!(tile.getOwner() == null || player.owns(tile) || this.askClaimTile(player, tile, unit, player.getLandPrice(tile)) && player.canClaimToFoundSettlement(tile))) {
            ret = false;
        }
        String name = null;
        if (ret) {
            name = player.getSettlementName(null);
            name = this.gui.getInput(true, tile, StringTemplate.key("nameColony.text"), name, "nameColony.yes", "nameColony.no");
            if (name == null) {
                ret = false;
            } else if (name.isEmpty()) {
                this.gui.showErrorMessage("enterSomeText");
                ret = false;
            } else if (player.getSettlementByName(name) != null) {
                this.gui.showInformationMessage((FreeColObject)tile, StringTemplate.template("nameColony.notUnique").addName("%name%", name));
                ret = false;
            }
        }
        boolean bl = ret = ret && this.askServer().buildColony(name, unit) && tile.hasSettlement();
        if (ret) {
            player.invalidateCanSeeTiles();
            this.gui.setActiveUnit(null);
            this.gui.setSelectedTile(tile, false);
            this.gui.playSound("sound.event.buildingComplete");
            for (Unit unitInTile : tile.getUnitList()) {
                this.checkCashInTreasureTrain(unitInTile);
            }
        }
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public boolean buyGoods(GoodsType type, int amount, Unit carrier) {
        if (!(this.requireOurTurn() && type != null && amount > 0 && carrier != null && carrier.isInEurope() && this.freeColClient.getMyPlayer().owns(carrier))) {
            return false;
        }
        Europe europe = carrier.getOwner().getEurope();
        EuropeWas europeWas = new EuropeWas(europe);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askLoadGoods(type, amount, carrier);
        if (ret) {
            this.gui.playSound("sound.event.loadCargo");
            this.displayModelMessages(false, false);
        }
        europeWas.fireChanges();
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public boolean changeState(Unit unit, Unit.UnitState state) {
        Player enemy;
        Tile tile;
        if (!this.requireOurTurn() || unit == null || !unit.checkSetState(state)) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (state == Unit.UnitState.FORTIFYING && unit.isOffensiveUnit() && !unit.hasAbility("model.ability.piracy") && (tile = unit.getTile()) != null && tile.getOwningSettlement() != null && player != (enemy = tile.getOwningSettlement().getOwner()) && player.getStance(enemy) != Player.Stance.ALLIANCE && !this.gui.confirmHostileAction(unit, tile)) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().changeState(unit, state) && unit.getState() == state;
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean changeWorkImprovementType(Unit unit, TileImprovementType improvementType) {
        if (!this.requireOurTurn() || unit == null || improvementType == null || !unit.hasTile() || !unit.checkSetState(Unit.UnitState.IMPROVING) || improvementType.isNatural()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = true;
        Tile tile = unit.getTile();
        if (!player.owns(tile) && !this.askClaimTile(player, tile, unit, player.getLandPrice(tile))) {
            ret = false;
        }
        ret = ret && this.askServer().changeWorkImprovementType(unit, improvementType);
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(tile);
        return ret;
    }

    public boolean changeWorkType(Unit unit, GoodsType workType) {
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().changeWorkType(unit, workType) && unit.getWorkType() == workType;
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean checkCashInTreasureTrain(Unit unit) {
        boolean ret;
        if (!(this.requireOurTurn() && unit != null && unit.canCarryTreasure() && unit.canCashInTreasureTrain())) {
            return false;
        }
        Tile tile = unit.getTile();
        Europe europe = unit.getOwner().getEurope();
        if (europe != null && !unit.isInEurope()) {
            StringTemplate template;
            int fee = unit.getTransportFee();
            if (fee == 0) {
                template = StringTemplate.template("cashInTreasureTrain.free");
            } else {
                int percent = this.getSpecification().getInteger("model.option.treasureTransportFee");
                template = StringTemplate.template("cashInTreasureTrain.pay").addAmount("%fee%", percent);
            }
            if (!this.gui.confirm(true, unit.getTile(), template, unit, "cashInTreasureTrain.yes", "cashInTreasureTrain.no")) {
                return false;
            }
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().cashInTreasureTrain(unit) && unit.isDisposed();
        if (ret) {
            this.gui.playSound("sound.event.cashInTreasureTrain");
        }
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(tile);
        return ret;
    }

    public boolean chooseFoundingFather(List<FoundingFather> ffs, FoundingFather ff) {
        if (ffs == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        player.setCurrentFather(ff);
        return this.askServer().chooseFoundingFather(ffs, ff);
    }

    public boolean claimTile(Tile tile, FreeColGameObject claimant) {
        if (!this.requireOurTurn() || tile == null || claimant == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int price = (claimant instanceof Settlement ? player.canClaimForSettlement(tile) : player.canClaimForImprovement(tile)) ? 0 : player.getLandPrice(tile);
        UnitWas unitWas = claimant instanceof Unit ? new UnitWas((Unit)claimant) : null;
        boolean ret = this.askClaimTile(player, tile, claimant, price);
        if (unitWas != null) {
            unitWas.fireChanges();
        }
        this.updateControls();
        return ret;
    }

    public boolean clearGotoOrders(Unit unit) {
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askClearGotoOrders(unit);
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public boolean clearOrders(Unit unit) {
        if (!this.requireOurTurn() || unit == null || !unit.checkSetState(Unit.UnitState.ACTIVE)) {
            return false;
        }
        if (unit.getState() == Unit.UnitState.IMPROVING && !this.gui.confirm(true, unit.getTile(), StringTemplate.template("model.unit.confirmCancelWork").addAmount("%turns%", unit.getWorkTurnsLeft()), unit, "ok", "cancel")) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askClearGotoOrders(unit) && this.askServer().changeState(unit, Unit.UnitState.ACTIVE);
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public boolean clearSpeciality(Unit unit) {
        Tile tile;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitType oldType = unit.getType();
        UnitType newType = oldType.getTargetType(UnitTypeChange.ChangeType.CLEAR_SKILL, unit.getOwner());
        if (newType == null) {
            this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("clearSpeciality.impossible").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
            return false;
        }
        Tile tile2 = tile = this.gui.isShowingSubPanel() ? null : unit.getTile();
        if (!this.gui.confirm(true, tile, StringTemplate.template("clearSpeciality.areYouSure").addStringTemplate("%oldUnit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).add("%unit%", newType.getNameKey()), unit, "ok", "cancel")) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().clearSpeciality(unit) && unit.getType() == newType;
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean declareIndependence() {
        boolean ret;
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        StringTemplate declare = player.checkDeclareIndependence();
        if (declare != null) {
            this.gui.showInformationMessage(declare);
            return false;
        }
        if (player.getNewLandName() == null) {
            return false;
        }
        List<String> names = this.gui.confirmDeclaration();
        if (names == null || names.get(0) == null || names.get(0).isEmpty() || names.get(1) == null || names.get(1).isEmpty()) {
            return false;
        }
        String nationName = names.get(0);
        String countryName = names.get(1);
        boolean bl = ret = this.askServer().declareIndependence(nationName, countryName) && player.isRebel();
        if (ret) {
            this.gui.showDeclarationPanel();
        }
        this.updateControls();
        this.displayModelMessages(false, false);
        return ret;
    }

    public DiplomaticTrade diplomacy(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement) {
        Player player = this.freeColClient.getMyPlayer();
        Player otherPlayer = agreement.getOtherPlayer(player);
        StringTemplate nation = otherPlayer.getNationName();
        switch (agreement.getStatus()) {
            case ACCEPT_TRADE: {
                boolean visibilityChange = false;
                for (Colony c : agreement.getColoniesGivenBy(player)) {
                    player.removeSettlement(c);
                    visibilityChange = true;
                }
                for (Unit u : agreement.getUnitsGivenBy(player)) {
                    player.removeUnit(u);
                    visibilityChange = true;
                }
                if (visibilityChange) {
                    player.invalidateCanSeeTiles();
                }
                StringTemplate t = StringTemplate.template("negotiationDialog.offerAccepted").addStringTemplate("%nation%", nation);
                this.gui.showInformationMessage(null, t);
                break;
            }
            case REJECT_TRADE: {
                StringTemplate t = StringTemplate.template("negotiationDialog.offerRejected").addStringTemplate("%nation%", nation);
                this.gui.showInformationMessage(null, t);
                break;
            }
            case PROPOSE_TRADE: {
                String messageId = "negotiationDialog.receive." + agreement.getContext().getKey();
                StringTemplate t = StringTemplate.template(messageId).addStringTemplate("%nation%", nation);
                DiplomaticTrade ourAgreement = this.gui.showDiplomaticTradeDialog(our, other, agreement, t);
                if (ourAgreement == null) {
                    agreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                } else {
                    agreement = ourAgreement;
                }
                return agreement;
            }
            default: {
                logger.warning("Bogus trade status: " + (Object)((Object)agreement.getStatus()));
            }
        }
        return null;
    }

    public boolean disbandUnit(Unit unit) {
        Tile tile;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit.getColony() != null && !this.gui.confirmLeaveColony(unit)) {
            return false;
        }
        Tile tile2 = tile = this.gui.isShowingSubPanel() ? null : unit.getTile();
        if (!this.gui.confirm(true, tile, StringTemplate.key("disbandUnit.text"), unit, "disbandUnit.yes", "disbandUnit.no")) {
            return false;
        }
        boolean ret = this.askServer().disbandUnit(unit);
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean displayHighScores(Boolean high) {
        List<HighScore> scores = this.askServer().getHighScores();
        this.gui.showHighScoresPanel(high == null ? null : (high != false ? "highscores.yes" : "highscores.no"), scores);
        return true;
    }

    public boolean displayModelMessages(boolean allMessages) {
        return this.displayModelMessages(allMessages, false);
    }

    public boolean emigrate(Player player, int slot) {
        if (player == null || !player.isColonial() || !Europe.MigrationType.validMigrantSlot(slot)) {
            return false;
        }
        return this.askEmigrate(player.getEurope(), slot) != null;
    }

    public boolean endTurn(boolean showDialog) {
        if (!this.requireOurTurn()) {
            return false;
        }
        return this.doEndTurn(showDialog && this.freeColClient.getClientOptions().getBoolean("model.option.showEndTurnDialog"));
    }

    public boolean equipUnitForRole(Unit unit, Role role, int roleCount) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null || role == null || 0 > roleCount || roleCount > role.getMaximumCount()) {
            return false;
        }
        if (role == unit.getRole() && roleCount == unit.getRoleCount()) {
            return true;
        }
        Player player = this.freeColClient.getMyPlayer();
        Colony colony = unit.getColony();
        ColonyWas colonyWas = colony != null ? new ColonyWas(colony) : null;
        Europe europe = player.getEurope();
        EuropeWas europeWas = europe != null ? new EuropeWas(europe) : null;
        Market market = europe != null ? player.getMarket() : null;
        int price = -1;
        List<AbstractGoods> req = unit.getGoodsDifference(role, roleCount);
        if (unit.isInEurope()) {
            for (AbstractGoods ag : req) {
                GoodsType goodsType = ag.getType();
                if (player.canTrade(goodsType) || this.payArrears(goodsType)) continue;
                return false;
            }
            price = player.getEurope().priceGoods(req);
            if (price < 0 || !player.checkGold(price)) {
                return false;
            }
        } else if (colony != null) {
            for (AbstractGoods ag : req) {
                if (colony.getGoodsCount(ag.getType()) >= ag.getAmount()) continue;
                StringTemplate template = StringTemplate.template("equipUnit.impossible").addName("%colony%", colony.getName()).add("%equipment%", ag.getType().getNameKey()).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
                this.gui.showInformationMessage((FreeColObject)unit, template);
                return false;
            }
        } else {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().equipUnitForRole(unit, role, roleCount) && unit.getRole() == role;
        if (colonyWas != null) {
            colonyWas.fireChanges();
        }
        if (europeWas != null) {
            europeWas.fireChanges();
        }
        unitWas.fireChanges();
        if (market != null) {
            for (AbstractGoods ag : req) {
                GoodsType type = ag.getType();
                for (TransactionListener l : market.getTransactionListener()) {
                    if (ag.getAmount() > 0) {
                        l.logPurchase(type, ag.getAmount(), market.getCostToBuy(type));
                        continue;
                    }
                    l.logSale(type, -ag.getAmount(), market.getPaidForSale(type), player.getTax());
                }
            }
        }
        this.updateControls();
        return ret;
    }

    public boolean executeGotoOrders() {
        if (!this.requireOurTurn()) {
            return false;
        }
        return this.doExecuteGotoOrders();
    }

    public boolean firstContact(Player player, Player other, Tile tile, boolean result) {
        if (player == null || player == null || player == other || tile == null) {
            return false;
        }
        return this.askServer().firstContact(player, other, tile, result);
    }

    public java.util.Map<String, String> getClientStatistics() {
        return this.freeColClient.getGame().getStatistics();
    }

    public NationSummary getNationSummary(Player player) {
        if (player == null) {
            return null;
        }
        return this.askServer().getNationSummary(player);
    }

    public TradeRoute getNewTradeRoute(Player player) {
        if (player == null) {
            return null;
        }
        int n = player.getTradeRoutes().size();
        if (this.askServer().getNewTradeRoute() && player.getTradeRoutes().size() == n + 1) {
            return player.getTradeRoutes().get(n);
        }
        return null;
    }

    public List<AbstractUnit> getREFUnits() {
        return !this.requireOurTurn() ? Collections.emptyList() : this.askServer().getREFUnits();
    }

    public java.util.Map<String, String> getServerStatistics() {
        return this.askServer().getStatistics();
    }

    public boolean goToTile(Unit unit, Tile tile) {
        if (!this.requireOurTurn() || unit == null || !this.freeColClient.getMyPlayer().owns(unit)) {
            return false;
        }
        if (!this.gui.confirmClearTradeRoute(unit)) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askSetDestination(unit, tile);
        if (ret) {
            this.moveToDestination(unit, null);
        }
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean ignoreMessage(ModelMessage message, boolean flag) {
        String otherkey;
        Iterator<String> i$;
        if (message == null) {
            return false;
        }
        String key = message.getSourceId();
        if (message.getTemplateType() == StringTemplate.TemplateType.TEMPLATE && (i$ = message.getKeys().iterator()).hasNext() && "%goods%".equals(otherkey = i$.next())) {
            key = key + otherkey;
        }
        if (flag) {
            Turn turn = this.freeColClient.getGame().getTurn();
            this.startIgnoringMessage(key, turn.getNumber());
        } else {
            this.stopIgnoringMessage(key);
        }
        return true;
    }

    public boolean indianDemand(Unit unit, Colony colony, GoodsType type, int amount) {
        boolean accepted;
        ModelMessage m;
        Player player;
        block14: {
            String nation;
            int opt;
            block13: {
                if (unit == null || colony == null) {
                    return false;
                }
                player = this.freeColClient.getMyPlayer();
                opt = this.freeColClient.getClientOptions().getInteger("model.option.indianDemandResponse");
                m = null;
                nation = Messages.message(unit.getOwner().getNationName());
                if (type != null) break block13;
                switch (opt) {
                    case 0: {
                        accepted = this.gui.confirm(true, colony.getTile(), StringTemplate.template("indianDemand.gold.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount), unit, "indianDemand.gold.yes", "indianDemand.gold.no");
                        break block14;
                    }
                    case 1: {
                        m = new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount);
                        accepted = true;
                        break block14;
                    }
                    case 2: {
                        m = new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount);
                        accepted = false;
                        break block14;
                    }
                    default: {
                        throw new RuntimeException("Impossible option value.");
                    }
                }
            }
            switch (opt) {
                case 0: {
                    if (type.isFoodType()) {
                        accepted = this.gui.confirm(true, colony.getTile(), StringTemplate.template("indianDemand.food.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount), unit, "indianDemand.food.yes", "indianDemand.food.no");
                        break;
                    }
                    accepted = this.gui.confirm(true, colony.getTile(), StringTemplate.template("indianDemand.other.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount).add("%goods%", type.getNameKey()), unit, "indianDemand.other.yes", "indianDemand.other.no");
                    break;
                }
                case 1: {
                    m = type.isFoodType() ? new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount) : new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount).add("%goods%", type.getNameKey());
                    accepted = true;
                    break;
                }
                case 2: {
                    m = type.isFoodType() ? new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount) : new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount).add("%goods%", type.getNameKey());
                    accepted = false;
                    break;
                }
                default: {
                    throw new RuntimeException("Impossible option value.");
                }
            }
        }
        if (m != null) {
            player.addModelMessage(m);
            this.displayModelMessages(false, false);
        }
        return accepted;
    }

    public boolean leaveShip(Unit unit) {
        boolean ret;
        Unit carrier;
        if (!this.requireOurTurn() || unit == null || (carrier = unit.getCarrier()) == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().disembark(unit) && unit.getLocation() != carrier;
        if (ret) {
            this.checkCashInTreasureTrain(unit);
        }
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean loadCargo(Goods goods, Unit carrier) {
        if (!this.requireOurTurn() || goods == null || goods.getAmount() <= 0 || carrier == null || !carrier.isCarrier()) {
            return false;
        }
        if (carrier.isInEurope()) {
            return this.buyGoods(goods.getType(), goods.getAmount(), carrier);
        }
        Colony colony = carrier.getColony();
        if (colony == null) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askLoadGoods(goods.getType(), goods.getAmount(), carrier);
        if (ret) {
            this.gui.playSound("sound.event.loadCargo");
        }
        colonyWas.fireChanges();
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public void loadGame() {
        File file = this.gui.showLoadDialog(FreeColDirectories.getSaveDirectory());
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            this.gui.showErrorMessage("fileNotFound");
            return;
        }
        if (this.freeColClient.isInGame() && !this.gui.confirmStopGame()) {
            return;
        }
        this.freeColClient.getConnectController().quitGame(true);
        this.turnReportMessages.clear();
        this.gui.setActiveUnit(null);
        this.gui.removeInGameComponents();
        FreeColDirectories.setSavegameFile(file);
        this.freeColClient.getConnectController().startSavedGame(file, null);
    }

    public boolean lootCargo(Unit unit, List<Goods> goods, String defenderId) {
        if (unit == null || goods == null || goods.isEmpty() || defenderId == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().loot(unit, defenderId, goods);
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public boolean monarchAction(Monarch.MonarchAction action, boolean accept) {
        if (action == null) {
            return false;
        }
        switch (action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: 
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                return this.askServer().answerMonarch(action, accept);
            }
        }
        return false;
    }

    public boolean moveTo(Unit unit, Location destination) {
        if (!this.requireOurTurn() || unit == null || destination == null) {
            return false;
        }
        if (destination instanceof Europe) {
            if (unit.isInEurope()) {
                this.gui.playSound("sound.event.illegalMove");
                return false;
            }
        } else if (destination instanceof Map) {
            if (unit.hasTile() && unit.getTile().getMap() == destination) {
                this.gui.playSound("sound.event.illegalMove");
                return false;
            }
        } else if (destination instanceof Settlement) {
            if (unit.hasTile()) {
                this.gui.playSound("sound.event.illegalMove");
                return false;
            }
        } else {
            return false;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.autoloadEmigrants") && unit.isInEurope()) {
            for (Unit u : unit.getOwner().getEurope().getUnitList()) {
                if (u.isNaval() || u.getState() != Unit.UnitState.SENTRY || !unit.canAdd(u)) continue;
                this.boardShip(u, unit);
            }
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().moveTo(unit, destination);
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean moveUnit(Unit unit, Map.Direction direction) {
        if (!this.requireOurTurn() || unit == null || direction == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        ColonyWas colonyWas = unit.getColony() == null ? null : new ColonyWas(unit.getColony());
        unit.setState(Unit.UnitState.ACTIVE);
        boolean ret = this.askClearGotoOrders(unit) && this.moveDirection(unit, direction, true);
        unitWas.fireChanges();
        if (colonyWas != null) {
            colonyWas.fireChanges();
        }
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean moveTileCursor(Map.Direction direction) {
        if (direction == null) {
            return false;
        }
        Tile tile = this.gui.getSelectedTile();
        if (tile == null) {
            return false;
        }
        Tile newTile = tile.getNeighbourOrNull(direction);
        if (newTile == null) {
            return false;
        }
        this.gui.setSelectedTile(newTile, false);
        return true;
    }

    public boolean nameNewLand(Unit unit, String name) {
        if (unit == null || name == null) {
            return false;
        }
        if (!this.askServer().newLandName(unit, name)) {
            return false;
        }
        Player player = unit.getOwner();
        StringTemplate t = StringTemplate.template("event.firstLanding").addName("%name%", name);
        this.gui.showEventPanel(Messages.message(t), "EventImage.firstLanding", null);
        String key = FreeColActionUI.getHumanKeyStrokeText(this.freeColClient.getActionManager().getFreeColAction("buildColonyAction").getAccelerator());
        player.addModelMessage(new ModelMessage(ModelMessage.MessageType.TUTORIAL, "tutorial.buildColony", player).addName("%build_colony_key%", key).add("%build_colony_menu_item%", "buildColonyAction.name").add("%orders_menu_item%", "menuBar.orders"));
        this.displayModelMessages(false, false);
        return true;
    }

    public boolean nameNewRegion(Tile tile, Unit unit, Region region, String name) {
        if (tile == null || unit == null || region == null) {
            return false;
        }
        return this.askServer().newRegionName(region, tile, unit, name);
    }

    public boolean newTurn(int turn) {
        Turn currTurn;
        Game game = this.freeColClient.getGame();
        Player player = this.freeColClient.getMyPlayer();
        if (turn < 0) {
            logger.warning("Bad turn in newTurn: " + turn);
            return false;
        }
        game.setTurn(new Turn(turn));
        boolean alert = this.freeColClient.getClientOptions().getBoolean("model.option.audioAlerts");
        if (alert) {
            this.gui.playSound("sound.event.alertSound");
        }
        if ((currTurn = game.getTurn()).isFirstSeasonTurn()) {
            player.addModelMessage(new ModelMessage("twoTurnsPerYear", player).addStringTemplate("%year%", currTurn.getLabel()));
        }
        return true;
    }

    public boolean nextActiveUnit() {
        if (!this.requireOurTurn()) {
            return false;
        }
        this.updateActiveUnit(null);
        return true;
    }

    public boolean nextModelMessage() {
        return this.displayModelMessages(false, false);
    }

    public boolean payArrears(GoodsType type) {
        if (!this.requireOurTurn() || type == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int arrears = player.getArrears(type);
        if (arrears <= 0) {
            return false;
        }
        if (!player.checkGold(arrears)) {
            this.gui.showInformationMessage(StringTemplate.template("model.europe.cantPayArrears").addAmount("%amount%", arrears));
            return false;
        }
        boolean ret = this.gui.confirm(true, null, StringTemplate.template("model.europe.payArrears").addAmount("%amount%", arrears), type, "ok", "cancel") && this.askServer().payArrears(type) && player.canTrade(type);
        this.updateControls();
        return ret;
    }

    public boolean payForBuilding(Colony colony) {
        if (!this.requireOurTurn() || colony == null) {
            return false;
        }
        if (!this.getSpecification().getBoolean("model.option.payForBuilding")) {
            this.gui.showErrorMessage("payForBuilding.disabled");
            return false;
        }
        if (!colony.canPayToFinishBuilding()) {
            this.gui.showErrorMessage("notEnoughGold");
            return false;
        }
        int price = colony.getPriceForBuilding();
        if (!this.gui.confirm(true, null, StringTemplate.template("payForBuilding.text").addAmount("%amount%", price), colony, "payForBuilding.yes", "payForBuilding.no")) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        boolean ret = this.askServer().payForBuilding(colony) && colony.getPriceForBuilding() == 0;
        colonyWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public boolean putOutsideColony(Unit unit) {
        Colony colony;
        if (!this.requireOurTurn() || unit == null || (colony = unit.getColony()) == null) {
            return false;
        }
        if (!this.gui.confirmLeaveColony(unit)) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().putOutsideColony(unit) && unit.getLocation() == colony.getTile();
        colonyWas.fireChanges();
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public void reconnect() {
        if (this.gui.confirm("reconnect.text", "reconnect.quit", "reconnect.yes")) {
            logger.finest("Reconnect quit.");
            this.freeColClient.quit();
        } else {
            logger.finest("Reconnect accepted.");
            this.freeColClient.getConnectController().reconnect();
        }
    }

    public boolean recruitUnitInEurope(int index) {
        if (!this.requireOurTurn() || !Europe.MigrationType.validMigrantIndex(index)) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.isColonial()) {
            return false;
        }
        if (!player.checkGold(player.getRecruitPrice())) {
            this.gui.showErrorMessage("notEnoughGold");
            return false;
        }
        Unit newUnit = this.askEmigrate(player.getEurope(), Europe.MigrationType.migrantIndexToSlot(index));
        if (newUnit != null) {
            player.setNextActiveUnit(newUnit);
            this.gui.setActiveUnit(newUnit);
            this.updateControls();
        }
        return newUnit != null;
    }

    public boolean rename(Nameable object) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(object instanceof Ownable) || !player.owns((Ownable)((Object)object))) {
            return false;
        }
        String name = null;
        if (object instanceof Colony) {
            Colony colony = (Colony)object;
            name = this.gui.getInput(true, colony.getTile(), StringTemplate.key("renameColony.text"), colony.getName(), "renameColony.yes", "renameColony.no");
            if (name == null) {
                return false;
            }
            if (name.isEmpty()) {
                this.gui.showErrorMessage("enterSomeText");
                return false;
            }
            if (colony.getName().equals(name)) {
                return false;
            }
            if (player.getSettlementByName(name) != null) {
                this.gui.showInformationMessage((FreeColObject)((Colony)object), StringTemplate.template("nameColony.notUnique").addName("%name%", name));
                return false;
            }
        } else if (object instanceof Unit) {
            Unit unit = (Unit)object;
            name = this.gui.getInput(true, unit.getTile(), StringTemplate.key("renameUnit.text"), unit.getName(), "renameUnit.yes", "renameUnit.no");
            if (name == null) {
                return false;
            }
        } else {
            logger.warning("Tried to rename an unsupported Nameable: " + object);
            return false;
        }
        return this.askServer().rename((FreeColGameObject)((Object)object), name);
    }

    public boolean saveGame() {
        if (!this.freeColClient.canSaveCurrentGame()) {
            return false;
        }
        Game game = this.freeColClient.getGame();
        if (game == null) {
            return false;
        }
        String fileName = this.getSaveGameString(game);
        File file = this.gui.showSaveDialog(FreeColDirectories.getSaveDirectory(), fileName);
        if (file == null) {
            return false;
        }
        boolean confirm = this.freeColClient.getClientOptions().getBoolean("model.option.confirmSaveOverwrite");
        if (!confirm || !file.exists() || this.gui.confirm("saveConfirmationDialog.areYouSure.text", "ok", "cancel")) {
            FreeColDirectories.setSaveDirectory(file.getParentFile());
            return this.saveGame(file);
        }
        return false;
    }

    public boolean selectDestination(Unit unit) {
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (!this.gui.confirmClearTradeRoute(unit)) {
            return false;
        }
        Location destination = this.gui.showSelectDestinationDialog(unit);
        if (destination == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askSetDestination(unit, destination);
        if (ret) {
            if (destination instanceof Europe) {
                if (unit.hasTile() && unit.getTile().isDirectlyHighSeasConnected()) {
                    this.moveTo(unit, destination);
                } else {
                    this.moveToDestination(unit, null);
                }
            } else if (unit.isInEurope()) {
                this.moveTo(unit, destination);
            } else {
                this.moveToDestination(unit, null);
            }
        }
        unitWas.fireChanges();
        this.updateControls();
        this.updateActiveUnit(null);
        return ret;
    }

    public boolean sellGoods(Goods goods) {
        if (!this.requireOurTurn() || goods == null || !(goods.getLocation() instanceof Unit)) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit carrier = (Unit)goods.getLocation();
        Europe europe = player.getEurope();
        EuropeWas europeWas = new EuropeWas(europe);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askUnloadGoods(goods.getType(), goods.getAmount(), carrier);
        if (ret) {
            this.gui.playSound("sound.event.sellCargo");
            this.displayModelMessages(false, false);
        }
        europeWas.fireChanges();
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public boolean sendChat(String chat) {
        if (chat == null) {
            return false;
        }
        return this.askServer().chat(this.freeColClient.getMyPlayer(), chat);
    }

    public boolean setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        if (!this.requireOurTurn() || colony == null || buildQueue == null) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        boolean ret = this.askServer().setBuildQueue(colony, buildQueue);
        colonyWas.fireChanges();
        return ret;
    }

    public boolean setCurrentPlayer(Player player) {
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && this.freeColClient.currentPlayerIsMyPlayer()) {
            this.gui.closeMenus();
        }
        FreeColDebugger.finishDebugRun(this.freeColClient, false);
        Game game = this.freeColClient.getGame();
        game.setCurrentPlayer(player);
        if (this.freeColClient.getMyPlayer().equals(player)) {
            if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.DESYNC) && DebugUtils.checkDesyncAction(this.freeColClient)) {
                this.freeColClient.getConnectController().reconnect();
                return false;
            }
            player.removeDisplayedModelMessages();
            this.displayModelMessages(true, true);
            player.invalidateCanSeeTiles();
            if (this.freeColClient.getFreeColServer() != null && game.getTurn().getNumber() > 0) {
                this.autoSaveGame();
            }
            Europe europe = player.getEurope();
            if (player.hasAbility("model.ability.selectRecruit")) {
                if (player.checkEmigrate()) {
                    if (CollectionUtils.allSame(europe.getRecruitables())) {
                        this.askEmigrate(europe, Europe.MigrationType.getDefaultSlot());
                    } else {
                        this.gui.showEmigrationDialog(player, Europe.MigrationType.getDefaultSlot(), false);
                    }
                }
            } else {
                while (player.checkEmigrate()) {
                    this.askEmigrate(europe, Europe.MigrationType.getUnspecificSlot());
                }
            }
            try {
                List<Settlement> settlements = player.getSettlements();
                Tile defTile = (settlements.isEmpty() ? player.getEntryLocation().getTile() : settlements.get(0).getTile()).getSafeTile(null, null);
                player.resetIterators();
                this.updateActiveUnit(defTile);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Client new turn failure for " + player, e);
            }
            if (!this.freeColClient.isSinglePlayer()) {
                this.gui.playSound("sound.anthem." + player.getNationId());
            }
        }
        this.updateControls();
        return true;
    }

    public boolean setDead(Player dead) {
        if (dead == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (player == dead) {
            FreeColDebugger.finishDebugRun(this.freeColClient, true);
            if (this.freeColClient.isSinglePlayer()) {
                if (player.getPlayerType() != Player.PlayerType.RETIRED) {
                    if (player.getPlayerType() != Player.PlayerType.UNDEAD && this.gui.confirm("defeatedSinglePlayer.text", "defeatedSinglePlayer.yes", "defeatedSinglePlayer.no")) {
                        this.freeColClient.askServer().enterRevengeMode();
                    } else {
                        this.freeColClient.quit();
                    }
                }
            } else if (!this.gui.confirm("defeated.text", "defeated.yes", "defeated.no")) {
                this.freeColClient.quit();
            }
        } else {
            player.setStance(dead, null);
        }
        return true;
    }

    public void setGameConnected() {
        Player player = this.freeColClient.getMyPlayer();
        if (player != null) {
            player.refilterModelMessages(this.freeColClient.getClientOptions());
        }
        this.updateControls();
    }

    public boolean setGoodsLevels(Colony colony, GoodsType goodsType) {
        if (colony == null || goodsType == null) {
            return false;
        }
        return this.askServer().setGoodsLevels(colony, colony.getExportData(goodsType));
    }

    public boolean setInDebugMode() {
        FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
        this.updateControls();
        return true;
    }

    public boolean setStance(Player.Stance stance, Player first, Player second) {
        if (stance == null || first == null || second == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Player.Stance old = first.getStance(second);
        try {
            first.setStance(second, stance);
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, "Illegal stance transition", e);
            return false;
        }
        if (player == first && old == Player.Stance.UNCONTACTED) {
            this.gui.playSound("sound.event.meet." + second.getNationId());
        }
        return true;
    }

    public boolean setTradeRoutes(List<TradeRoute> routes) {
        if (routes == null) {
            return false;
        }
        return this.askServer().setTradeRoutes(routes);
    }

    public boolean skipUnit(Unit unit) {
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit.getState() == Unit.UnitState.SKIPPED) {
            return true;
        }
        unit.setState(Unit.UnitState.SKIPPED);
        this.updateActiveUnit(null);
        return true;
    }

    public boolean trainUnitInEurope(UnitType unitType) {
        Europe europe;
        if (!this.requireOurTurn() || unitType == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.checkGold((europe = player.getEurope()).getUnitPrice(unitType))) {
            this.gui.showErrorMessage("notEnoughGold");
            return false;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        boolean ret = false;
        if (this.askServer().trainUnitInEurope(unitType)) {
            Unit newUnit = europeWas.getNewUnit();
            europeWas.fireChanges();
            if (newUnit != null) {
                player.setNextActiveUnit(newUnit);
                this.gui.setActiveUnit(newUnit);
                ret = true;
            }
            this.updateControls();
        }
        return ret;
    }

    public boolean unload(Unit unit) {
        if (!this.requireOurTurn() || unit == null || !unit.isCarrier()) {
            return false;
        }
        boolean ret = true;
        boolean inEurope = unit.isInEurope();
        Colony colony = unit.getColony();
        if (colony != null) {
            for (Unit u : unit.getUnitList()) {
                ret = this.leaveShip(u) && ret;
            }
            for (Goods goods : unit.getGoodsList()) {
                ret = this.unloadCargo(goods, false) && ret;
            }
        } else if (unit.isInEurope()) {
            Player player = this.freeColClient.getMyPlayer();
            for (Goods goods : unit.getCompactGoodsList()) {
                if (!player.canTrade(goods.getType())) continue;
                ret = this.sellGoods(goods) && ret;
            }
            if (unit.hasGoodsCargo()) {
                this.gui.showDumpCargoDialog(unit);
                return false;
            }
        } else {
            for (Goods goods : unit.getGoodsList()) {
                ret = this.unloadCargo(goods, false) && ret;
            }
        }
        return ret;
    }

    public boolean unloadCargo(Goods goods, boolean dump) {
        if (!this.requireOurTurn() || goods == null || goods.getAmount() <= 0 || !(goods.getLocation() instanceof Unit)) {
            return false;
        }
        Unit carrier = (Unit)goods.getLocation();
        if (carrier.isInEurope()) {
            return this.sellGoods(goods);
        }
        Colony colony = carrier.getColony();
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askUnloadGoods(goods.getType(), goods.getAmount(), carrier);
        if (ret && !dump) {
            this.gui.playSound("sound.event.unloadCargo");
        }
        if (colonyWas != null) {
            colonyWas.fireChanges();
        }
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    public boolean updateTradeRoute(TradeRoute route) {
        if (route == null) {
            return false;
        }
        return this.askServer().updateTradeRoute(route);
    }

    public boolean victory(Boolean quit) {
        if (quit.booleanValue()) {
            this.freeColClient.quit();
        } else {
            this.askServer().continuePlaying();
        }
        return true;
    }

    public boolean waitUnit() {
        this.gui.setActiveUnit(null);
        this.updateActiveUnit(null);
        return true;
    }

    public boolean work(Unit unit, WorkLocation workLocation) {
        StringTemplate template;
        if (!this.requireOurTurn() || unit == null || workLocation == null) {
            return false;
        }
        if (unit.getStudent() != null && (template = unit.getAbandonEducationMessage(false)) != null && !this.gui.confirm(true, unit.getTile(), template, unit, "abandonTeaching.yes", "abandonTeaching.no")) {
            return false;
        }
        Colony colony = workLocation.getColony();
        if (workLocation instanceof ColonyTile) {
            Tile tile = ((ColonyTile)workLocation).getWorkTile();
            if (tile.hasLostCityRumour()) {
                this.gui.showInformationMessage("tileHasRumour");
                return false;
            }
            if (!unit.getOwner().owns(tile) && !this.claimTile(tile, colony)) {
                return false;
            }
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().work(unit, workLocation) && unit.getLocation() == workLocation;
        colonyWas.fireChanges();
        unitWas.fireChanges();
        this.updateControls();
        return ret;
    }

    private static enum MoveMode {
        NEXT_ACTIVE_UNIT,
        EXECUTE_GOTO_ORDERS,
        END_TURN;


        public MoveMode maximize(MoveMode m) {
            return this.ordinal() < m.ordinal() ? m : this;
        }
    }
}

