/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.avg;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalAvg
extends InternalNumericMetricsAggregation.SingleValue
implements Avg {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("avg");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalAvg readResult(StreamInput in) throws IOException {
            InternalAvg result = new InternalAvg();
            result.readFrom(in);
            return result;
        }
    };
    private double sum;
    private long count;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalAvg() {
    }

    public InternalAvg(String name, double sum, long count) {
        super(name);
        this.sum = sum;
        this.count = count;
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.sum / (double)this.count;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAvg reduce(InternalAggregation.ReduceContext reduceContext) {
        long count = 0L;
        double sum = 0.0;
        for (InternalAggregation aggregation : reduceContext.aggregations()) {
            count += ((InternalAvg)aggregation).count;
            sum += ((InternalAvg)aggregation).sum;
        }
        return new InternalAvg(this.getName(), sum, count);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.sum = in.readDouble();
        this.count = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeDouble(this.sum);
        out.writeVLong(this.count);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(InternalAggregation.CommonFields.VALUE, this.count != 0L ? Double.valueOf(this.getValue()) : null);
        if (this.count != 0L && this.valueFormatter != null) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(this.getValue()));
        }
        return builder;
    }
}

