/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.script;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestResponseListener;

public class RestGetIndexedScriptAction
extends BaseRestHandler {
    @Inject
    public RestGetIndexedScriptAction(Settings settings, RestController controller, Client client) {
        this(settings, controller, true, client);
    }

    protected RestGetIndexedScriptAction(Settings settings, RestController controller, boolean registerDefaultHandlers, Client client) {
        super(settings, controller, client);
        if (registerDefaultHandlers) {
            controller.registerHandler(RestRequest.Method.GET, "/_scripts/{lang}/{id}", this);
        }
    }

    protected String getScriptLang(RestRequest request) {
        return request.param("lang");
    }

    protected String getScriptFieldName() {
        return "script";
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        GetIndexedScriptRequest getRequest = new GetIndexedScriptRequest(this.getScriptLang(request), request.param("id"));
        getRequest.version(request.paramAsLong("version", getRequest.version()));
        getRequest.versionType(VersionType.fromString(request.param("version_type"), getRequest.versionType()));
        client.getIndexedScript(getRequest, (ActionListener<GetIndexedScriptResponse>)new RestResponseListener<GetIndexedScriptResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexedScriptResponse response) throws Exception {
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
                if (!response.isExists()) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                try {
                    String script = response.getScript();
                    builder.startObject();
                    builder.field(RestGetIndexedScriptAction.this.getScriptFieldName(), script);
                    builder.endObject();
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
                catch (IOException | ClassCastException e) {
                    throw new ElasticsearchIllegalStateException("Unable to parse " + response.getScript() + " as json", e);
                }
            }
        });
    }
}

