/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStream;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.FsTranslogFile;
import org.elasticsearch.index.translog.fs.RafReference;

public class BufferingFsTranslogFile
implements FsTranslogFile {
    private final long id;
    private final ShardId shardId;
    private final RafReference raf;
    private final TranslogStream translogStream;
    private final int headerSize;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile int operationCounter;
    private volatile long lastPosition;
    private volatile long lastWrittenPosition;
    private volatile long lastSyncPosition = 0L;
    private byte[] buffer;
    private int bufferCount;
    private WrapperOutputStream bufferOs = new WrapperOutputStream();

    public BufferingFsTranslogFile(ShardId shardId, long id, RafReference raf, int bufferSize) throws IOException {
        this.shardId = shardId;
        this.id = id;
        this.raf = raf;
        this.buffer = new byte[bufferSize];
        raf.raf().setLength(0L);
        this.translogStream = TranslogStreams.translogStreamFor(this.raf.file());
        this.headerSize = this.translogStream.writeHeader(raf.channel());
        this.lastPosition += (long)this.headerSize;
        this.lastWrittenPosition += (long)this.headerSize;
        this.lastSyncPosition += (long)this.headerSize;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int estimatedNumberOfOperations() {
        return this.operationCounter;
    }

    @Override
    public long translogSizeInBytes() {
        return this.lastWrittenPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Translog.Location add(BytesReference data) throws IOException {
        this.rwl.writeLock().lock();
        try {
            ++this.operationCounter;
            long position = this.lastPosition;
            if (data.length() >= this.buffer.length) {
                this.flushBuffer();
                data.writeTo(this.raf.channel());
                this.lastWrittenPosition += (long)data.length();
                this.lastPosition += (long)data.length();
                Translog.Location location = new Translog.Location(this.id, position, data.length());
                return location;
            }
            if (data.length() > this.buffer.length - this.bufferCount) {
                this.flushBuffer();
            }
            data.writeTo(this.bufferOs);
            this.lastPosition += (long)data.length();
            Translog.Location location = new Translog.Location(this.id, position, data.length());
            return location;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private void flushBuffer() throws IOException {
        assert (((ReentrantReadWriteLock.WriteLock)this.rwl.writeLock()).isHeldByCurrentThread());
        if (this.bufferCount > 0) {
            Channels.writeToChannel(this.buffer, 0, this.bufferCount, (WritableByteChannel)this.raf.channel());
            this.lastWrittenPosition += (long)this.bufferCount;
            this.bufferCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(Translog.Location location) throws IOException {
        this.rwl.readLock().lock();
        try {
            if (location.translogLocation >= this.lastWrittenPosition) {
                byte[] data = new byte[location.size];
                System.arraycopy(this.buffer, (int)(location.translogLocation - this.lastWrittenPosition), data, 0, location.size);
                byte[] byArray = data;
                return byArray;
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return Channels.readFromFileChannel(this.raf.channel(), location.translogLocation, location.size);
    }

    /*
     * Loose catch block
     */
    @Override
    public FsChannelSnapshot snapshot() throws TranslogException {
        if (this.raf.increaseRefCount()) {
            boolean success = false;
            try {
                this.rwl.writeLock().lock();
                try {
                    this.flushBuffer();
                    FsChannelSnapshot snapshot = new FsChannelSnapshot(this.id, this.raf, this.lastWrittenPosition, this.operationCounter);
                    snapshot.seekTo(this.headerSize);
                    success = true;
                    FsChannelSnapshot fsChannelSnapshot = snapshot;
                    return fsChannelSnapshot;
                }
                catch (Exception e) {
                    throw new TranslogException(this.shardId, "exception while creating snapshot", (Throwable)e);
                }
                finally {
                    this.rwl.writeLock().unlock();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!success) {
                    this.raf.decreaseRefCount(false);
                }
            }
        }
        return null;
    }

    @Override
    public boolean syncNeeded() {
        return this.lastPosition != this.lastSyncPosition;
    }

    @Override
    public TranslogStream getStream() {
        return this.translogStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        if (!this.syncNeeded()) {
            return;
        }
        this.rwl.writeLock().lock();
        try {
            this.flushBuffer();
            this.lastSyncPosition = this.lastPosition;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.raf.channel().force(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean delete) {
        block6: {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            try {
                if (delete) break block6;
                try {
                    this.sync();
                }
                catch (Exception e) {
                    throw new TranslogException(this.shardId, "failed to sync on close", (Throwable)e);
                }
            }
            finally {
                this.raf.decreaseRefCount(delete);
            }
        }
    }

    @Override
    public void reuse(FsTranslogFile other) {
        if (!(other instanceof BufferingFsTranslogFile)) {
            return;
        }
        this.rwl.writeLock().lock();
        try {
            this.flushBuffer();
            this.buffer = ((BufferingFsTranslogFile)other).buffer;
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to flush", (Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void updateBufferSize(int bufferSize) {
        this.rwl.writeLock().lock();
        try {
            if (this.buffer.length == bufferSize) {
                return;
            }
            this.flushBuffer();
            this.buffer = new byte[bufferSize];
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to flush", (Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public String toString() {
        return "buffered{id=" + this.id + ", operationCounter=" + this.operationCounter + '}';
    }

    class WrapperOutputStream
    extends OutputStream {
        WrapperOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ((BufferingFsTranslogFile)BufferingFsTranslogFile.this).buffer[((BufferingFsTranslogFile)BufferingFsTranslogFile.this).bufferCount++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.arraycopy(b, off, BufferingFsTranslogFile.this.buffer, BufferingFsTranslogFile.this.bufferCount, len);
            BufferingFsTranslogFile.this.bufferCount += len;
        }
    }
}

