/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.morelikethis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Fields;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.termvector.MultiTermVectorsItemResponse;
import org.elasticsearch.action.termvector.MultiTermVectorsRequest;
import org.elasticsearch.action.termvector.MultiTermVectorsResponse;
import org.elasticsearch.action.termvector.TermVectorResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class MoreLikeThisFetchService
extends AbstractComponent {
    private final Client client;

    @Inject
    public MoreLikeThisFetchService(Client client, Settings settings) {
        super(settings);
        this.client = client;
    }

    public Fields[] fetch(List<MultiGetRequest.Item> items) throws IOException {
        MultiTermVectorsRequest request = new MultiTermVectorsRequest();
        for (MultiGetRequest.Item item : items) {
            request.add(item);
        }
        ArrayList<Fields> likeFields = new ArrayList<Fields>();
        MultiTermVectorsResponse responses = this.client.multiTermVectors(request).actionGet();
        for (MultiTermVectorsItemResponse response : responses) {
            TermVectorResponse getResponse;
            if (response.isFailed() || !(getResponse = response.getResponse()).isExists()) continue;
            likeFields.add(getResponse.getFields());
        }
        return likeFields.toArray(Fields.EMPTY_ARRAY);
    }
}

