/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.fixedbitset;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.cache.fixedbitset.ShardFixedBitSetFilterCache;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.service.InternalIndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public class FixedBitSetFilterCache
extends AbstractIndexComponent
implements AtomicReader.CoreClosedListener,
RemovalListener<Object, Cache<Filter, Value>>,
CloseableComponent {
    public static final String LOAD_RANDOM_ACCESS_FILTERS_EAGERLY = "index.load_fixed_bitset_filters_eagerly";
    private final boolean loadRandomAccessFiltersEagerly;
    private final Cache<Object, Cache<Filter, Value>> loadedFilters;
    private final FixedBitSetFilterWarmer warmer;
    private IndexService indexService;
    private IndicesWarmer indicesWarmer;

    @Inject
    public FixedBitSetFilterCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.loadRandomAccessFiltersEagerly = indexSettings.getAsBoolean(LOAD_RANDOM_ACCESS_FILTERS_EAGERLY, (Boolean)true);
        this.loadedFilters = CacheBuilder.newBuilder().removalListener(this).build();
        this.warmer = new FixedBitSetFilterWarmer();
    }

    @Inject(optional=true)
    public void setIndicesWarmer(IndicesWarmer indicesWarmer) {
        this.indicesWarmer = indicesWarmer;
    }

    public void setIndexService(InternalIndexService indexService) {
        this.indexService = indexService;
        this.indicesWarmer.addListener(this.warmer);
    }

    public FixedBitSetFilter getFixedBitSetFilter(Filter filter) {
        assert (filter != null);
        assert (!(filter instanceof NoCacheFilter));
        return new FixedBitSetFilterWrapper(filter);
    }

    public void onClose(Object ownerCoreCacheKey) {
        this.loadedFilters.invalidate(ownerCoreCacheKey);
    }

    @Override
    public void close() throws ElasticsearchException {
        this.indicesWarmer.removeListener(this.warmer);
        this.clear("close");
    }

    public void clear(String reason) {
        this.logger.debug("Clearing all FixedBitSets because [{}]", reason);
        this.loadedFilters.invalidateAll();
        this.loadedFilters.cleanUp();
    }

    private FixedBitSet getAndLoadIfNotPresent(final Filter filter, final AtomicReaderContext context) throws IOException, ExecutionException {
        Object coreCacheReader = context.reader().getCoreCacheKey();
        final ShardId shardId = ShardUtils.extractShardId(context.reader());
        Cache<Filter, Value> filterToFbs = this.loadedFilters.get(coreCacheReader, new Callable<Cache<Filter, Value>>(){

            @Override
            public Cache<Filter, Value> call() throws Exception {
                SegmentReaderUtils.registerCoreListener(context.reader(), FixedBitSetFilterCache.this);
                return CacheBuilder.newBuilder().build();
            }
        });
        return filterToFbs.get((Filter)filter, (Callable<Value>)new Callable<Value>(){

            @Override
            public Value call() throws Exception {
                IndexShard shard;
                FixedBitSet fixedBitSet;
                DocIdSet docIdSet = filter.getDocIdSet(context, null);
                if (docIdSet instanceof FixedBitSet) {
                    fixedBitSet = (FixedBitSet)docIdSet;
                } else {
                    int doc;
                    DocIdSetIterator iterator;
                    fixedBitSet = new FixedBitSet(context.reader().maxDoc());
                    if (docIdSet != null && docIdSet != DocIdSet.EMPTY && (iterator = docIdSet.iterator()) != null && (doc = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        do {
                            fixedBitSet.set(doc);
                        } while ((doc = iterator.nextDoc()) != Integer.MAX_VALUE);
                    }
                }
                Value value = new Value(fixedBitSet, shardId);
                if (shardId != null && (shard = FixedBitSetFilterCache.this.indexService.shard(shardId.id())) != null) {
                    shard.shardFixedBitSetFilterCache().onCached(value.fixedBitSet.ramBytesUsed());
                }
                return value;
            }
        }).fixedBitSet;
    }

    @Override
    public void onRemoval(RemovalNotification<Object, Cache<Filter, Value>> notification) {
        Object key = notification.getKey();
        if (key == null) {
            return;
        }
        Cache<Filter, Value> value = notification.getValue();
        if (value == null) {
            return;
        }
        for (Map.Entry entry : value.asMap().entrySet()) {
            IndexShard shard;
            if (((Value)entry.getValue()).shardId == null || (shard = this.indexService.shard(((Value)entry.getValue()).shardId.id())) == null) continue;
            ShardFixedBitSetFilterCache shardFixedBitSetFilterCache = shard.shardFixedBitSetFilterCache();
            shardFixedBitSetFilterCache.onRemoval(((Value)entry.getValue()).fixedBitSet.ramBytesUsed());
        }
    }

    Cache<Object, Cache<Filter, Value>> getLoadedFilters() {
        return this.loadedFilters;
    }

    final class FixedBitSetFilterWarmer
    extends IndicesWarmer.Listener {
        FixedBitSetFilterWarmer() {
        }

        @Override
        public IndicesWarmer.Listener.TerminationHandle warmNewReaders(final IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            if (!FixedBitSetFilterCache.this.loadRandomAccessFiltersEagerly) {
                return IndicesWarmer.Listener.TerminationHandle.NO_WAIT;
            }
            boolean hasNested = false;
            HashSet<Filter> warmUp = new HashSet<Filter>();
            MapperService mapperService = indexShard.mapperService();
            for (DocumentMapper docMapper : mapperService.docMappers(false)) {
                if (!docMapper.hasNestedObjects()) continue;
                hasNested = true;
                for (ObjectMapper objectMapper : docMapper.objectMappers().values()) {
                    ObjectMapper parentObjectMapper;
                    if (!objectMapper.nested().isNested() || (parentObjectMapper = docMapper.findParentObjectMapper(objectMapper)) == null || !parentObjectMapper.nested().isNested()) continue;
                    warmUp.add(parentObjectMapper.nestedTypeFilter());
                }
            }
            if (hasNested) {
                warmUp.add(NonNestedDocsFilter.INSTANCE);
            }
            Executor executor = threadPool.executor(this.executor());
            final CountDownLatch latch = new CountDownLatch(context.searcher().reader().leaves().size() * warmUp.size());
            for (final AtomicReaderContext ctx : context.searcher().reader().leaves()) {
                for (final Filter filterToWarm : warmUp) {
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                long start = System.nanoTime();
                                FixedBitSetFilterCache.this.getAndLoadIfNotPresent(filterToWarm, ctx);
                                if (indexShard.warmerService().logger().isTraceEnabled()) {
                                    indexShard.warmerService().logger().trace("warmed fixed bitset for [{}], took [{}]", filterToWarm, TimeValue.timeValueNanos(System.nanoTime() - start));
                                }
                            }
                            catch (Throwable t) {
                                indexShard.warmerService().logger().warn("failed to load fixed bitset for [{}]", t, filterToWarm);
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
            }
            return new IndicesWarmer.Listener.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }

        @Override
        public IndicesWarmer.Listener.TerminationHandle warmTopReader(IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            return IndicesWarmer.Listener.TerminationHandle.NO_WAIT;
        }
    }

    final class FixedBitSetFilterWrapper
    extends FixedBitSetFilter {
        final Filter filter;

        FixedBitSetFilterWrapper(Filter filter) {
            this.filter = filter;
        }

        @Override
        public FixedBitSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            try {
                return FixedBitSetFilterCache.this.getAndLoadIfNotPresent(this.filter, context);
            }
            catch (ExecutionException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
        }

        public String toString() {
            return "random_access(" + this.filter + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof FixedBitSetFilterWrapper)) {
                return false;
            }
            return this.filter.equals(((FixedBitSetFilterWrapper)((Object)o)).filter);
        }

        public int hashCode() {
            return this.filter.hashCode() ^ 0x1117BF26;
        }
    }

    public static final class Value {
        final FixedBitSet fixedBitSet;
        final ShardId shardId;

        public Value(FixedBitSet fixedBitSet, ShardId shardId) {
            this.fixedBitSet = fixedBitSet;
            this.shardId = shardId;
        }
    }
}

