/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.meta;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.local.state.meta.LocalAllocateDangledIndices;
import org.elasticsearch.gateway.local.state.meta.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;

public class LocalGatewayMetaState
extends AbstractComponent
implements ClusterStateListener {
    private final NodeEnvironment nodeEnv;
    private final ThreadPool threadPool;
    private final LocalAllocateDangledIndices allocateDangledIndices;
    private final NodeIndexDeletedAction nodeIndexDeletedAction;
    @Nullable
    private volatile MetaData currentMetaData;
    private final XContentType format;
    private final ToXContent.Params formatParams;
    private final ToXContent.Params gatewayModeFormatParams;
    private final AutoImportDangledState autoImportDangled;
    private final TimeValue danglingTimeout;
    private final Map<String, DanglingIndex> danglingIndices = ConcurrentCollections.newConcurrentMap();
    private final Object danglingMutex = new Object();

    @Inject
    public LocalGatewayMetaState(Settings settings, ThreadPool threadPool, NodeEnvironment nodeEnv, TransportNodesListGatewayMetaState nodesListGatewayMetaState, LocalAllocateDangledIndices allocateDangledIndices, NodeIndexDeletedAction nodeIndexDeletedAction) throws Exception {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.threadPool = threadPool;
        this.format = XContentType.fromRestContentType(settings.get("format", "smile"));
        this.allocateDangledIndices = allocateDangledIndices;
        this.nodeIndexDeletedAction = nodeIndexDeletedAction;
        nodesListGatewayMetaState.init(this);
        if (this.format == XContentType.SMILE) {
            HashMap<String, String> params = Maps.newHashMap();
            params.put("binary", "true");
            this.formatParams = new ToXContent.MapParams(params);
            HashMap<String, String> gatewayModeParams = Maps.newHashMap();
            gatewayModeParams.put("binary", "true");
            gatewayModeParams.put("context_mode", MetaData.CONTEXT_MODE_GATEWAY);
            this.gatewayModeFormatParams = new ToXContent.MapParams(gatewayModeParams);
        } else {
            this.formatParams = ToXContent.EMPTY_PARAMS;
            HashMap<String, String> gatewayModeParams = Maps.newHashMap();
            gatewayModeParams.put("context_mode", MetaData.CONTEXT_MODE_GATEWAY);
            this.gatewayModeFormatParams = new ToXContent.MapParams(gatewayModeParams);
        }
        this.autoImportDangled = AutoImportDangledState.fromString(settings.get("gateway.local.auto_import_dangled", AutoImportDangledState.YES.toString()));
        this.danglingTimeout = settings.getAsTime("gateway.local.dangling_timeout", TimeValue.timeValueHours(2L));
        this.logger.debug("using gateway.local.auto_import_dangled [{}], with gateway.local.dangling_timeout [{}]", new Object[]{this.autoImportDangled, this.danglingTimeout});
        if (DiscoveryNode.masterNode(settings)) {
            try {
                this.pre019Upgrade();
                long start = System.currentTimeMillis();
                this.loadState();
                this.logger.debug("took {} to load state", TimeValue.timeValueMillis(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                this.logger.error("failed to read local state, exiting...", e, new Object[0]);
                throw e;
            }
        }
    }

    public MetaData loadMetaState() throws Exception {
        return this.loadState();
    }

    public boolean isDangling(String index) {
        return this.danglingIndices.containsKey(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().disableStatePersistence()) {
            this.currentMetaData = null;
            return;
        }
        MetaData newMetaData = event.state().metaData();
        boolean success = true;
        if (event.state().nodes().localNode().masterNode()) {
            if (this.currentMetaData == null || !MetaData.isGlobalStateEquals(this.currentMetaData, newMetaData)) {
                try {
                    this.writeGlobalState("changed", newMetaData, this.currentMetaData);
                }
                catch (Throwable e) {
                    success = false;
                }
            }
            for (IndexMetaData indexMetaData : newMetaData) {
                String writeReason = null;
                IndexMetaData currentIndexMetaData = this.currentMetaData == null ? this.loadIndex(indexMetaData.index()) : this.currentMetaData.index(indexMetaData.index());
                if (currentIndexMetaData == null) {
                    writeReason = "freshly created";
                } else if (currentIndexMetaData.version() != indexMetaData.version()) {
                    writeReason = "version changed from [" + currentIndexMetaData.version() + "] to [" + indexMetaData.version() + "]";
                }
                if (writeReason == null) continue;
                try {
                    this.writeIndex(writeReason, indexMetaData, currentIndexMetaData);
                }
                catch (Throwable e) {
                    success = false;
                }
            }
        }
        if (this.currentMetaData != null) {
            for (IndexMetaData current : this.currentMetaData) {
                if (this.danglingIndices.containsKey(current.index()) || newMetaData.hasIndex(current.index())) continue;
                this.logger.debug("[{}] deleting index that is no longer part of the metadata (indices: [{}])", current.index(), newMetaData.indices().keys());
                if (this.nodeEnv.hasNodeFile()) {
                    FileSystemUtils.deleteRecursively(this.nodeEnv.indexLocations(new Index(current.index())));
                }
                try {
                    this.nodeIndexDeletedAction.nodeIndexStoreDeleted(event.state(), current.index(), event.state().nodes().localNodeId());
                }
                catch (Throwable e) {
                    this.logger.debug("[{}] failed to notify master on local index store deletion", e, current.index());
                }
            }
        }
        if (this.nodeEnv.hasNodeFile()) {
            IndexMetaData indexMetaData;
            if (this.danglingTimeout.millis() >= 0L) {
                Object i$ = this.danglingMutex;
                synchronized (i$) {
                    for (String danglingIndex : this.danglingIndices.keySet()) {
                        if (!newMetaData.hasIndex(danglingIndex)) continue;
                        this.logger.debug("[{}] no longer dangling (created), removing", danglingIndex);
                        DanglingIndex removed = this.danglingIndices.remove(danglingIndex);
                        if (removed.future == null) continue;
                        removed.future.cancel(false);
                    }
                    try {
                        for (String indexName : this.nodeEnv.findAllIndices()) {
                            if (newMetaData.hasIndex(indexName) || this.danglingIndices.containsKey(indexName) || (indexMetaData = this.loadIndex(indexName)) == null) continue;
                            if (this.autoImportDangled.shouldImport()) {
                                this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, auto import to cluster state [{}]", new Object[]{indexName, this.autoImportDangled});
                                this.danglingIndices.put(indexName, new DanglingIndex(indexName, null));
                                continue;
                            }
                            if (this.danglingTimeout.millis() == 0L) {
                                this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, timeout set to 0, deleting now", indexName);
                                FileSystemUtils.deleteRecursively(this.nodeEnv.indexLocations(new Index(indexName)));
                                continue;
                            }
                            this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, scheduling to delete in [{}], auto import to cluster state [{}]", new Object[]{indexName, this.danglingTimeout, this.autoImportDangled});
                            this.danglingIndices.put(indexName, new DanglingIndex(indexName, this.threadPool.schedule(this.danglingTimeout, "same", new RemoveDanglingIndex(indexName))));
                        }
                    }
                    catch (Throwable e) {
                        this.logger.warn("failed to find dangling indices", e, new Object[0]);
                    }
                }
            }
            if (this.autoImportDangled.shouldImport() && !this.danglingIndices.isEmpty()) {
                ArrayList<IndexMetaData> dangled = Lists.newArrayList();
                for (String indexName : this.danglingIndices.keySet()) {
                    indexMetaData = this.loadIndex(indexName);
                    if (indexMetaData == null) {
                        this.logger.debug("failed to find state for dangling index [{}]", indexName);
                        continue;
                    }
                    if (!indexMetaData.index().equals(indexName)) {
                        this.logger.info("dangled index directory name is [{}], state name is [{}], renaming to directory name", indexName, indexMetaData.index());
                        indexMetaData = IndexMetaData.builder(indexMetaData).index(indexName).build();
                    }
                    if (this.autoImportDangled == AutoImportDangledState.CLOSED) {
                        indexMetaData = IndexMetaData.builder(indexMetaData).state(IndexMetaData.State.CLOSE).build();
                    }
                    if (indexMetaData == null) continue;
                    dangled.add(indexMetaData);
                }
                IndexMetaData[] dangledIndices = dangled.toArray(new IndexMetaData[dangled.size()]);
                try {
                    this.allocateDangledIndices.allocateDangled(dangledIndices, new LocalAllocateDangledIndices.Listener(){

                        @Override
                        public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse response) {
                            LocalGatewayMetaState.this.logger.trace("allocated dangled", new Object[0]);
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            LocalGatewayMetaState.this.logger.info("failed to send allocated dangled", e, new Object[0]);
                        }
                    });
                }
                catch (Throwable e) {
                    this.logger.warn("failed to send allocate dangled", e, new Object[0]);
                }
            }
        }
        if (success) {
            this.currentMetaData = newMetaData;
        }
    }

    private void deleteIndex(String index) {
        File[] indexLocations;
        this.logger.trace("[{}] delete index state", index);
        for (File indexLocation : indexLocations = this.nodeEnv.indexLocations(new Index(index))) {
            if (!indexLocation.exists()) continue;
            FileSystemUtils.deleteRecursively(new File(indexLocation, "_state"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(String reason, IndexMetaData indexMetaData, @Nullable IndexMetaData previousIndexMetaData) throws Exception {
        this.logger.trace("[{}] writing state, reason [{}]", indexMetaData.index(), reason);
        XContentBuilder builder = XContentFactory.contentBuilder(this.format, new BytesStreamOutput());
        builder.startObject();
        IndexMetaData.Builder.toXContent(indexMetaData, builder, this.formatParams);
        builder.endObject();
        builder.flush();
        String stateFileName = "state-" + indexMetaData.version();
        Throwable lastFailure = null;
        boolean wroteAtLeastOnce = false;
        for (File indexLocation : this.nodeEnv.indexLocations(new Index(indexMetaData.index()))) {
            File stateLocation = new File(indexLocation, "_state");
            FileSystemUtils.mkdirs(stateLocation);
            File stateFile = new File(stateLocation, stateFileName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(stateFile);
                BytesReference bytes = builder.bytes();
                bytes.writeTo(fos);
                fos.getChannel().force(true);
                fos.close();
                wroteAtLeastOnce = true;
            }
            catch (Throwable e) {
                try {
                    lastFailure = e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
                continue;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
        }
        if (!wroteAtLeastOnce) {
            this.logger.warn("[{}]: failed to write index state", lastFailure, indexMetaData.index());
            throw new IOException("failed to write state for [" + indexMetaData.index() + "]", lastFailure);
        }
        if (previousIndexMetaData != null && previousIndexMetaData.version() != indexMetaData.version()) {
            for (File indexLocation : this.nodeEnv.indexLocations(new Index(indexMetaData.index()))) {
                File[] files = new File(indexLocation, "_state").listFiles();
                if (files == null) continue;
                for (File file : files) {
                    if (!file.getName().startsWith("state-") || file.getName().equals(stateFileName)) continue;
                    file.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGlobalState(String reason, MetaData metaData, @Nullable MetaData previousMetaData) throws Exception {
        this.logger.trace("[_global] writing state, reason [{}]", reason);
        XContentBuilder builder = XContentFactory.contentBuilder(this.format);
        builder.startObject();
        MetaData.Builder.toXContent(metaData, builder, this.gatewayModeFormatParams);
        builder.endObject();
        builder.flush();
        String globalFileName = "global-" + metaData.version();
        Throwable lastFailure = null;
        boolean wroteAtLeastOnce = false;
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File stateLocation = new File(dataLocation, "_state");
            FileSystemUtils.mkdirs(stateLocation);
            File stateFile = new File(stateLocation, globalFileName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(stateFile);
                BytesReference bytes = builder.bytes();
                bytes.writeTo(fos);
                fos.getChannel().force(true);
                fos.close();
                wroteAtLeastOnce = true;
            }
            catch (Throwable e) {
                try {
                    lastFailure = e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
                continue;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
        }
        if (!wroteAtLeastOnce) {
            this.logger.warn("[_global]: failed to write global state", lastFailure, new Object[0]);
            throw new IOException("failed to write global state", lastFailure);
        }
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] files = new File(dataLocation, "_state").listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!file.getName().startsWith("global-") || file.getName().equals(globalFileName)) continue;
                file.delete();
            }
        }
    }

    private MetaData loadState() throws Exception {
        MetaData globalMetaData = this.loadGlobalState();
        MetaData.Builder metaDataBuilder = globalMetaData != null ? MetaData.builder(globalMetaData) : MetaData.builder();
        Set<String> indices = this.nodeEnv.findAllIndices();
        for (String index : indices) {
            IndexMetaData indexMetaData = this.loadIndex(index);
            if (indexMetaData == null) {
                this.logger.debug("[{}] failed to find metadata for existing index location", index);
                continue;
            }
            metaDataBuilder.put(indexMetaData, false);
        }
        return metaDataBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IndexMetaData loadIndex(String index) {
        long highestVersion = -1L;
        IndexMetaData indexMetaData = null;
        for (File indexLocation : this.nodeEnv.indexLocations(new Index(index))) {
            File[] stateFiles;
            File stateDir = new File(indexLocation, "_state");
            if (!stateDir.exists() || !stateDir.isDirectory() || (stateFiles = stateDir.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                if (!stateFile.getName().startsWith("state-")) continue;
                try {
                    long version = Long.parseLong(stateFile.getName().substring("state-".length()));
                    if (version <= highestVersion) continue;
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) {
                        this.logger.debug("[{}]: no data for [" + stateFile.getAbsolutePath() + "], ignoring...", index);
                        continue;
                    }
                    try (XContentParser parser = null;){
                        parser = XContentHelper.createParser(data, 0, data.length);
                        parser.nextToken();
                        indexMetaData = IndexMetaData.Builder.fromXContent(parser);
                        highestVersion = version;
                    }
                }
                catch (Throwable e) {
                    this.logger.debug("[{}]: failed to read [" + stateFile.getAbsolutePath() + "], ignoring...", e, index);
                }
            }
        }
        return indexMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaData loadGlobalState() {
        long highestVersion = -1L;
        MetaData metaData = null;
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] stateFiles;
            File stateLocation = new File(dataLocation, "_state");
            if (!stateLocation.exists() || (stateFiles = stateLocation.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                String name = stateFile.getName();
                if (!name.startsWith("global-")) continue;
                try {
                    long version = Long.parseLong(stateFile.getName().substring("global-".length()));
                    if (version <= highestVersion) continue;
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) {
                        this.logger.debug("[_global] no data for [" + stateFile.getAbsolutePath() + "], ignoring...", new Object[0]);
                        continue;
                    }
                    try (XContentParser parser = null;){
                        parser = XContentHelper.createParser(data, 0, data.length);
                        metaData = MetaData.Builder.fromXContent(parser);
                        highestVersion = version;
                    }
                }
                catch (Throwable e) {
                    this.logger.debug("failed to load global state from [{}]", e, stateFile.getAbsolutePath());
                }
            }
        }
        return metaData;
    }

    private void pre019Upgrade() throws Exception {
        long index = -1L;
        File metaDataFile = null;
        MetaData metaData = null;
        long version = -1L;
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] stateFiles;
            File stateLocation = new File(dataLocation, "_state");
            if (!stateLocation.exists() || (stateFiles = stateLocation.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                long fileIndex;
                String name;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[upgrade]: processing [" + stateFile.getName() + "]", new Object[0]);
                }
                if (!(name = stateFile.getName()).startsWith("metadata-") || (fileIndex = Long.parseLong(name.substring(name.indexOf(45) + 1))) < index) continue;
                try {
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) continue;
                    try (XContentParser parser = XContentHelper.createParser(data, 0, data.length);){
                        String currentFieldName = null;
                        XContentParser.Token token = parser.nextToken();
                        if (token != null) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    currentFieldName = parser.currentName();
                                    continue;
                                }
                                if (token == XContentParser.Token.START_OBJECT) {
                                    if (!"meta-data".equals(currentFieldName)) continue;
                                    metaData = MetaData.Builder.fromXContent(parser);
                                    continue;
                                }
                                if (!token.isValue() || !"version".equals(currentFieldName)) continue;
                                version = parser.longValue();
                            }
                        }
                    }
                    index = fileIndex;
                    metaDataFile = stateFile;
                }
                catch (IOException e) {
                    this.logger.warn("failed to read pre 0.19 state from [" + name + "], ignoring...", e, new Object[0]);
                }
            }
        }
        if (metaData == null) {
            return;
        }
        this.logger.info("found old metadata state, loading metadata from [{}] and converting to new metadata location and strucutre...", metaDataFile.getAbsolutePath());
        this.writeGlobalState("upgrade", MetaData.builder(metaData).version(version).build(), null);
        for (IndexMetaData indexMetaData : metaData) {
            IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(indexMetaData).version(version);
            indexMetaDataBuilder.settings(ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).put("index.version.created", Version.V_0_18_0));
            this.writeIndex("upgrade", indexMetaDataBuilder.build(), null);
        }
        File backupFile = new File(metaDataFile.getParentFile(), "backup-" + metaDataFile.getName());
        if (!metaDataFile.renameTo(backupFile)) {
            throw new IOException("failed to rename old state to backup state [" + metaDataFile.getAbsolutePath() + "]");
        }
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] stateFiles;
            File stateLocation = new File(dataLocation, "_state");
            if (!stateLocation.exists() || (stateFiles = stateLocation.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                String name = stateFile.getName();
                if (!name.startsWith("metadata-")) continue;
                stateFile.delete();
            }
        }
        this.logger.info("conversion to new metadata location and format done, backup create at [{}]", backupFile.getAbsolutePath());
    }

    static class DanglingIndex {
        public final String index;
        public final ScheduledFuture future;

        DanglingIndex(String index, ScheduledFuture future) {
            this.index = index;
            this.future = future;
        }
    }

    class RemoveDanglingIndex
    implements Runnable {
        private final String index;

        RemoveDanglingIndex(String index) {
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LocalGatewayMetaState.this.danglingMutex;
            synchronized (object) {
                DanglingIndex remove = (DanglingIndex)LocalGatewayMetaState.this.danglingIndices.remove(this.index);
                if (remove == null) {
                    return;
                }
                LocalGatewayMetaState.this.logger.info("[{}] deleting dangling index", this.index);
                FileSystemUtils.deleteRecursively(LocalGatewayMetaState.this.nodeEnv.indexLocations(new Index(this.index)));
            }
        }
    }

    static enum AutoImportDangledState {
        NO{

            @Override
            public boolean shouldImport() {
                return false;
            }
        }
        ,
        YES{

            @Override
            public boolean shouldImport() {
                return true;
            }
        }
        ,
        CLOSED{

            @Override
            public boolean shouldImport() {
                return true;
            }
        };


        public abstract boolean shouldImport();

        public static AutoImportDangledState fromString(String value) {
            if ("no".equalsIgnoreCase(value)) {
                return NO;
            }
            if ("yes".equalsIgnoreCase(value)) {
                return YES;
            }
            if ("closed".equalsIgnoreCase(value)) {
                return CLOSED;
            }
            throw new ElasticsearchIllegalArgumentException("failed to parse [" + value + "], not a valid auto dangling import type");
        }
    }
}

