/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public class RandomScoreFunction
extends ScoreFunction {
    private int originalSeed;
    private int saltedSeed;
    private final IndexFieldData<?> uidFieldData;
    private SortedBinaryDocValues uidByteData;

    public RandomScoreFunction() {
        super(CombineFunction.MULT);
        this.uidFieldData = null;
    }

    public RandomScoreFunction(int seed, int salt, IndexFieldData<?> uidFieldData) {
        super(CombineFunction.MULT);
        this.originalSeed = seed;
        this.saltedSeed = seed ^ salt;
        this.uidFieldData = uidFieldData;
        if (uidFieldData == null) {
            throw new NullPointerException("uid missing");
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext context) {
        Object leafData = this.uidFieldData.load(context);
        this.uidByteData = leafData.getBytesValues();
        if (this.uidByteData == null) {
            throw new NullPointerException("failed to get uid byte data");
        }
    }

    @Override
    public double score(int docId, float subQueryScore) {
        this.uidByteData.setDocument(docId);
        int hash = StringHelper.murmurhash3_x86_32((BytesRef)this.uidByteData.valueAt(0), (int)this.saltedSeed);
        return (float)(hash & 0xFFFFFF) / 1.6777216E7f;
    }

    @Override
    public Explanation explainScore(int docId, float subQueryScore) {
        Explanation exp = new Explanation();
        exp.setDescription("random score function (seed: " + this.originalSeed + ")");
        return exp;
    }
}

