/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.instance.TransportInstanceSingleOperationAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    private final TransportDeleteAction deleteAction;
    private final TransportIndexAction indexAction;
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;
    private final UpdateHelper updateHelper;
    private final IndicesService indicesService;

    @Inject
    public TransportUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, TransportIndexAction indexAction, TransportDeleteAction deleteAction, TransportCreateIndexAction createIndexAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndicesService indicesService) {
        super(settings, "indices:data/write/update", threadPool, clusterService, transportService, actionFilters);
        this.indexAction = indexAction;
        this.deleteAction = deleteAction;
        this.createIndexAction = createIndexAction;
        this.updateHelper = updateHelper;
        this.indicesService = indicesService;
        this.autoCreateIndex = new AutoCreateIndex(settings);
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected UpdateRequest newRequest() {
        return new UpdateRequest();
    }

    @Override
    protected UpdateResponse newResponse() {
        return new UpdateResponse();
    }

    @Override
    protected boolean retryOnFailure(Throwable e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    @Override
    protected boolean resolveRequest(ClusterState state, TransportInstanceSingleOperationAction.InternalRequest request, ActionListener<UpdateResponse> listener) {
        ((UpdateRequest)request.request()).routing(state.metaData().resolveIndexRouting(((UpdateRequest)request.request()).routing(), ((UpdateRequest)request.request()).index()));
        if (((UpdateRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((UpdateRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((UpdateRequest)request.request()).type(), ((UpdateRequest)request.request()).id());
        }
        return true;
    }

    @Override
    protected void doExecute(final UpdateRequest request, final ActionListener<UpdateResponse> listener) {
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            request.beforeLocalFork();
            this.createIndexAction.execute(new CreateIndexRequest(request).index(request.index()).cause("auto(update api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportUpdateAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        try {
                            TransportUpdateAction.this.innerExecute(request, listener);
                        }
                        catch (Throwable e1) {
                            listener.onFailure(e1);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    private void innerExecute(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, TransportInstanceSingleOperationAction.InternalRequest request) throws ElasticsearchException {
        ShardRouting shard;
        if (((UpdateRequest)request.request()).shardId() != -1) {
            return clusterState.routingTable().index(request.concreteIndex()).shard(((UpdateRequest)request.request()).shardId()).primaryShardIt();
        }
        ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(clusterState, request.concreteIndex(), ((UpdateRequest)request.request()).type(), ((UpdateRequest)request.request()).id(), ((UpdateRequest)request.request()).routing());
        while ((shard = shardIterator.nextOrNull()) != null) {
            if (!shard.primary()) continue;
            return new PlainShardIterator(shardIterator.shardId(), ImmutableList.of(shard));
        }
        return new PlainShardIterator(shardIterator.shardId(), ImmutableList.of());
    }

    @Override
    protected void shardOperation(TransportInstanceSingleOperationAction.InternalRequest request, ActionListener<UpdateResponse> listener) throws ElasticsearchException {
        this.shardOperation(request, listener, 0);
    }

    protected void shardOperation(final TransportInstanceSingleOperationAction.InternalRequest request, final ActionListener<UpdateResponse> listener, final int retryCount) throws ElasticsearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.concreteIndex());
        IndexShard indexShard = indexService.shardSafe(((UpdateRequest)request.request()).shardId());
        final UpdateHelper.Result result = this.updateHelper.prepare((UpdateRequest)request.request(), indexShard);
        switch (result.operation()) {
            case UPSERT: {
                IndexRequest upsertRequest = new IndexRequest((IndexRequest)result.action(), (ActionRequest)request.request());
                final BytesReference upsertSourceBytes = upsertRequest.source();
                this.indexAction.execute(upsertRequest, new ActionListener<IndexResponse>(){

                    @Override
                    public void onResponse(IndexResponse response) {
                        UpdateResponse update = new UpdateResponse(response.getIndex(), response.getType(), response.getId(), response.getVersion(), response.isCreated());
                        if (((UpdateRequest)request.request()).fields() != null && ((UpdateRequest)request.request()).fields().length > 0) {
                            Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(upsertSourceBytes, true);
                            update.setGetResult(TransportUpdateAction.this.updateHelper.extractGetResult((UpdateRequest)request.request(), request.concreteIndex(), response.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), upsertSourceBytes));
                        } else {
                            update.setGetResult(null);
                        }
                        listener.onResponse(update);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        if (((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException || e instanceof DocumentAlreadyExistsException) && retryCount < ((UpdateRequest)request.request()).retryOnConflict()) {
                            TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new ActionRunnable<UpdateResponse>(listener){

                                @Override
                                protected void doRun() {
                                    TransportUpdateAction.this.shardOperation(request, this.listener, retryCount + 1);
                                }
                            });
                            return;
                        }
                        listener.onFailure(e);
                    }
                });
                break;
            }
            case INDEX: {
                IndexRequest indexRequest = new IndexRequest((IndexRequest)result.action(), (ActionRequest)request.request());
                final BytesReference indexSourceBytes = indexRequest.source();
                this.indexAction.execute(indexRequest, new ActionListener<IndexResponse>(){

                    @Override
                    public void onResponse(IndexResponse response) {
                        UpdateResponse update = new UpdateResponse(response.getIndex(), response.getType(), response.getId(), response.getVersion(), response.isCreated());
                        update.setGetResult(TransportUpdateAction.this.updateHelper.extractGetResult((UpdateRequest)request.request(), request.concreteIndex(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), indexSourceBytes));
                        listener.onResponse(update);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        if ((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException && retryCount < ((UpdateRequest)request.request()).retryOnConflict()) {
                            TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new ActionRunnable<UpdateResponse>(listener){

                                @Override
                                protected void doRun() {
                                    TransportUpdateAction.this.shardOperation(request, this.listener, retryCount + 1);
                                }
                            });
                            return;
                        }
                        listener.onFailure(e);
                    }
                });
                break;
            }
            case DELETE: {
                DeleteRequest deleteRequest = new DeleteRequest((DeleteRequest)result.action(), (ActionRequest)request.request());
                this.deleteAction.execute(deleteRequest, new ActionListener<DeleteResponse>(){

                    @Override
                    public void onResponse(DeleteResponse response) {
                        UpdateResponse update = new UpdateResponse(response.getIndex(), response.getType(), response.getId(), response.getVersion(), false);
                        update.setGetResult(TransportUpdateAction.this.updateHelper.extractGetResult((UpdateRequest)request.request(), request.concreteIndex(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), null));
                        listener.onResponse(update);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        if ((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException && retryCount < ((UpdateRequest)request.request()).retryOnConflict()) {
                            TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new ActionRunnable<UpdateResponse>(listener){

                                @Override
                                protected void doRun() {
                                    TransportUpdateAction.this.shardOperation(request, this.listener, retryCount + 1);
                                }
                            });
                            return;
                        }
                        listener.onFailure(e);
                    }
                });
                break;
            }
            case NONE: {
                IndexShard shard;
                UpdateResponse update = (UpdateResponse)result.action();
                IndexService indexServiceOrNull = this.indicesService.indexService(request.concreteIndex());
                if (indexServiceOrNull != null && (shard = indexService.shard(((UpdateRequest)request.request()).shardId())) != null) {
                    shard.indexingService().noopUpdate(((UpdateRequest)request.request()).type());
                }
                listener.onResponse(update);
                break;
            }
            default: {
                throw new ElasticsearchIllegalStateException("Illegal operation " + (Object)((Object)result.operation()));
            }
        }
    }
}

