/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.optimize;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OptimizeRequest
extends BroadcastOperationRequest<OptimizeRequest> {
    private boolean waitForMerge = true;
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private boolean upgrade = false;

    public OptimizeRequest(String ... indices) {
        super(indices);
    }

    public OptimizeRequest() {
    }

    public boolean waitForMerge() {
        return this.waitForMerge;
    }

    public OptimizeRequest waitForMerge(boolean waitForMerge) {
        this.waitForMerge = waitForMerge;
        return this;
    }

    public int maxNumSegments() {
        return this.maxNumSegments;
    }

    public OptimizeRequest maxNumSegments(int maxNumSegments) {
        this.maxNumSegments = maxNumSegments;
        return this;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public OptimizeRequest onlyExpungeDeletes(boolean onlyExpungeDeletes) {
        this.onlyExpungeDeletes = onlyExpungeDeletes;
        return this;
    }

    public boolean flush() {
        return this.flush;
    }

    public OptimizeRequest flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    @Deprecated
    public boolean force() {
        return this.upgrade;
    }

    @Deprecated
    public OptimizeRequest force(boolean force) {
        this.upgrade = force;
        return this;
    }

    public boolean upgrade() {
        return this.upgrade;
    }

    public OptimizeRequest upgrade(boolean upgrade) {
        this.upgrade = upgrade;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.waitForMerge = in.readBoolean();
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
            this.upgrade = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.waitForMerge);
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            out.writeBoolean(this.upgrade);
        }
    }

    public static final class Defaults {
        public static final boolean WAIT_FOR_MERGE = true;
        public static final int MAX_NUM_SEGMENTS = -1;
        public static final boolean ONLY_EXPUNGE_DELETES = false;
        public static final boolean FLUSH = true;
        public static final boolean UPGRADE = false;
    }
}

