/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.team.internal.ui.synchronize.actions.OpenWithActionGroup;
import org.eclipse.team.internal.ui.synchronize.actions.RefactorActionGroup;
import org.eclipse.team.internal.ui.synchronize.actions.SyncViewerShowPreferencesAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;

public class DefaultSynchronizePageActions
extends SynchronizePageActionGroup {
    private OpenWithActionGroup openWithActions;
    private RefactorActionGroup refactorActions;
    private SyncViewerShowPreferencesAction showPreferences;

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        ISynchronizePageSite site = configuration.getSite();
        IWorkbenchSite ws = site.getWorkbenchSite();
        if (ws instanceof IViewSite) {
            this.openWithActions = new OpenWithActionGroup(site, configuration.getParticipant(), true);
            this.refactorActions = new RefactorActionGroup(site);
            configuration.setProperty("org.eclipse.team.ui.P_OPEN_ACTION", new Action(){

                public void run() {
                    DefaultSynchronizePageActions.this.openWithActions.openInCompareEditor();
                }
            });
            this.showPreferences = new SyncViewerShowPreferencesAction(configuration);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openWithActions != null) {
            this.openWithActions.fillActionBars(actionBars);
        }
        if (this.refactorActions != null) {
            this.refactorActions.fillActionBars(actionBars);
        }
        if (actionBars != null && this.showPreferences != null) {
            IMenuManager menu = actionBars.getMenuManager();
            this.appendToGroup((IContributionManager)menu, "preferences", (IAction)this.showPreferences);
        }
    }

    public void updateActionBars() {
        if (this.openWithActions != null) {
            this.openWithActions.updateActionBars();
        }
        if (this.refactorActions != null) {
            this.refactorActions.updateActionBars();
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        IContributionItem fileGroup = this.findGroup((IContributionManager)manager, "file");
        if (this.openWithActions != null && fileGroup != null) {
            this.openWithActions.fillContextMenu(manager, fileGroup.getId());
        }
        IContributionItem editGroup = this.findGroup((IContributionManager)manager, "edit");
        if (this.refactorActions != null && editGroup != null) {
            this.refactorActions.fillContextMenu(manager, editGroup.getId());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.refactorActions != null) {
            this.refactorActions.dispose();
        }
        if (this.openWithActions != null) {
            this.openWithActions.dispose();
        }
    }

    public void setContext(ActionContext context) {
        if (this.openWithActions != null) {
            this.openWithActions.setContext(context);
        }
        if (this.refactorActions != null) {
            this.refactorActions.setContext(context);
        }
    }
}

