/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.itarget.ITargetObject;
import org.eclipse.pde.internal.core.util.CoreUtility;

public abstract class TargetObject
extends PlatformObject
implements ITargetObject {
    private transient ITargetModel fModel;

    public TargetObject(ITargetModel model) {
        this.fModel = model;
    }

    public ITargetModel getModel() {
        return this.fModel;
    }

    public void setModel(ITargetModel model) {
        this.fModel = model;
    }

    public ITarget getTarget() {
        return this.getModel().getTarget();
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this.firePropertyChanged(this, property, oldValue, newValue);
    }

    protected void firePropertyChanged(ITargetObject object, String property, Object oldValue, Object newValue) {
        if (this.fModel.isEditable()) {
            ITargetModel provider = this.fModel;
            provider.fireModelObjectChanged(object, property, oldValue, newValue);
        }
    }

    protected void fireStructureChanged(ITargetObject child, int changeType) {
        this.fireStructureChanged(new ITargetObject[]{child}, changeType);
    }

    protected void fireStructureChanged(ITargetObject[] children, int changeType) {
        if (this.fModel.isEditable()) {
            ITargetModel provider = this.fModel;
            provider.fireModelChanged(new ModelChangedEvent(provider, changeType, children, null));
        }
    }

    protected boolean isEditable() {
        return this.getModel().isEditable();
    }

    public String getWritableString(String source) {
        return CoreUtility.getWritableString(source);
    }
}

